"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsRedrive = void 0;
const path_1 = require("path");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const core_1 = require("@aws-cdk/core");
/**
 * A construct that encompasses a Lambda Function that will move all messages from a source queue (dlq) to a destination queue (main).
 */
class SqsRedrive extends core_1.Construct {
    /**
     *
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        this.redriveFunction = new aws_lambda_nodejs_1.NodejsFunction(this, `${id}-queue-redrive`, {
            functionName: id,
            entry: path_1.join(__dirname, 'sqs-redrive.queue-redrive.ts'),
            ...props.lambdaProps,
            environment: {
                QUEUE_URL: props.mainQueue.queueUrl,
                DLQ_URL: props.deadLetterQueue.queueUrl,
                ...(_a = props === null || props === void 0 ? void 0 : props.lambdaProps) === null || _a === void 0 ? void 0 : _a.environment,
            },
        });
        props.deadLetterQueue.grantConsumeMessages(this.redriveFunction);
        props.mainQueue.grantSendMessages(this.redriveFunction);
    }
}
exports.SqsRedrive = SqsRedrive;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLXJlZHJpdmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvc3FzLXJlZHJpdmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQTRCO0FBRTVCLGtFQUFpRjtBQUVqRix3Q0FBMEM7Ozs7QUEwQjFDLE1BQWEsVUFBVyxTQUFRLGdCQUFTOzs7O0lBTXZDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBc0I7O1FBQzlELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLGtDQUFjLENBQUMsSUFBSSxFQUFFLEdBQUcsRUFBRSxnQkFBZ0IsRUFBRTtZQUNyRSxZQUFZLEVBQUUsRUFBRTtZQUNoQixLQUFLLEVBQUUsV0FBSSxDQUFDLFNBQVMsRUFBRSw4QkFBOEIsQ0FBQztZQUN0RCxHQUFHLEtBQUssQ0FBQyxXQUFXO1lBQ3BCLFdBQVcsRUFBRTtnQkFDWCxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVMsQ0FBQyxRQUFRO2dCQUNuQyxPQUFPLEVBQUUsS0FBSyxDQUFDLGVBQWdCLENBQUMsUUFBUTtnQkFDeEMsU0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsV0FBVywwQ0FBRSxXQUFXO2FBQ25DO1NBRUYsQ0FBQyxDQUFDO1FBRUgsS0FBSyxDQUFDLGVBQWUsQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7UUFDakUsS0FBSyxDQUFDLFNBQVMsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7SUFFMUQsQ0FBQztDQUNGO0FBekJELGdDQXlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGpvaW4gfSBmcm9tICdwYXRoJztcbmltcG9ydCB7IElGdW5jdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgTm9kZWpzRnVuY3Rpb24sIE5vZGVqc0Z1bmN0aW9uUHJvcHMgfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhLW5vZGVqcyc7XG5pbXBvcnQgeyBJUXVldWUgfSBmcm9tICdAYXdzLWNkay9hd3Mtc3FzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgU3FzUmVkcml2ZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVhZExldHRlclF1ZXVlOiBJUXVldWU7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWFpblF1ZXVlOiBJUXVldWU7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbGFtYmRhUHJvcHM/OiBOb2RlanNGdW5jdGlvblByb3BzO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU3FzUmVkcml2ZSBleHRlbmRzIENvbnN0cnVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVkcml2ZUZ1bmN0aW9uOiBJRnVuY3Rpb247XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFNxc1JlZHJpdmVQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnJlZHJpdmVGdW5jdGlvbiA9IG5ldyBOb2RlanNGdW5jdGlvbih0aGlzLCBgJHtpZH0tcXVldWUtcmVkcml2ZWAsIHtcbiAgICAgIGZ1bmN0aW9uTmFtZTogaWQsXG4gICAgICBlbnRyeTogam9pbihfX2Rpcm5hbWUsICdzcXMtcmVkcml2ZS5xdWV1ZS1yZWRyaXZlLnRzJyksXG4gICAgICAuLi5wcm9wcy5sYW1iZGFQcm9wcyxcbiAgICAgIGVudmlyb25tZW50OiB7XG4gICAgICAgIFFVRVVFX1VSTDogcHJvcHMubWFpblF1ZXVlLnF1ZXVlVXJsLFxuICAgICAgICBETFFfVVJMOiBwcm9wcy5kZWFkTGV0dGVyUXVldWUhLnF1ZXVlVXJsLFxuICAgICAgICAuLi5wcm9wcz8ubGFtYmRhUHJvcHM/LmVudmlyb25tZW50LFxuICAgICAgfSxcblxuICAgIH0pO1xuXG4gICAgcHJvcHMuZGVhZExldHRlclF1ZXVlLmdyYW50Q29uc3VtZU1lc3NhZ2VzKHRoaXMucmVkcml2ZUZ1bmN0aW9uKTtcbiAgICBwcm9wcy5tYWluUXVldWUuZ3JhbnRTZW5kTWVzc2FnZXModGhpcy5yZWRyaXZlRnVuY3Rpb24pO1xuXG4gIH1cbn1cbiJdfQ==