"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws = require('aws-sdk'); // eslint-disable-line
const sqs = new aws.SQS();
exports.handler = async (event) => {
    // Log the event argument for debugging and for use in local development.
    console.log(JSON.stringify(event, undefined, 2));
    while (true) {
        try {
            // Use long polling to avoid empty message responses
            const receiveParams = {
                QueueUrl: process.env.DLQ_URL,
                MaxNumberOfMessages: 10,
                WaitTimeSeconds: 1,
            };
            // Get messages from the DLQ
            // Continue looping until no more messages are left
            const DLQMessages = await sqs.receiveMessage(receiveParams).promise();
            if (!DLQMessages.Messages || DLQMessages.Messages.length === 0) {
                console.log(`NO MESSAGES FOUND IN ${process.env.DLQ_URL}`);
                // Exit the loop since there aren't any messages left
                break;
            }
            console.log(`RECEIVED ${DLQMessages.Messages.length} MESSAGES`);
            for (const message of DLQMessages.Messages) {
                // Send message to original queue
                const outboundMessage = {
                    MessageBody: message.Body,
                    QueueUrl: process.env.QUEUE_URL,
                };
                console.log(`SENDING: ${JSON.stringify(outboundMessage, null, 2)}`);
                await sqs.sendMessage(outboundMessage).promise();
                console.log('SEND MESSAGE SUCCEEDED');
                // Delete message from DLQ
                const deleteParams = {
                    QueueUrl: process.env.DLQ_URL,
                    ReceiptHandle: message.ReceiptHandle,
                };
                console.log(`DELETING: ${JSON.stringify(deleteParams, null, 2)}`);
                await sqs.deleteMessage(deleteParams).promise();
                console.log('DELETE MESSAGE SUCCEEDED');
            }
        }
        catch (err) {
            console.log(`AN ERROR OCCURRED: ${err.message}`);
            console.log(JSON.stringify(err, null, 2));
            throw err;
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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