# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['oc_graphenricher',
 'oc_graphenricher.APIs',
 'oc_graphenricher.enricher',
 'oc_graphenricher.instancematching']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['test = scripts:test']}

setup_kwargs = {
    'name': 'oc-graphenricher',
    'version': '0.2.0',
    'description': 'A tool to enrich any OCDM compliant Knowledge Graph, finding new identifiers and deduplicating entities',
    'long_description': '<p align="center">\n\n  <h2 align="center">GraphEnricher</h3>\n  <p align="center">\n    A tool to enrich any <a href="http://opencitations.net/model">OCDM</a> compliant Knowledge Graph, finding new identifiers\nand deduplicating entities.\n</p>\n\n<!-- TABLE OF CONTENTS -->\n  <summary><h2 style="display: inline-block">Table of Contents</h2></summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n    </li>\n    <li><a href="#usage">Usage</a></li>\n    <li><a href="#license">License</a></li>\n    <li><a href="#contact">Contact</a></li>\n    <li><a href="#acknowledgements">Acknowledgements</a></li>\n  </ol>\n\n\n\n<!-- ABOUT THE PROJECT -->\n## About The Project\n\nThis tool is divided in two part: an Enricher component responsible to find new identifiers and adding them to the \ngraph set, and an InstanceMatching component responsible to deduplicate any entity that share the same identifier.\n### Enricher\nThe enricher iterates each Bibliographic Resources (BRs) contained in the graph set.\nFor each Bibliographic Resources (BRs) (avoiding issues and journals), get the list of the identifiers already\ncontained in the graph set and check if it already has a DOI, an ISSN and a Wikidata ID:\n- If an ISSN is specified, it query Crossref to extract other ISSNs\n- If there\'s no DOI, it query Crossref to get one by means of all the other data extracted\n- If there\'s no Wikidata ID, it query Wikidata to get one by means of all the other identifiers\n\nAny new identifier found will be added to the BR.\n  \nThen, for each Agent Role (AR) related to the BR, get the list of all the identifier already contained and:\n- If doesn\'t have an ORCID, it query ORCID to get it\n- If doesn\'t have a VIAF, it query VIAF to get it\n- If doesn\'t have a Wikidata ID, it query Wikidata by means of all the other identifier to get one\n- If the Agent Role (AR) is related to a publisher, it query Crossref to get its ID by means of its DOI\n\nAny new identifier found will be added to the AR.\n\nIn the end it will store a new graph set and its provenance.\n\nNB: Even if it\'s not possible to have an identifier duplicated for the same entity, it\'s possible that in\nthe whole graph set you could find different identifiers that share the same schema and literal. For this\npurpose, you should use the **instancematching** module after that you\'ve enriched the graph set.\n\nActually there are 4 external API involved:\n- Crossref (DOI, ISSN)\n- ORCID\n- VIAF\n- WikiData \n\nIt\'s possible, anyway, to extend the class QueryInterface to add any other useful API.\n\n### Instance Matching\nThe instance matching process is articulated in three sequential step:\n- match the Responsible Agents (RAs)\n- match the Bibliographic Resources (BRs) \n- match the IDs\n\n#### Matching the Responsible Agents (RAs) \nDiscover all the Responsible Agents (RAs)  that share the same identifier\'s literal, creating a graph of\nthem. Then merge each connected component (cluster of Responsible Agents (RAs)  linked by the same identifier)\ninto one.\nFor each couple of Responsible Agent (RA) that are going to be merged, substitute the references of the\nResponsible Agent (RA) that will no longer exist, by removing the Responsible Agent (RA)\nfrom each of its referred Agent Role (AR) and add, instead, the merged one)\n\nIf the Responsible Agent (RA) linked by the Agent Role (AR) that will no longer exist is not linked by any\nother Agent Role (AR), then it will be marked as to be deleted, otherwise not.\n\nIn the end, generate the provenance and commit pending changes in the graph set\n\n#### Matching the Bibliographic Resources (BRs) \n\nDiscover all the Bibliographic Resources (BRs)  that share the same identifier\'s literal, creating a graph of them.\nThen merge each connected component (cluster of Be Responsible Agents (RA) associated to the Rs linked by the same identifier) into one.\nFor each couple of Bibliographic Resources (BRs) that are going to be merged, merge also:\n - their containers by matching the proper type (issue of BR1 -> issue of BR2)\n - their publisher\n\nIn the end, generate the provenance and commit pending changes in the graph set\n\n#### Matching the IDs\nDiscover all the IDs that share the same schema and literal, then merge all into one\nand substitute all the reference with the merged one.\n\nIn the end, generate the provenance and commit pending changes in the graph set\n\n<!-- GETTING STARTED -->\n## Getting Started\n\nTo get a local copy up and running follow these simple steps:\n1. install python >= 3.8:\n\n```sudo apt install python3```\n\n2. Install oc_graphenricher via pip:\n```\npip install oc-graphenricher\n```\n\n### Installing from the sources\n1. Having already installed python, you can also install GraphEnricher via cloning this repository: \n```\ngit clone https://github.com/opencitations/oc_graphenricher`\ncd ./oc_graphenricher\n```\n2. install poetry:\n\n```pip install poetry```\n\n3. install all the dependencies:\n\n``` poetry install```\n\n4. build the package:\n\n```poetry build```\n\n5. install the package:\n\n```    pip install ./dist/oc_graphenricher-<VERSION>.tar.gz```\n\n6. run the tests (from the root of the project):\n\n```\npoetry run test\n```\n\n<!-- USAGE EXAMPLES -->\n## Usage\nIt\'s supposed to accept only graph set objects. To create one:\n\n```\ng = Graph()\ng = g.parse(\'../data/test_dump.ttl\', format=\'nt11\')\n\nreader = Reader()\ng_set = GraphSet(base_iri=\'https://w3id.org/oc/meta/\')\nentities = reader.import_entities_from_graph(g_set, g, enable_validation=False, resp_agent=\'https://w3id.org/oc/meta/prov/pa/2\')\n```\nAt this point, to run the enrichment phase:\n```\nenricher = GraphEnricher(g_set)\nenricher.enrich()\n```\nThen, having serialized the enriched graph set, and having read it again as the\n`g_set` object, to run the deduplication step do:\n\n```\nmatcher = InstanceMatching(g_set)\nmatcher.match()\n```\n\nThose two functionalities are available with `main_enricher.py` and `main_instancematching.py`.\n\n\n\n\n\n<!-- LICENSE -->\n## License\n\nDistributed under the ISC License. See `LICENSE` for more information.\n\n\n\n<!-- CONTACT -->\n## Contact\n\nGabriele Pisciotta - [@GaPisciotta](https://twitter.com/GaPisciotta) - ga.pisciotta@gmail.com\n\nProject Link: [https://github.com/opencitations/oc_graphenricher](https://github.com/opencitations/oc_graphenricher)\n\n\n\n<!-- ACKNOWLEDGEMENTS -->\n## Acknowledgements\nThis project has been developed as part of the \n[Wikipedia Citations in Wikidata](https://meta.wikimedia.org/wiki/Wikicite/grant/Wikipedia_Citations_in_Wikidata) \nresearch project, under the supervision of prof. Silvio Peroni.\n\n\n\n\n<!-- MARKDOWN LINKS & IMAGES -->\n<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->\n',
    'author': 'Gabriele Pisciotta',
    'author_email': 'ga.pisciotta@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://opencitations.net',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
