import sys
from typing import Any

from typing_extensions import TypeAlias

if sys.version_info[0] < 3:
    Incomplete: TypeAlias = Any
else:
    from _typeshed import Incomplete

from huey.constants import (
    WORKER_GREENLET as WORKER_GREENLET,
    WORKER_PROCESS as WORKER_PROCESS,
    WORKER_THREAD as WORKER_THREAD,
    WORKER_TYPES as WORKER_TYPES,
)
from huey.exceptions import ConfigurationError as ConfigurationError
from huey.utils import time_clock as time_clock

class BaseProcess:
    process_name: str
    huey: Incomplete
    def __init__(self, huey) -> None: ...
    def create_logger(self): ...
    def initialize(self) -> None: ...
    def sleep_for_interval(self, start_ts, nseconds) -> None: ...
    def loop(self, now: Incomplete | None = ...) -> None: ...
    def shutdown(self) -> None: ...

class Worker(BaseProcess):
    process_name: str
    delay: Incomplete
    max_delay: Incomplete
    backoff: Incomplete
    def __init__(self, huey, default_delay, max_delay, backoff) -> None: ...
    def initialize(self) -> None: ...
    def shutdown(self) -> None: ...
    def loop(self, now: Incomplete | None = ...) -> None: ...
    def sleep(self) -> None: ...

class Scheduler(BaseProcess):
    periodic_task_seconds: int
    process_name: str
    interval: Incomplete
    periodic: Incomplete
    def __init__(self, huey, interval, periodic) -> None: ...
    def loop(self, now: Incomplete | None = ...) -> None: ...
    def enqueue_periodic_tasks(self, now) -> None: ...

class Environment:
    def get_stop_flag(self) -> None: ...
    def create_process(self, runnable, name) -> None: ...
    def is_alive(self, proc) -> None: ...

class ThreadEnvironment(Environment):
    def get_stop_flag(self): ...
    def create_process(self, runnable, name): ...
    def is_alive(self, proc): ...

class GreenletEnvironment(Environment):
    def get_stop_flag(self): ...
    def create_process(self, runnable, name): ...
    def is_alive(self, proc): ...

class ProcessEnvironment(Environment):
    def get_stop_flag(self): ...
    def create_process(self, runnable, name): ...
    def is_alive(self, proc): ...

WORKER_TO_ENVIRONMENT: Incomplete

class Consumer:
    worker_class: Incomplete
    scheduler_class: Incomplete
    huey: Incomplete
    workers: Incomplete
    periodic: Incomplete
    default_delay: Incomplete
    backoff: Incomplete
    max_delay: Incomplete
    scheduler_interval: Incomplete
    worker_type: Incomplete
    environment: Incomplete
    stop_flag: Incomplete
    scheduler: Incomplete
    worker_threads: Incomplete
    def __init__(
        self,
        huey,
        workers: int = ...,
        periodic: bool = ...,
        initial_delay: float = ...,
        backoff: float = ...,
        max_delay: float = ...,
        scheduler_interval: int = ...,
        worker_type=...,
        check_worker_health: bool = ...,
        health_check_interval: int = ...,
        flush_locks: bool = ...,
        extra_locks: Incomplete | None = ...,
    ) -> None: ...
    def flush_locks(self, *names) -> None: ...
    def get_environment(self, worker_type): ...
    def start(self) -> None: ...
    def stop(self, graceful: bool = ...) -> None: ...
    def run(self) -> None: ...
    def check_worker_health(self): ...
