import sys
from functools import partial as partial
from typing import Any

from typing_extensions import TypeAlias

if sys.version_info[0] < 3:
    Incomplete: TypeAlias = Any
else:
    from _typeshed import Incomplete

from huey.api import Huey as Huey
from huey.constants import EmptyData as EmptyData
from huey.storage import BaseStorage as BaseStorage
from huey.utils import decode as decode

class KyotoTycoonStorage(BaseStorage):
    priority: bool
    blocking: Incomplete
    expire_time: Incomplete
    kt: Incomplete
    qname: Incomplete
    sname: Incomplete
    q: Incomplete
    s: Incomplete
    def __init__(
        self,
        name: str = ...,
        host: str = ...,
        port: int = ...,
        db: Incomplete | None = ...,
        timeout: Incomplete | None = ...,
        max_age: int = ...,
        queue_db: Incomplete | None = ...,
        client: Incomplete | None = ...,
        blocking: bool = ...,
        result_expire_time: Incomplete | None = ...,
    ) -> None: ...
    def enqueue(self, data, priority: Incomplete | None = ...) -> None: ...
    def dequeue(self): ...
    def queue_size(self): ...
    def enqueued_items(self, limit: Incomplete | None = ...): ...
    def flush_queue(self): ...
    def convert_ts(self, ts): ...
    def add_to_schedule(self, data, ts, utc) -> None: ...
    def read_schedule(self, ts): ...
    def schedule_size(self): ...
    def scheduled_items(self, limit: Incomplete | None = ...): ...
    def flush_schedule(self): ...
    def prefix_key(self, key): ...
    def put_data(self, key, value, is_result: bool = ...) -> None: ...
    def peek_data(self, key): ...
    def pop_data(self, key): ...
    def delete_data(self, key): ...
    def has_data_for_key(self, key): ...
    def put_if_empty(self, key, value): ...
    def result_store_size(self): ...
    def result_items(self): ...
    def flush_results(self): ...
    def flush_all(self) -> None: ...

class KyotoTycoonHuey(Huey):
    storage_class: Incomplete
