import sys
from typing import Any

from typing_extensions import TypeAlias

if sys.version_info[0] < 3:
    Incomplete: TypeAlias = Any
else:
    from _typeshed import Incomplete

from peewee import *  # type: ignore

from huey.api import Huey as Huey
from huey.constants import EmptyData as EmptyData
from huey.exceptions import ConfigurationError as ConfigurationError
from huey.storage import BaseStorage as BaseStorage

class BytesBlobField(BlobField):  # type: ignore
    def python_value(self, value): ...

class SqlStorage(BaseStorage):
    database: Incomplete
    def __init__(
        self, name: str = ..., database: Incomplete | None = ..., **kwargs
    ) -> None: ...
    def create_models(self): ...
    def create_tables(self) -> None: ...
    def drop_tables(self) -> None: ...
    def close(self): ...
    def tasks(self, *columns): ...
    def schedule(self, *columns): ...
    def kv(self, *columns): ...
    def check_conn(self) -> None: ...
    def enqueue(self, data, priority: Incomplete | None = ...) -> None: ...
    def dequeue(self): ...
    def queue_size(self): ...
    def enqueued_items(self, limit: Incomplete | None = ...): ...
    def flush_queue(self) -> None: ...
    def add_to_schedule(self, data, timestamp, utc) -> None: ...
    def read_schedule(self, timestamp): ...
    def schedule_size(self): ...
    def scheduled_items(self): ...
    def flush_schedule(self) -> None: ...
    def put_data(self, key, value, is_result: bool = ...) -> None: ...
    def peek_data(self, key): ...
    def pop_data(self, key): ...
    def has_data_for_key(self, key): ...
    def put_if_empty(self, key, value): ...
    def result_store_size(self): ...
    def result_items(self): ...
    def flush_results(self) -> None: ...

SqlHuey: Incomplete
