import datetime
from typing import Any, NamedTuple

from huey.api import PeriodicTask, Task
from huey.exceptions import HueyException as HueyException

class Message(NamedTuple):
    id: str | None = ...
    name: str | None = ...
    eta: datetime.datetime | None = ...
    retries: int | None = ...
    retry_delay: int | None = ...
    priority: int | None = ...
    args: tuple[Any, ...] | None = ...
    kwargs: dict[str, Any] | None = ...
    on_complete: Task | None = ...
    on_error: Task | None = ...
    expires: int | datetime.timedelta | datetime.datetime | None = ...
    expires_resolved: datetime.datetime | None = ...

class Registry:
    _registry: dict[str, type[Task]]
    _periodic_tasks: list[type[PeriodicTask]]
    def __init__(self) -> None: ...
    def task_to_string(self, task_class: type[Task]): ...
    def register(self, task_class: type[Task]): ...
    def unregister(self, task_class: type[Task]): ...
    def string_to_task(self, task_str: str): ...
    def create_message(self, task: Task) -> Message: ...
    def create_task(self, message: Message) -> Task: ...
    @property
    def periodic_tasks(self) -> list[PeriodicTask]: ...
