import sys
import threading
from collections import deque as deque
from typing import Any, Generator

from typing_extensions import TypeAlias

if sys.version_info[0] < 3:
    Incomplete: TypeAlias = Any
else:
    from _typeshed import Incomplete

from huey.constants import EmptyData as EmptyData
from huey.exceptions import ConfigurationError as ConfigurationError
from huey.utils import (
    FileLock as FileLock,
    text_type as text_type,
    to_timestamp as to_timestamp,
)

class BaseStorage:
    blocking: bool
    priority: bool
    name: Incomplete
    def __init__(self, name: str = ..., **storage_kwargs) -> None: ...
    def close(self) -> None: ...
    def enqueue(self, data, priority: Incomplete | None = ...) -> None: ...
    def dequeue(self) -> None: ...
    def queue_size(self) -> None: ...
    def enqueued_items(self, limit: Incomplete | None = ...) -> None: ...
    def flush_queue(self) -> None: ...
    def add_to_schedule(self, data, ts, utc) -> None: ...
    def read_schedule(self, ts) -> None: ...
    def schedule_size(self) -> None: ...
    def scheduled_items(self, limit: Incomplete | None = ...) -> None: ...
    def flush_schedule(self) -> None: ...
    def put_data(self, key, value, is_result: bool = ...) -> None: ...
    def peek_data(self, key) -> None: ...
    def pop_data(self, key) -> None: ...
    def delete_data(self, key): ...
    def has_data_for_key(self, key) -> None: ...
    def put_if_empty(self, key, value): ...
    def result_store_size(self) -> None: ...
    def result_items(self) -> None: ...
    def flush_results(self) -> None: ...
    def flush_all(self) -> None: ...

class BlackHoleStorage(BaseStorage):
    def enqueue(self, data, priority: Incomplete | None = ...) -> None: ...
    def dequeue(self) -> None: ...
    def queue_size(self): ...
    def enqueued_items(self, limit: Incomplete | None = ...): ...
    def flush_queue(self) -> None: ...
    def add_to_schedule(self, data, ts, utc) -> None: ...
    def read_schedule(self, ts): ...
    def schedule_size(self): ...
    def scheduled_items(self, limit: Incomplete | None = ...): ...
    def flush_schedule(self) -> None: ...
    def put_data(self, key, value, is_result: bool = ...) -> None: ...
    def peek_data(self, key): ...
    def pop_data(self, key): ...
    def has_data_for_key(self, key): ...
    def result_store_size(self): ...
    def result_items(self): ...
    def flush_results(self) -> None: ...

class MemoryStorage(BaseStorage):
    def __init__(self, *args, **kwargs) -> None: ...
    def enqueue(self, data, priority: Incomplete | None = ...) -> None: ...
    def dequeue(self): ...
    def queue_size(self): ...
    def enqueued_items(self, limit: Incomplete | None = ...): ...
    def flush_queue(self) -> None: ...
    def add_to_schedule(self, data, ts, utc) -> None: ...
    def read_schedule(self, ts): ...
    def schedule_size(self): ...
    def scheduled_items(self, limit: Incomplete | None = ...): ...
    def flush_schedule(self) -> None: ...
    def put_data(self, key, value, is_result: bool = ...) -> None: ...
    def peek_data(self, key): ...
    def pop_data(self, key): ...
    def has_data_for_key(self, key): ...
    def result_store_size(self): ...
    def result_items(self): ...
    def flush_results(self) -> None: ...

SCHEDULE_POP_LUA: str

class RedisStorage(BaseStorage):
    priority: bool
    redis_client: Incomplete
    pool: Incomplete
    conn: Incomplete
    connection_params: Incomplete
    name: Incomplete
    queue_key: Incomplete
    schedule_key: Incomplete
    result_key: Incomplete
    error_key: Incomplete
    blocking: Incomplete
    read_timeout: Incomplete
    def __init__(
        self,
        name: str = ...,
        blocking: bool = ...,
        read_timeout: int = ...,
        connection_pool: Incomplete | None = ...,
        url: Incomplete | None = ...,
        client_name: Incomplete | None = ...,
        **connection_params,
    ) -> None: ...
    def clean_name(self, name): ...
    def convert_ts(self, ts): ...
    def enqueue(self, data, priority: Incomplete | None = ...) -> None: ...
    def dequeue(self): ...
    def queue_size(self): ...
    def enqueued_items(self, limit: Incomplete | None = ...): ...
    def flush_queue(self) -> None: ...
    def add_to_schedule(self, data, ts, utc) -> None: ...
    def read_schedule(self, ts): ...
    def schedule_size(self): ...
    def scheduled_items(self, limit: Incomplete | None = ...): ...
    def flush_schedule(self) -> None: ...
    def put_data(self, key, value, is_result: bool = ...) -> None: ...
    def peek_data(self, key): ...
    def pop_data(self, key): ...
    def has_data_for_key(self, key): ...
    def put_if_empty(self, key, value): ...
    def result_store_size(self): ...
    def result_items(self): ...
    def flush_results(self) -> None: ...

class RedisExpireStorage(RedisStorage):
    result_prefix: Incomplete
    result_key: Incomplete
    def __init__(self, name: str = ..., expire_time: int = ..., *args, **kwargs): ...
    def put_data(self, key, value, is_result: bool = ...) -> None: ...
    def peek_data(self, key): ...
    pop_data: Incomplete
    def delete_data(self, key): ...
    def has_data_for_key(self, key): ...
    def put_if_empty(self, key, value): ...
    def result_store_size(self): ...
    def result_items(self): ...
    def flush_results(self) -> None: ...

class RedisPriorityQueue:
    priority: bool
    def enqueue(self, data, priority: Incomplete | None = ...) -> None: ...
    def dequeue(self): ...
    def queue_size(self): ...
    def enqueued_items(self, limit: Incomplete | None = ...): ...

class PriorityRedisStorage(RedisPriorityQueue, RedisStorage): ...
class PriorityRedisExpireStorage(RedisPriorityQueue, RedisExpireStorage): ...

class _ConnectionState:
    def __init__(self, **kwargs) -> None: ...
    conn: Incomplete
    closed: bool
    def reset(self) -> None: ...
    def set_connection(self, conn) -> None: ...

class _ConnectionLocal(_ConnectionState, threading.local): ...

to_bytes: Incomplete
to_blob: Incomplete

class BaseSqlStorage(BaseStorage):
    begin_sql: str
    ddl: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def close(self): ...
    @property
    def conn(self): ...
    def db(
        self, commit: bool = ..., close: bool = ...
    ) -> Generator[Incomplete, None, None]: ...
    def initialize_schema(self) -> None: ...
    def sql(
        self,
        query,
        params: Incomplete | None = ...,
        commit: bool = ...,
        results: bool = ...,
    ): ...

class SqliteStorage(BaseSqlStorage):
    begin_sql: str
    table_kv: str
    table_sched: str
    index_sched: str
    table_task: str
    index_task: str
    ddl: Incomplete
    filename: Incomplete
    def __init__(
        self,
        name: str = ...,
        filename: str = ...,
        cache_mb: int = ...,
        fsync: bool = ...,
        journal_mode: str = ...,
        timeout: int = ...,
        strict_fifo: bool = ...,
        **kwargs,
    ) -> None: ...
    def enqueue(self, data, priority: Incomplete | None = ...) -> None: ...
    def dequeue(self): ...
    def queue_size(self): ...
    def enqueued_items(self, limit: Incomplete | None = ...): ...
    def flush_queue(self) -> None: ...
    def add_to_schedule(self, data, ts, utc) -> None: ...
    def read_schedule(self, ts): ...
    def schedule_size(self): ...
    def scheduled_items(self, limit: Incomplete | None = ...): ...
    def flush_schedule(self) -> None: ...
    def put_data(self, key, value, is_result: bool = ...) -> None: ...
    def peek_data(self, key): ...
    def pop_data(self, key): ...
    def has_data_for_key(self, key): ...
    def put_if_empty(self, key, value): ...
    def result_store_size(self): ...
    def result_items(self): ...
    def flush_results(self) -> None: ...

class FileStorage(BaseStorage):
    MAX_PRIORITY: int
    path: Incomplete
    queue_path: Incomplete
    schedule_path: Incomplete
    result_path: Incomplete
    levels: Incomplete
    lock: Incomplete
    lock_file: Incomplete
    def __init__(
        self,
        name,
        path,
        levels: int = ...,
        use_thread_lock: bool = ...,
        **storage_kwargs,
    ) -> None: ...
    def enqueue(self, data, priority: Incomplete | None = ...) -> None: ...
    def dequeue(self): ...
    def queue_size(self): ...
    def enqueued_items(self, limit: Incomplete | None = ...): ...
    def flush_queue(self) -> None: ...
    def add_to_schedule(self, data, ts, utc) -> None: ...
    def read_schedule(self, ts): ...
    def schedule_size(self): ...
    def scheduled_items(self, limit: Incomplete | None = ...): ...
    def flush_schedule(self) -> None: ...
    def path_for_key(self, key): ...
    def put_data(self, key, value, is_result: bool = ...) -> None: ...
    def peek_data(self, key): ...
    def pop_data(self, key): ...
    def has_data_for_key(self, key): ...
    def result_store_size(self): ...
    def result_items(self): ...
    def flush_results(self) -> None: ...
