import datetime
import sys
import time
from typing import Any, NamedTuple

from typing_extensions import TypeAlias

if sys.version_info[0] < 3:
    Incomplete: TypeAlias = Any
else:
    from _typeshed import Incomplete

class Error(NamedTuple):
    metadata: Incomplete

class UTC(datetime.tzinfo):
    zero: Incomplete
    def utcoffset(self, dt): ...
    def tzname(self, dt): ...
    def dst(self, dt): ...

def load_class(s): ...
def reraise_as(new_exc_class) -> None: ...
def is_naive(dt): ...
def make_naive(dt): ...
def aware_to_utc(dt): ...
def local_to_utc(dt): ...
def normalize_expire_time(expires, utc: bool = ...): ...
def normalize_time(
    eta: Incomplete | None = ..., delay: Incomplete | None = ..., utc: bool = ...
): ...

# string_type: Incomplete

if sys.version_info[0] == 2:
    string_type = basestring
    text_type = unicode
else:
    string_type = (bytes, str)
    text_type = str

def to_timestamp(dt): ...
def encode(s): ...
def decode(s): ...

class FileLock:
    filename: Incomplete
    fd: Incomplete
    def __init__(self, filename) -> None: ...
    def acquire(self) -> None: ...
    def release(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type, exc_val, exc_tb) -> None: ...

if sys.version_info[0] < 3:
    time_clock = time.time
else:
    time_clock = time.monotonic
