# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['reviser',
 'reviser.bundling',
 'reviser.commands',
 'reviser.commands.helper',
 'reviser.definitions',
 'reviser.definitions.configurations',
 'reviser.deploying',
 'reviser.interactivity',
 'reviser.interactivity.shells',
 'reviser.servicer',
 'reviser.servicer.functioning',
 'reviser.templating']

package_data = \
{'': ['*']}

extras_require = \
{'shell': ['boto3>=1.16.11,<2.0.0',
           'colorama>=0.4.4,<0.5.0',
           'Jinja2>=2.11.2,<3.0.0',
           'prompt-toolkit>=3.0.8,<4.0.0',
           'PyYAML>=5.3.1,<6.0.0',
           'pipper>=0.7.0,<0.8.0']}

entry_points = \
{'console_scripts': ['reviser = reviser.cli:main']}

setup_kwargs = {
    'name': 'reviser',
    'version': '0.1.2',
    'description': 'AWS Lambda function/layer version deployment manager.',
    'long_description': '# Reviser (v0.1.1)\n\nReviser is a tool for AWS Lambda function and layer version deployment and\nalias management specifically for Python runtimes where the actual\ninfrastructure is managed separately, mostly likely by CloudFormation or\nTerraform. There are a number of ways to manage AWS Lambda functions and layers\nalready, but their generality and all-encompassing approaches don\'t integrate\nwell with certain workflows and can be overly complex for many needs.\n\nReviser is scoped to facilitate the deployment and updating of AWS Lambda\nPython functions and layers for all of the version-specific configurations,\ne.g. code bundles, environment variables, memory size, and timeout lengths.\nThe expectation is that functions are created by other means and then\nconfiguration for versions is managed with the reviser through an interactive\nor scripted shell of commands.\n\n- [Basic Usage](#basic-usage)\n- [Shell Commands](#shell-commands)\n   - [alias](#alias)\n   - [bundle](#bundle)\n   - [configs](#configs)\n   - [deploy](#deploy)\n   - [exit](#exit)\n   - [help (?)](#help-)\n   - [list](#list)\n   - [prune](#prune)\n   - [push](#push)\n   - [reload](#reload)\n   - [select](#select)\n   - [shell](#shell)\n   - [status](#status)\n- [Configuration Files](#configuration-files)\n   - [bucket(s)](#buckets)\n   - [region](#region)\n   - [targets](#targets)\n      - [targets[N].kind](#targetsnkind)\n      - [targets[N].name(s)](#targetsnnames)\n      - [targets[N].region](#targetsnregion)\n      - [targets[N].dependencies](#targetsndependencies)\n      - [targets[N].dependencies(kind="pipper")](#targetsndependencieskindpipper)\n      - [targets[N].bundle](#targetsnbundle)\n         - [targets[N].bundle.include(s)](#targetsnbundleincludes)\n         - [targets[N].bundle.exclude(s)](#targetsnbundleexcludes)\n         - [targets[N].bundle.omit_package(s)](#targetsnbundleomit_packages)\n         - [targets[N].bundle.handler](#targetsnbundlehandler)\n   - [function targets](#function-targets)\n      - [(function) targets[N].layer(s)](#function-targetsnlayers)\n      - [(function) targets[N].memory](#function-targetsnmemory)\n      - [(function) targets[N].timeout](#function-targetsntimeout)\n      - [(function) targets[N].variable(s)](#function-targetsnvariables)\n      - [(function) targets[N].ignore(s)](#function-targetsnignores)\n   - [run](#run)\n\n# Basic Usage\n\nA project defines one or more lambda function configuration targets in a \n`lambda.yaml` file in the root project directory. The most basic configuration\nlooks like this:\n\n```yaml\nbucket: name-of-s3-bucket-for-code-uploads\ntargets:\n- kind: function\n  name: foo-function\n```\n\nThis configuration defines a single `foo-function` lambda function target that\nwill be managed by reviser. The expectation is that this function exists and\nwas created by another means, e.g. CloudFormation or Terraform. A bucket must\nbe specified to indicate where the zipped code bundles will be uploaded prior\nto them being applied to the target(s). The bucket must already exist as well.\n\nBy default the package will include no external, e.g. pip, package\ndependencies. It will search for the first folder in the directory where the\n`lambda.yaml` file is located that contains an `__init__.py` file, identifying\nthat folder as a Python source package for the function. It will also look for\na `lambda_function.py` alongside the `lambda.yaml` file to serve as the \nentrypoint. These will be included in the uploaded and deployed code bundle\nwhen a `push` or a `deploy` command is executed. These default settings can\nall be configured along with many more as will be outlined below.\n\nTo deploy this example project, install the reviser python library and\nstart the shell with the command `reviser` in your terminal of choice\nin the directory where the `lambda.yaml` file resides. Docker must be running\nand available in the terminal in which you execute this command, as reviser\nis a containerized shell environment that runs within a container that mimics\nthe actual AWS Lambda runtime environment. Then run the `push` command within\nthe launched shell to create and upload the bundled source code and publish\na new version of the `foo-function` lambda function with the uploaded results.\n\n# Shell commands\n\nThe reviser command starts an interactive shell within a Docker container \ncompatible with the AWS Python Lambda runtime. This shell contains various\ncommands for deploying and managing deployments of lambda functions and layers\ndefined in a project\'s `lambda.yaml` configuration file, the format of which\nis described later in this document. The shell commands are:\n\n## alias\n\nAssigns an alias to the specified version of the selected or specified lambda\nfunction. Or it will create a new alias and assign it to the specified version\nif the --create flag is included.\n\n```\nusage: alias [--function FUNCTION] [--yes] [--create] alias version\n\npositional arguments:\n  alias                Name of an existing alias to move to the specified\n                       version, or the name of an alias to create and assign\n                       to the specified function version if the --create flag\n                       is included to allow for creating a new alias.\n  version              Version of the function that the alias should be\n                       assigned to. This will either be an integer value or\n                       $LATEST. To see what versions are available for a given\n                       function use the list command.\n\noptional arguments:\n  --function FUNCTION  The alias command only acts on one function. This can\n                       be achieved either by selecting the function target via\n                       the select command, or specifying the function name to\n                       apply this change to with this flag.\n  --yes                By default this command will require input confirmation\n                       before carrying out the change. Specify this flag to\n                       skip input confirmation and proceed without a breaking\n                       prompt.\n  --create             When specified the alias will be created instead of\n                       reassigned. Use this to create and assign new aliases\n                       to a function. When this flag is not specified, the\n                       command will fail if the alias doesn\'t exist, which\n                       helps prevent accidental alias creation.\n\n```\n\nTo assign an existing `test` alias to version 42 of the selected\nfunction, the command would be:\n\n```\n> alias test 42\n```\n\nIf multiple functions are currently selected, use `--function=<NAME>`\nto identify the function to which the alias change will be applied.\n\n## bundle\n\nInstalls dependencies and copies includes into a zipped file that is structured\ncorrectly to be deployed to the lambda function/layer target.\n\n```\nusage: bundle [--reinstall]\n\noptional arguments:\n  --reinstall  Add this flag to reinstall dependencies on a repeated bundle\n               operation. By default, dependencies will remain cached for the\n               lifetime of the shell to speed up the bundling process. This\n               will force dependencies to be installed even if they had been\n               installed previously.\n\n```\n\n## configs\n\nDisplays the configs loaded from the lambda.yaml file and fully populated with\ndefaults and dynamic values. Use this to inspect and validate that the loaded\nconfiguration meets expectations when parsed into the reviser shell.\n\n```\nusage: configs\n\n```\n\n## deploy\n\nUploads the bundled contents to the upload S3 bucket and then publishes a new\nversion of each of the lambda targets with that new bundle and any modified\nsettings between the current configuration and that target\'s existing\nconfiguration. This command will fail if a target being deployed has not\nalready been bundled.\n\n```\nusage: deploy [--description DESCRIPTION] [--dry-run]\n\noptional arguments:\n  --description DESCRIPTION\n                        Specify a message to assign to the version published\n                        by the deploy command.\n  --dry-run             If set, the deploy operation will be exercised without\n                        actually carrying out the actions. This can be useful\n                        to validate the deploy process without side effects.\n\n```\n\n## exit\n\nExits the shell and returns to the parent terminal.\n\n```\nusage: exit\n\n```\n\n## help (?)\n\nDisplays help information on the commands available within the shell.\nAdditional help on each command can be found using the --help flag on the\ncommand in question.\n\n```\nusage: help\n\n```\n\n## list\n\nLists versions of the specified lambda targets with info about each version.\n\n```\nusage: list\n\n```\n\n## prune\n\nRemoves old function and/or layer versions for the selected targets.\n\n```\nusage: prune [--start START] [--end END] [--dry-run] [-y]\n\noptional arguments:\n  --start START  Keep versions lower (earlier/before) this one.\n  --end END      Do not prune versions higher than this value.\n  --dry-run      Echo pruning operation without actually executing it.\n  -y, --yes      Run the prune process without reviewing first.\n\n```\n\n## push\n\nCombined single command for bundling and deploying the selected targets.\n\n```\nusage: push [--reinstall] [--description DESCRIPTION] [--dry-run]\n\noptional arguments:\n  --reinstall           Add this flag to reinstall dependencies on a repeated\n                        bundle operation. By default, dependencies will remain\n                        cached for the lifetime of the shell to speed up the\n                        bundling process. This will force dependencies to be\n                        installed even if they had been installed previously.\n  --description DESCRIPTION\n                        Specify a message to assign to the version published\n                        by the deploy command.\n  --dry-run             If set, the deploy operation will be exercised without\n                        actually carrying out the actions. This can be useful\n                        to validate the deploy process without side effects.\n\n```\n\n## reload\n\nReloads the lambda.yaml configuration file from disk.\n\n```\nusage: reload\n\n```\n\n## select\n\nAllows for selecting subsets of the targets within the loaded configuration.\nThe subsets are fuzzy-matched unless the --exact flag is used.\n\n```\nusage: select [--exact] {function,layer,*} [name]\n\npositional arguments:\n  {function,layer,*}  Specify the type of objects to select or use * to select\n                      both types.\n  name                Specifies the value to match against the function and\n                      layer target names available from the configuration.\n                      This can include shell-style wildcards and will also\n                      match against partial strings. If the --exact flag is\n                      specified, this value must exactly match one of the\n                      targets instead of the default fuzzy matching behavior.\n\noptional arguments:\n  --exact             Forces the match to be exact instead of fuzzy.\n\n```\n\n## shell\n\nSpecial command to use in run command groups/macros to start interactive\ncommand mode for the terminal. Useful when in scenarios where you wish to\nprefix an interactive session with commonly executed commands. For example, if\nyou want to select certain targets with the select command as part of starting\nthe shell, you could create a run command group/macro in your lambda.yaml that\nexecutes the select command and then executes the shell command. This would\nupdated the selection and then with the shell command, start the shell in\ninteractive mode. Without specifying the shell command here, the run command\ngroup/macro would just set a selection and then exit.\n\n```\nusage: shell\n\n```\n\n## status\n\nShows the current status information for each of the selected lambda targets.\n\n```\nusage: status [qualifier]\n\npositional arguments:\n  qualifier  Specifies a version or alias to show status for. If not\n             specified, $LATEST will be used for functions and the latest\n             version will be dynamically determined for layers.\n\n```\n    \nMore detail on any of these commands can be found from within the shell by\nexecuting them with the `--help` flag.\n\nThe reviser application also supports non-interactive batch command\nexecution via `run` macros that behave similarly to how `npm run <command>` \ncommands are defined. For more details see the `run` attribute section of the\nconfiguration file definitions below.\n\n# Configuration Files\n\nConfiguration files, named `lambda.yaml` define the the lambda targets to be\nmanaged within a project. The top-level keys in the configuration file are:\n\n## bucket(s)\n\nThis key defines the bucket or buckets where zipped source bundles will be\nuploaded before they are deployed to their lambda function and/or layer\ntargets. Basic usage is to specify the bucket as a key:\n\n```yaml\nbucket: bucket-name\n```\n\nIt\'s also possible for multi-account scenarios to specify multiple buckets as\na key-value pairing where the keys are the AWS account IDs (as strings) and\nthe values are the bucket names associated with those IDs. In this case the\nbucket selection is made dynamically based on the AWS session loaded during\nshell initialization. Specifying multiple buckets looks like:\n\n```yaml\nbuckets:\n  "123456789": bucket-in-account-123456789\n  "987654321": bucket-in-account-987654321\n``` \n\n## region\n\nThe AWS region in which teh resources reside can be specified at the top\nlevel of the file if desired. It is recommended that the region be specified\nwithin the calling AWS profile if possible for flexibility, but there are\nsituations where it makes more sense to make it explicit within the \nconfiguration file instead. If no region is found either in the configuration\nfile or in the AWS profile the `us-east-1` region will be used as the default\nin keeping with AWS region defaulting conventions. Specify the region with\nthe top-level key:\n\n```yaml\nregion: us-east-2\n```\n\n## targets\n\nTargets is where the bulk of the configuration resides. Each item\nis either of the *function* or *layer* kind and has associated\nconfiguration and bundling settings according to the type. Common\nto both *function* and *layer* kinds are the keys:\n\n### targets[N].kind\n\nAs mentioned already, each target must specify its object type using\nthe kind key:\n\n```yaml\ntargets:\n- kind: function\n  ...\n- kind: layer\n  ...\n```\n\n### targets[N].name(s)\n\nThe name specifies the name of the target object, not the ARN. For example,\na function named foo would be represented as:\n\n```yaml\ntargets:```  \n- kind: function\n  name: foo\n```\n\nA single target can point to multiple functions. This is useful in cases\nwhere a single target could be for both development and production functions\nor where a single code-base is shared across multiple functions for logical\nor integration reasons. In this case a list of names is supplied instead:\n\n```yaml\ntargets:\n- kind: function\n  names:\n  - foo-devel\n  - foo-prod\n``` \n\n### targets[N].region\n\nIn the same fashion as regions can be explicitly set as a top-level\nconfiguration key, they can also be set on a per-target basis. If set,\nthe target region will take precedence over the top-level value and\nthe profile-specified value. This makes deploying code across regions\nwithin a single configuration file possible.\n\n### targets[N].dependencies\n\nDependencies is a list of external dependency sources to install as\nsite packages in the lambda function or layer. Multiple package managers\nare supported and specified by the `kind` attribute:\n\n```yaml\ntargets:\n- kind: layer\n  name: foo\n  dependencies:\n  - kind: pip\n  - kind: pipper\n```\n\nCurrently `pip` and `pipper` package managers are supported. For either\npackage manager, the dependencies can be specified explicitly with the \n`package(s)` key.\n\n```yaml\ntargets:\n- kind: layer\n  name: foo\n  dependencies:\n  - kind: pip\n    packages: \n    - spam\n    - hamd\n  - kind: pipper\n    package: spammer\n```\n\nIt\'s also possible to specify a file to where the package dependencies\nhave been defined.\n\n```yaml\ntargets:\n- kind: layer\n  name: foo\n  dependencies:\n  - kind: pip\n    file: requirements.layer.txt\n  - kind: pipper\n    file: pipper.layer.json\n```\n\nIf no packages or file is specified, the default file for the given package\nmanager will be used by default (e.g. `requirements.txt` for pip \nand `pipper.json` for pipper).\n\nIt is also possible to specify the same kind of package manager multiple\ntimes in this list to aggregate dependencies from multiple locations.\n\n### targets[N].dependencies(kind="pipper")\n\nPipper repositories have additional configuration not associated with pip\npackages. To support pipper libraries, there are two additional attributes\nthat can be specified: `bucket` and `prefix`.\n\nThe `bucket` is required as it specifies the S3 bucket used as the package\nsource and should be read-accessible by the profile invoking reviser.\n\nThe `prefix` is an optional alternate package prefix within the S3 bucket.\nUse this only if you are using an alternate prefix with for your pipper\npackage.\n\n```yaml\ntargets:\n- kind: layer\n  name: foo\n  dependencies:\n  - kind: pipper\n    file: pipper.layer.json\n    bucket: bucket-name-where-pipper-package-resides\n    prefix: a/prefix/that/is/not/just/pipper\n```\n\n### targets[N].bundle\n\nThe target bundle object contains the attributes that define the bundle\nthat will be created and uploaded to the functions or layers in a given\ntarget as part of the deployment process. It\'s primary purpose is to define\nwhat files should be included in the bundling process, which it achieves\nwith the following attributes.\n\n#### targets[N].bundle.include(s)\n\nThe `include(s)` key is a string or list of Python glob-styled includes\nto add to the bundle. If no includes are specified, the default behavior is:\n\n- **function targets**: copy the first directory found that contains an \n  *__init__.py* file.\n- **layer targets**: do not copy anything and assume dependencies are the\n  only files to copy into the bundle.\n\nAll paths should be referenced relative to the root path where the\n`lambda.yaml` is located. For a recursive matching pattern, the glob syntax\nshould be used as `**/*.txt` or if restricted to a folder inside of the root\ndirectory then `folder/**/*.txt`. To include the entire contents of a\ndirectory, specify the path to the folder.\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  bundle:\n    includes:\n    # This is shorthand for "foo_library/**/*"\n    - foo_library\n    # All Python files in the "bin/" folder recursively.\n    - bin/**/*.py\n    # All Jinja2 files in the root directory that begin "template_".\n    - template_*.jinja2\n```\n\n#### targets[N].bundle.exclude(s)\n\nThe `exclude(s)` key is an optional one that is also a string or list of\nPython glob-styled paths to remove from the matching `include(s)`. These\nare applied to the files found via the includes and do not need to be\ncomprehensive of all files in the root directory. Building on the example\nfrom above:\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  bundle:\n    includes:\n    # This is shorthand for "foo_library/**/*"\n    - foo_library\n    # All Python files in the "bin/" folder recursively.\n    - bin/**/*.py\n    # All Jinja2 files in the root directory that begin "template_".\n    - template_*.jinja2\n    exclues:\n    - template_local.jinja2\n    - template_testing.jinja2\n```\n\nThis example would remove two of the template file matches from the includes\nfrom the files copied into the bundle for deployment.\n\nAll `__pycache__`, `*.pyc` and `.DS_Store` files/directories are\nexcluded from the copying process in all cases and do not need to be \nspecified explicitly.\n\n#### targets[N].bundle.omit_package(s)\n\nThere can be cases where dependencies install dependencies of their own that\nyou may not want copied over to the bundle. The most common case is a\ndependency that requires `boto3`, which is available by default in lambda\nfunctions already. In that case it can be useful to list site packages that\nshould not be copied into the bundle but may have been installed as a side\neffect of the dependency installation process.\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  bundle:\n    omit_package: boto3\n  dependencies:\n  - kind: pip\n    # Installs a package that requires boto3, which is therefore installed\n    # into the site-packages bundle directory as a result.\n    # https://github.com/awslabs/aws-lambda-powertools-python\n    package: aws-lambda-powertools\n```\n\nIn the above example `aws-lambda-powertools` causes `boto3` to be installed\nas well. However, since lambda functions have `boto3` installed by default,\nit\'s possible to omit that package from the bundling process so that it isn\'t\ninstalled twice.\n\nNote, however, that installing `boto3` directly in a bundle can be beneficial\nbecause it gives you the ability to install the version that is compatible\nwith your given source code and dependencies. The `boto3` version on the lambda\nfunction can be aged and stale.\n\n#### targets[N].bundle.handler\n\nThis attribute only applies to function targets and gives the location of\nfile and function entrypoint for the lambda function(s) in the target. The\nformat matches the expected value for lambda functions, which is \n`<filename_without_extension>.<function_name>`.\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  bundle:\n    handler: function:main\n```\n\nIn this case the bundler would expect to find `function.py` in the top-leve\ndirectory alongside `lambda.yaml` and inside it there would be a \n`main(event, context)` function that would be called when the function(s)\nare invoked.\n\nIf this value is omitted, the default value of `lambda_function.lambda_handler`\nwill be used as this matches the AWS lambda Python function documentation.\n\n## function targets\n\nIn addition to the common attributes described above that are shared between\nboth function and layer targets, there are a number of additional\nattributes that apply only to function targets. These are:\n\n### (function) targets[N].layer(s)\n\nSpecifies one or more layers that should be attached to the targeted\nfunction(s). Layers can be specified as fully-qualified ARNs for externally\nspecified layers, e.g. a layer created in another AWS account, or by name\nfor layers specified within the account and layers defined within the targets\nof the configuration file.\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  layer: arn:aws:lambda:us-west-2:999999999:layer:bar\n  ...\n```\n\nor for multiple layers:\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  layers:\n  # A layer defined in another account is specified by ARN.\n  - arn:aws:lambda:us-west-2:999999999:layer:bar\n  # A layer in this account is specified by name. This layer may also be\n  # a target in this configuration file.\n  - baz\n  ...\n- kind: layer\n  name: baz\n  ...\n```\n\nBy default, deployments will use the latest available version of each layer,\nbut this can be overridden by specifying the layer ARN with its version:\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  layer: arn:aws:lambda:us-west-2:999999999:layer:bar:42\n  ...\n```\n\nIn the above example the layer will remain at version 42 until explicitly\nmodified in the configuration file.\n\nLayers can also be defined as objects instead of attributes. The two-layer\nexample from above could be rewritten as:\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  layers: \n  - arn: arn:aws:lambda:us-west-2:999999999:layer:bar\n  - name: baz\n  ...\n```\n\nWhen specified as an object with attributes, there are a number of additional\nattributes that can be specified as well. First, `version` can be specified\nas a separate key from the arn or name, which in many cases can make it easier\nto work with than appending it to the end of the arn or function itself for\nprogrammatic/automation:\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  layers: \n  - arn: arn:aws:lambda:us-west-2:999999999:layer:bar\n    version: 42\n  - name: baz\n    version: 123\n  ...\n```\n\nNext is that the layer objects accept `only` and `except` keys that can be\nused to attach the layers to certain functions in the target and not others.\nThis can be useful in cases where development and production targets share\na lot in common, but perhaps point to different versions of a layer or perhaps\nseparate development and production layers entirely. It can also be useful\nwhen a target of functions share a common codebase but don\'t all need the\nsame dependencies. For performance optimization, restricting the layer \ninclusions only to those that need the additional dependencies can be\nbeneficial.\n\nThe `only` and `except` attributes can be specified as a single string\nor a list of strings that match against *unix pattern matching*. For example,\nexpanding on the example from above:\n\n```yaml\ntargets:\n- kind: function\n  names: \n  - foo-devel\n  - foo-devel-worker\n  - foo-prod\n  - foo-prod-worker\n  layers: \n  - name: baz-devel\n    only: foo-devel*\n  - name: baz-devel-worker\n    only: foo-devel-worker\n  - name: baz-prod\n    only: foo-prod*\n  - name: baz-prod-worker\n    only: foo-prod-worker\n  ...\n```\n\nthis example shows 4 layers that are conditionally applied using the only\nkeyword. The example could be rewritten with the `except` key instead:\n\n```yaml\ntargets:\n- kind: function\n  names: \n  - foo-devel\n  - foo-devel-worker\n  - foo-prod\n  - foo-prod-worker\n  layers: \n  - name: baz-devel\n    except: foo-prod*\n  - name: baz-devel-worker\n    except:\n    - foo-prod*\n    - foo-devel\n  - name: baz-prod\n    except: foo-devel*\n  - name: baz-prod-worker\n    except:\n    - foo-devel*\n    - foo-prod\n  ...\n```\n\nAnd either way works. The two (`only` and `except`) can also be combined\nwhen that makes more sense. For example, the `baz-devel-worker` from above\ncould also be written as:\n\n```yaml\n  - name: baz-devel-worker\n    only: foo-devel*\n    except: foo-devel\n```\n\nNote that if `only` is specified it is processed first and then `except` is\nremoved from the matches found by `only`. \n\n### (function) targets[N].memory\n\nThis specifies the function memory in megabytes either as an integer or\na string with an `MB` suffix.\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  memory: 256MB \n```\n\n### (function) targets[N].timeout\n\nThis specifies the function timeout in seconds either as an integer or\na string with an `s` suffix.\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  timeout: 42s \n```\n\n### (function) targets[N].variable(s)\n\nVariables contains a list of environment variables to assign to the function.\nThey can be specified simply with as a string `<KEY>=<value>` syntax:\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  variable: MODE=read-only\n```\n\nHere a single environment variable is specified that maps `"MODE"` to the\nvalue *"ready-only"*. A more programmatic-friendly way is to specify the\nname and value as attributes of a variable:\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  variables: \n  - name: MODE\n    value: read-only\n```\n\nSome environment variables may be managed through other means, e.g. \nterraform that created the function in the first place or another command\ninterface used to update the function. For those cases, the `preserve`\nattribute should be set to true and no value specified.\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  variables: \n  - name: MODE\n    preserve: true\n```\n\nIn this case the `MODE` environment variable value will be preserved between\nfunction deployments to contain the value that was already set.\n\nFinally, variables support the same `only` and `exclude` attributes that\nare found for target layers so that environment variables can be specified\ndifferently for subsets of targets.\n\nThe `only` and `except` attributes can be specified as a single string\nor a list of strings that match against *unix pattern matching*. For example,\nexpanding on the example from above:\n\n```yaml\ntargets:\n- kind: function\n  names: \n  - foo-prod\n  - foo-devel\n  variables: \n  - name: MODE\n    value: write\n    only: \'*prod\'\n  - name: MODE\n    value: read-only\n    except: \'*prod\'\n```\n\n### (function) targets[N].ignore(s)\n\nIgnores allows you to specify one or more configuration keys within a function\ntarget that should be ignored during deployments. For cases where any of the \nconfiguration values:\n\n- `memory`\n- `timeout`\n- `variables`\n\nare managed by external systems, they can be specified by the ignores to\nprevent changes being applied by reviser.\n\n```yaml\ntargets:\n- kind: function\n  name: foo\n  ignores:\n  - memory\n  - timeout\n```\n\n## run\n\nThe run attribute contains an optional object of batch non-interactive commands\nto run when the shell is called with that run key. This is useful for \norchestrating actions for CI/CD purposes as the commands will be processed\nwithin a shell environment without user prompts and then the shell will exit\nwhen complete without waiting for additional input.\n\n```yaml\nrun:\n  deploy-prod:\n  - select function *prod \n  - push --description="($CI_COMMIT_SHORT_SHA): $CI_COMMIT_TITLE"\n  - alias test -1\ntargets:\n- kind: function\n  names:\n  - foo-prod\n  - foo-devel\n```\n\nIn the example above, the `deploy-prod` run command macro/group would start\nthe shell and then non-interactively execute the three commands in order\nto first select the *foo-prod* function, then to build and deploy that function\nwith a description created from CI environment variables and finally move the\n*test* alias to the newly deployed version using a negative version index of\n*-1*. After those three commands are executed reviser will exit the\nshell automatically, successfully ending that process.\n\nThere is also a special `shell` command that can be used in run command\nmacros/groups that will start the shell in interactive mode. This is useful\nfor using run command macros/groups for pre-configuration during startup of\nthe interactive shell. Building on the previous example,\n\n```yaml\nrun:\n  deploy-prod:\n  - select function *prod \n  - push --description="($CI_COMMIT_SHORT_SHA): $CI_COMMIT_TITLE"\n  - alias test -1\n  devel:\n  - select * *devel\n  - bundle\n  - shell\ntargets:\n- kind: function\n  names:\n  - foo-prod\n  - foo-devel\n- kind: layer\n  names:\n  - bar-devel\n  - bar-prod\n```\n\nhere we\'ve added a `devel` run command macro/group that will select the devel\nfunction and layer and bundle those but not deploy them. After that\'s complete\nthe shell command will kick off the interactive session and ask for user\ninput. The benefit of this particular run command macro/group is to select\nthe development targets and pre-build them to cache the dependencies for the\nshell user while they continue to develop and deploy the source code to the\nfunction.\n',
    'author': 'Scott Ernst',
    'author_email': 'swernst@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/rocket-boosters/reviser',
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
