#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['jupancon']

package_data = \
{'': ['*'], 'jupancon': ['.ipynb_checkpoints/*']}

install_requires = \
['pandas==1.3.3',
 'sshtunnel==0.4.0',
 'psycopg2-binary==2.9.1',
 'pyparsing==2.4.7',
 'sqlalchemy-redshift==0.8.6',
 'sqlalchemy-bigquery==1.2.1',
 'google-cloud-bigquery-storage==2.9.1',
 'pyarrow==6.0.0',
 'pytest==6.2.5']

extras_require = \
{'test': ['pytest==6.2.5',
          'jupyter==1.0.0',
          'jupyterlab==3.1.14',
          'black==21.9b0',
          'flake8==3.9.2',
          'isort==5.9.3']}

setup(name='jupancon',
      version='0.1.4',
      description='Jupancon, connector to several DBs that returns pandas. Magic included.',
      author=None,
      author_email='Juan González-Vallinas <juan@multilayer.io>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
     )
