import { Construct } from 'constructs';
/**
 * Props for `AppInstance`.
 */
export interface AppInstanceUserProps {
    /**
     * The name of the app instance.
     *
     * @default - None
     */
    readonly name?: string;
    /**
     * The name of the app instance.
     *
     * @default - None
     */
    readonly appInstanceArn: string;
    /**
     * The name of the app instance.
     *
     * @default - None
     */
    readonly appInstanceUserId: string;
    /**
     * The metadata of the app instance. Limited to a 1KB string in UTF-8.
     *
     * @default - None
     */
    readonly metadata?: string;
    /**
     * The ClientRequestToken of the app instance.  This field is autopopulated if not provided.
     *
     * @default - None
     */
    readonly clientRequestToken?: string;
}
export declare class MessagingAppInstanceUser extends Construct {
    readonly appInstanceUserArn: string;
    constructor(scope: Construct, id: string, props: AppInstanceUserProps);
}
