# carbon3d-client
Welcome to the Carbon DLS API docs!

A Carbon DLS API token ([JWT](https://en.wikipedia.org/wiki/JSON_Web_Token)) must be included with each request to the API.

Steps to create API tokens:
- Create and download an API key [here](https://print.carbon3d.com/api_keys)
- For testing: Generate JWT tokens using the [token generator](/token_generator)
- For production: Generate JWT tokens dynamically (<em>see authtoken-create.py example</em>)
- A valid Carbon API token must be included as <code>Authorization: Bearer [token]</code> HTTP header.

This API provides a programmatic interface for submitting part (and soon build) orders. The general process for creating an order is as follows:

- Upload model files to the API with the [/models](#/Models) endpoint
- Create parts that reference a model and a part number with the [/parts](#/Parts) endpoint
  -  Part numbers can be created [here](https://print.carbon3d.com/catalog_parts)
- Create an order with the [/orders](#/Orders) endpoint

Uploaded models, parts and orders can be retrieved either in bulk or by UUID at the [/models](#/Models), [/parts](#/Parts) and [/orders](#/Orders) endpoints, respectively.

Once a part order is submitted, automatic packing will create one or more builds (for mass-customization applications only).

Builds can be retrieved either in bulk or by UUID at the [/builds](#/Builds) endpoint.
- Build attachments (traveler, slice video) can be retrieved by UUID at the [/attachments](#/Attachments) endpoint.

This API also provides a programmatic interface to access [printer](#/Printers) (fleet) status and query for [prints](#/Prints).


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.4
- Package version: 0.0.4
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.carbon3d.com](https://www.carbon3d.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import carbon3d
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import carbon3d
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import carbon3d
from carbon3d.rest import ApiException
from pprint import pprint

configuration = carbon3d.Configuration()
# Configure Bearer authorization (JWT): bearerAuth
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.carbon3d.com/v1
configuration.host = "https://api.carbon3d.com/v1"

# Defining host is optional and default to https://api.carbon3d.com/v1
configuration.host = "https://api.carbon3d.com/v1"
# Enter a context with an instance of the API client
with carbon3d.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = carbon3d.AttachmentsApi(api_client)
    uuid = 'uuid_example' # str | Attachment Uuid

    try:
        # Download a file attachment
        api_instance.get_attachment(uuid)
    except ApiException as e:
        print("Exception when calling AttachmentsApi->get_attachment: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.carbon3d.com/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AttachmentsApi* | [**get_attachment**](docs/AttachmentsApi.md#get_attachment) | **GET** /attachments/{uuid} | Download a file attachment
*BuildsApi* | [**get_build**](docs/BuildsApi.md#get_build) | **GET** /builds/{uuid} | Fetch a build
*BuildsApi* | [**get_builds**](docs/BuildsApi.md#get_builds) | **GET** /builds | Fetch builds
*ModelsApi* | [**get_model**](docs/ModelsApi.md#get_model) | **GET** /models/{uuid} | Get a model by UUID
*ModelsApi* | [**get_models**](docs/ModelsApi.md#get_models) | **GET** /models | Fetch models
*ModelsApi* | [**upload_model**](docs/ModelsApi.md#upload_model) | **POST** /models | Upload a model
*OrdersApi* | [**create_order**](docs/OrdersApi.md#create_order) | **POST** /orders | Create an Order
*OrdersApi* | [**delete_order**](docs/OrdersApi.md#delete_order) | **DELETE** /orders/{uuid} | Cancel an Order
*OrdersApi* | [**get_order**](docs/OrdersApi.md#get_order) | **GET** /orders/{uuid} | Get an Order
*OrdersApi* | [**get_orders**](docs/OrdersApi.md#get_orders) | **GET** /orders | Fetch orders
*OrdersApi* | [**update_order**](docs/OrdersApi.md#update_order) | **PATCH** /orders/{uuid} | Update an Order
*PartsApi* | [**create_part**](docs/PartsApi.md#create_part) | **POST** /parts | Create a Part
*PartsApi* | [**get_part**](docs/PartsApi.md#get_part) | **GET** /parts/{uuid} | Fetch a Part
*PartsApi* | [**get_parts**](docs/PartsApi.md#get_parts) | **GET** /parts | Fetch parts
*PrintedPartsApi* | [**get_printed_part**](docs/PrintedPartsApi.md#get_printed_part) | **GET** /printed_parts/{uuid} | Fetch a printed Part
*PrintedPartsApi* | [**get_printed_parts**](docs/PrintedPartsApi.md#get_printed_parts) | **GET** /printed_parts | Fetch printed parts
*PrintersApi* | [**get_printer**](docs/PrintersApi.md#get_printer) | **GET** /printers/{name} | Fetch a specific printer&#39;s status information
*PrintersApi* | [**get_printers**](docs/PrintersApi.md#get_printers) | **GET** /printers | Fetch all printer&#39;s status information
*PrintsApi* | [**get_prints**](docs/PrintsApi.md#get_prints) | **GET** /prints | List finished prints information


## Documentation For Models

 - [Build](docs/Build.md)
 - [BuildAttachments](docs/BuildAttachments.md)
 - [BuildsResponse](docs/BuildsResponse.md)
 - [Model](docs/Model.md)
 - [ModelsResponse](docs/ModelsResponse.md)
 - [Order](docs/Order.md)
 - [OrderRequest](docs/OrderRequest.md)
 - [OrderRequestParts](docs/OrderRequestParts.md)
 - [OrderStatus](docs/OrderStatus.md)
 - [OrderUpdateRequest](docs/OrderUpdateRequest.md)
 - [OrdersResponse](docs/OrdersResponse.md)
 - [OrdersResponseOrders](docs/OrdersResponseOrders.md)
 - [Part](docs/Part.md)
 - [PartGenealogy](docs/PartGenealogy.md)
 - [PartGenealogyBuildInfo](docs/PartGenealogyBuildInfo.md)
 - [PartGenealogyPrintInfo](docs/PartGenealogyPrintInfo.md)
 - [PartRequest](docs/PartRequest.md)
 - [PartsResponse](docs/PartsResponse.md)
 - [PrintRef](docs/PrintRef.md)
 - [PrintedPart](docs/PrintedPart.md)
 - [PrintedPartRef](docs/PrintedPartRef.md)
 - [PrintedPartStatus](docs/PrintedPartStatus.md)
 - [PrintedPartsResponse](docs/PrintedPartsResponse.md)
 - [Printer](docs/Printer.md)
 - [PrinterPrints](docs/PrinterPrints.md)
 - [PrinterStatus](docs/PrinterStatus.md)
 - [PrintersResponse](docs/PrintersResponse.md)
 - [PrintsResponse](docs/PrintsResponse.md)


## Documentation For Authorization


## bearerAuth

- **Type**: Bearer authentication (JWT)


## Author

api-list@carbon3d.com


