# Generated by Django 3.2.6 on 2021-09-19 23:28

import _socket
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.models.fields.other_charfield
import edc_sites.models
import edc_utils.date
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        ("edc_mnsi", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Mnsi",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "normal_appearance_right_foot",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, respond with `not examined`.",
                        max_length=15,
                        verbose_name="Does RIGHT foot appear normal?",
                    ),
                ),
                (
                    "abnormal_obs_right_foot_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other abnormality observed on RIGHT foot, please specify ...",
                    ),
                ),
                (
                    "ulceration_right_foot",
                    models.CharField(
                        choices=[
                            ("absent", "Absent"),
                            ("present", "Present"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Ulceration, RIGHT foot?",
                    ),
                ),
                (
                    "ankle_reflexes_right_foot",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("present_with_reinforcement", "Present/Reinforcement"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Ankle reflexes, RIGHT foot?",
                    ),
                ),
                (
                    "vibration_perception_right_toe",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("decreased", "Decreased"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Vibration perception at great toe, RIGHT foot?",
                    ),
                ),
                (
                    "monofilament_right_foot",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("reduced", "Reduced"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Monofilament, RIGHT foot?",
                    ),
                ),
                (
                    "normal_appearance_left_foot",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, respond with `not examined`.",
                        max_length=15,
                        verbose_name="Does LEFT foot appear normal?",
                    ),
                ),
                (
                    "abnormal_obs_left_foot_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other abnormality observed on LEFT foot, please specify ...",
                    ),
                ),
                (
                    "ulceration_left_foot",
                    models.CharField(
                        choices=[
                            ("absent", "Absent"),
                            ("present", "Present"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Ulceration, LEFT foot?",
                    ),
                ),
                (
                    "ankle_reflexes_left_foot",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("present_with_reinforcement", "Present/Reinforcement"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Ankle reflexes, LEFT foot?",
                    ),
                ),
                (
                    "vibration_perception_left_toe",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("decreased", "Decreased"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Vibration perception at great toe, LEFT foot?",
                    ),
                ),
                (
                    "monofilament_left_foot",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("reduced", "Reduced"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Monofilament, LEFT foot?",
                    ),
                ),
                (
                    "mnsi_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        help_text="If completion of patient history or physical assessment not possible, respond with `no` and provide reason below.",
                        max_length=15,
                        verbose_name="Is the MNSI assessment being performed?",
                    ),
                ),
                (
                    "mnsi_not_performed_reason",
                    models.TextField(
                        blank=True,
                        max_length=200,
                        null=True,
                        verbose_name="If NO, please provide a reason",
                    ),
                ),
                (
                    "numb_legs_feet",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Are your legs and/or feet numb?",
                    ),
                ),
                (
                    "burning_pain_legs_feet",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Do you ever have any burning pain in your legs and/or feet?",
                    ),
                ),
                (
                    "feet_sensitive_touch",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Are your feet too sensitive to touch?",
                    ),
                ),
                (
                    "muscle_cramps_legs_feet",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Do you get muscle cramps in your legs and/or feet?",
                    ),
                ),
                (
                    "prickling_feelings_legs_feet",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Do you ever have any prickling feelings in your legs or feet?",
                    ),
                ),
                (
                    "covers_touch_skin_painful",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Does it hurt when the bed covers touch your skin?",
                    ),
                ),
                (
                    "differentiate_hot_cold_water",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="When you get into the tub or shower, are you able to tell the hot water from the cold water?",
                    ),
                ),
                (
                    "open_sore_foot_history",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have you ever had an open sore on your foot?",
                    ),
                ),
                (
                    "diabetic_neuropathy",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has your doctor ever told you that you have diabetic neuropathy?",
                    ),
                ),
                (
                    "feel_weak",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Do you feel weak all over most of the time?",
                    ),
                ),
                (
                    "symptoms_worse_night",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Are your symptoms worse at night?",
                    ),
                ),
                (
                    "legs_hurt_when_walk",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Do your legs hurt when you walk?",
                    ),
                ),
                (
                    "sense_feet_when_walk",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Are you able to sense your feet when you walk?",
                    ),
                ),
                (
                    "skin_cracks_open_feet",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Is the skin on your feet so dry that it cracks open?",
                    ),
                ),
                (
                    "amputation",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have you ever had an amputation?",
                    ),
                ),
                (
                    "calculated_patient_history_score",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(13),
                        ],
                    ),
                ),
                (
                    "calculated_physical_assessment_score",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=3,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10.0),
                        ],
                    ),
                ),
                ("report_datetime", models.DateTimeField(default=edc_utils.date.get_utcnow)),
                (
                    "abnormal_obs_left_foot",
                    models.ManyToManyField(
                        blank=True,
                        related_name="_edc_mnsi_mnsi_abnormal_obs_left_foot_+",
                        to="edc_mnsi.AbnormalFootAppearanceObservations",
                        verbose_name="If NO, check all that apply to LEFT foot?",
                    ),
                ),
                (
                    "abnormal_obs_right_foot",
                    models.ManyToManyField(
                        blank=True,
                        related_name="_edc_mnsi_mnsi_abnormal_obs_right_foot_+",
                        to="edc_mnsi.AbnormalFootAppearanceObservations",
                        verbose_name="If NO, check all that apply to RIGHT foot?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Michigan Neuropathy Screening Instrument (MNSI)",
                "verbose_name_plural": "Michigan Neuropathy Screening Instrument (MNSI)",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalMnsi",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "normal_appearance_right_foot",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, respond with `not examined`.",
                        max_length=15,
                        verbose_name="Does RIGHT foot appear normal?",
                    ),
                ),
                (
                    "abnormal_obs_right_foot_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other abnormality observed on RIGHT foot, please specify ...",
                    ),
                ),
                (
                    "ulceration_right_foot",
                    models.CharField(
                        choices=[
                            ("absent", "Absent"),
                            ("present", "Present"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Ulceration, RIGHT foot?",
                    ),
                ),
                (
                    "ankle_reflexes_right_foot",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("present_with_reinforcement", "Present/Reinforcement"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Ankle reflexes, RIGHT foot?",
                    ),
                ),
                (
                    "vibration_perception_right_toe",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("decreased", "Decreased"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Vibration perception at great toe, RIGHT foot?",
                    ),
                ),
                (
                    "monofilament_right_foot",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("reduced", "Reduced"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Monofilament, RIGHT foot?",
                    ),
                ),
                (
                    "normal_appearance_left_foot",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, respond with `not examined`.",
                        max_length=15,
                        verbose_name="Does LEFT foot appear normal?",
                    ),
                ),
                (
                    "abnormal_obs_left_foot_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other abnormality observed on LEFT foot, please specify ...",
                    ),
                ),
                (
                    "ulceration_left_foot",
                    models.CharField(
                        choices=[
                            ("absent", "Absent"),
                            ("present", "Present"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Ulceration, LEFT foot?",
                    ),
                ),
                (
                    "ankle_reflexes_left_foot",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("present_with_reinforcement", "Present/Reinforcement"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Ankle reflexes, LEFT foot?",
                    ),
                ),
                (
                    "vibration_perception_left_toe",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("decreased", "Decreased"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Vibration perception at great toe, LEFT foot?",
                    ),
                ),
                (
                    "monofilament_left_foot",
                    models.CharField(
                        choices=[
                            ("NORMAL", "Normal"),
                            ("reduced", "Reduced"),
                            ("absent", "Absent"),
                            ("not_examined", "Not examined"),
                        ],
                        default="not_examined",
                        help_text="If the MNSI assessment was not performed, or amputation prevents examination, respond with `not examined`.",
                        max_length=35,
                        verbose_name="Monofilament, LEFT foot?",
                    ),
                ),
                (
                    "mnsi_performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        help_text="If completion of patient history or physical assessment not possible, respond with `no` and provide reason below.",
                        max_length=15,
                        verbose_name="Is the MNSI assessment being performed?",
                    ),
                ),
                (
                    "mnsi_not_performed_reason",
                    models.TextField(
                        blank=True,
                        max_length=200,
                        null=True,
                        verbose_name="If NO, please provide a reason",
                    ),
                ),
                (
                    "numb_legs_feet",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Are your legs and/or feet numb?",
                    ),
                ),
                (
                    "burning_pain_legs_feet",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Do you ever have any burning pain in your legs and/or feet?",
                    ),
                ),
                (
                    "feet_sensitive_touch",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Are your feet too sensitive to touch?",
                    ),
                ),
                (
                    "muscle_cramps_legs_feet",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Do you get muscle cramps in your legs and/or feet?",
                    ),
                ),
                (
                    "prickling_feelings_legs_feet",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Do you ever have any prickling feelings in your legs or feet?",
                    ),
                ),
                (
                    "covers_touch_skin_painful",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Does it hurt when the bed covers touch your skin?",
                    ),
                ),
                (
                    "differentiate_hot_cold_water",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="When you get into the tub or shower, are you able to tell the hot water from the cold water?",
                    ),
                ),
                (
                    "open_sore_foot_history",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have you ever had an open sore on your foot?",
                    ),
                ),
                (
                    "diabetic_neuropathy",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has your doctor ever told you that you have diabetic neuropathy?",
                    ),
                ),
                (
                    "feel_weak",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Do you feel weak all over most of the time?",
                    ),
                ),
                (
                    "symptoms_worse_night",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Are your symptoms worse at night?",
                    ),
                ),
                (
                    "legs_hurt_when_walk",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Do your legs hurt when you walk?",
                    ),
                ),
                (
                    "sense_feet_when_walk",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Are you able to sense your feet when you walk?",
                    ),
                ),
                (
                    "skin_cracks_open_feet",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Is the skin on your feet so dry that it cracks open?",
                    ),
                ),
                (
                    "amputation",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have you ever had an amputation?",
                    ),
                ),
                (
                    "calculated_patient_history_score",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(13),
                        ],
                    ),
                ),
                (
                    "calculated_physical_assessment_score",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=3,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10.0),
                        ],
                    ),
                ),
                ("report_datetime", models.DateTimeField(default=edc_utils.date.get_utcnow)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Michigan Neuropathy Screening Instrument (MNSI)",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
