# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class AgentManagerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def agent_manager_create_agent(self, body, **kwargs):  # noqa: E501
        """CreateAgent  # noqa: E501

        Creates agent and returns the configuration for installing the agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_create_agent(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateAgentRequest body: (required)
        :return: RimeCreateAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_create_agent_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_create_agent_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def agent_manager_create_agent_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateAgent  # noqa: E501

        Creates agent and returns the configuration for installing the agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_create_agent_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateAgentRequest body: (required)
        :return: RimeCreateAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_create_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `agent_manager_create_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/agents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_deactivate_agent(self, agent_id, **kwargs):  # noqa: E501
        """DeactivateAgent  # noqa: E501

        Deactivates the agent by setting its status to deactivated and revoking the agent's API Token. An error is returned if the deactivation fails.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_deactivate_agent(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id: (required)
        :return: RimeDeactivateAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_deactivate_agent_with_http_info(agent_id, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_deactivate_agent_with_http_info(agent_id, **kwargs)  # noqa: E501
            return data

    def agent_manager_deactivate_agent_with_http_info(self, agent_id, **kwargs):  # noqa: E501
        """DeactivateAgent  # noqa: E501

        Deactivates the agent by setting its status to deactivated and revoking the agent's API Token. An error is returned if the deactivation fails.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_deactivate_agent_with_http_info(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id: (required)
        :return: RimeDeactivateAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_deactivate_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_id' is set
        if ('agent_id' not in params or
                params['agent_id'] is None):
            raise ValueError("Missing the required parameter `agent_id` when calling `agent_manager_deactivate_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id' in params:
            path_params['agentId'] = params['agent_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/agents/deactivate/{agentId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeactivateAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_delete_agent(self, agent_id, **kwargs):  # noqa: E501
        """DeleteAgent  # noqa: E501

        Deletes a specified agent. Must be called on an already deactivated agent. An error is returned if the deletion fails or if the agent is not in a deletable state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_delete_agent(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id: (required)
        :return: RimeDeleteAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_delete_agent_with_http_info(agent_id, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_delete_agent_with_http_info(agent_id, **kwargs)  # noqa: E501
            return data

    def agent_manager_delete_agent_with_http_info(self, agent_id, **kwargs):  # noqa: E501
        """DeleteAgent  # noqa: E501

        Deletes a specified agent. Must be called on an already deactivated agent. An error is returned if the deletion fails or if the agent is not in a deletable state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_delete_agent_with_http_info(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id: (required)
        :return: RimeDeleteAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_delete_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_id' is set
        if ('agent_id' not in params or
                params['agent_id'] is None):
            raise ValueError("Missing the required parameter `agent_id` when calling `agent_manager_delete_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id' in params:
            path_params['agentId'] = params['agent_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/agents/{agentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_get_agent(self, agent_id, **kwargs):  # noqa: E501
        """GetAgent  # noqa: E501

        Returns the agent that matches the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_get_agent(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id: (required)
        :return: RimeGetAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_get_agent_with_http_info(agent_id, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_get_agent_with_http_info(agent_id, **kwargs)  # noqa: E501
            return data

    def agent_manager_get_agent_with_http_info(self, agent_id, **kwargs):  # noqa: E501
        """GetAgent  # noqa: E501

        Returns the agent that matches the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_get_agent_with_http_info(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id: (required)
        :return: RimeGetAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_get_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_id' is set
        if ('agent_id' not in params or
                params['agent_id'] is None):
            raise ValueError("Missing the required parameter `agent_id` when calling `agent_manager_get_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id' in params:
            path_params['agentId'] = params['agent_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/agents/{agentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_heartbeat(self, agent_id, **kwargs):  # noqa: E501
        """Heartbeat accepts heartbeat signal from agent indicating that they are still running.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_heartbeat(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id: (required)
        :return: RimeHeartbeatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_heartbeat_with_http_info(agent_id, **kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_heartbeat_with_http_info(agent_id, **kwargs)  # noqa: E501
            return data

    def agent_manager_heartbeat_with_http_info(self, agent_id, **kwargs):  # noqa: E501
        """Heartbeat accepts heartbeat signal from agent indicating that they are still running.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_heartbeat_with_http_info(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent_id: (required)
        :return: RimeHeartbeatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['agent_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_heartbeat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'agent_id' is set
        if ('agent_id' not in params or
                params['agent_id'] is None):
            raise ValueError("Missing the required parameter `agent_id` when calling `agent_manager_heartbeat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'agent_id' in params:
            path_params['agentId'] = params['agent_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/internal/agents/heartbeat/{agentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeHeartbeatResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_list_agents(self, **kwargs):  # noqa: E501
        """ListAgents  # noqa: E501

        Returns a paginated list of agents.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_list_agents(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size:
        :param str page_token:
        :param list[str] first_page_query_agent_status_types:  - AGENT_STATUS_PENDING: Resources have been created for the agent but the agent has not started yet.  - AGENT_STATUS_UNRESPONSIVE: No heartbeat for a certain amount of time.
        :param list[str] first_page_query_agent_ids:
        :return: RimeListAgentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_list_agents_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_list_agents_with_http_info(**kwargs)  # noqa: E501
            return data

    def agent_manager_list_agents_with_http_info(self, **kwargs):  # noqa: E501
        """ListAgents  # noqa: E501

        Returns a paginated list of agents.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_list_agents_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_size:
        :param str page_token:
        :param list[str] first_page_query_agent_status_types:  - AGENT_STATUS_PENDING: Resources have been created for the agent but the agent has not started yet.  - AGENT_STATUS_UNRESPONSIVE: No heartbeat for a certain amount of time.
        :param list[str] first_page_query_agent_ids:
        :return: RimeListAgentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_token', 'first_page_query_agent_status_types', 'first_page_query_agent_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_list_agents" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'first_page_query_agent_status_types' in params:
            query_params.append(('firstPageQuery.agentStatusTypes', params['first_page_query_agent_status_types']))  # noqa: E501
            collection_formats['firstPageQuery.agentStatusTypes'] = 'multi'  # noqa: E501
        if 'first_page_query_agent_ids' in params:
            query_params.append(('firstPageQuery.agentIds', params['first_page_query_agent_ids']))  # noqa: E501
            collection_formats['firstPageQuery.agentIds'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/agents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListAgentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def agent_manager_register_internal_agent(self, **kwargs):  # noqa: E501
        """RegisterInternalAgent is used by internal agents during startup to obtain an ID. This call is idempotent; it will be called by internal agent upon every restart. If no record of an internal agent exists, a new agent is created in the DB.Otherwise, the Agent Management service returns the ID of the existing agent.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_register_internal_agent(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RimeRegisterInternalAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.agent_manager_register_internal_agent_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.agent_manager_register_internal_agent_with_http_info(**kwargs)  # noqa: E501
            return data

    def agent_manager_register_internal_agent_with_http_info(self, **kwargs):  # noqa: E501
        """RegisterInternalAgent is used by internal agents during startup to obtain an ID. This call is idempotent; it will be called by internal agent upon every restart. If no record of an internal agent exists, a new agent is created in the DB.Otherwise, the Agent Management service returns the ID of the existing agent.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.agent_manager_register_internal_agent_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RimeRegisterInternalAgentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method agent_manager_register_internal_agent" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/internal/agents/register', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterInternalAgentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
