# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class DetectionDegradationEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'firewall_id': 'str',
        'degradation_event_id': 'RimeUUID',
        'monitor_id': 'RimeUUID',
        'event_range': 'RimeTimeInterval',
        'event_context_range': 'RimeTimeInterval',
        'description': 'str',
        'rca_result': 'RcaRCAResult',
        'severity': 'RimeSeverity',
        'last_detection_time': 'datetime'
    }

    attribute_map = {
        'firewall_id': 'firewallId',
        'degradation_event_id': 'degradationEventId',
        'monitor_id': 'monitorId',
        'event_range': 'eventRange',
        'event_context_range': 'eventContextRange',
        'description': 'description',
        'rca_result': 'rcaResult',
        'severity': 'severity',
        'last_detection_time': 'lastDetectionTime'
    }

    def __init__(self, firewall_id=None, degradation_event_id=None, monitor_id=None, event_range=None, event_context_range=None, description=None, rca_result=None, severity=None, last_detection_time=None):  # noqa: E501
        """DetectionDegradationEvent - a model defined in Swagger"""  # noqa: E501
        self._firewall_id = None
        self._degradation_event_id = None
        self._monitor_id = None
        self._event_range = None
        self._event_context_range = None
        self._description = None
        self._rca_result = None
        self._severity = None
        self._last_detection_time = None
        self.discriminator = None
        if firewall_id is not None:
            self.firewall_id = firewall_id
        if degradation_event_id is not None:
            self.degradation_event_id = degradation_event_id
        if monitor_id is not None:
            self.monitor_id = monitor_id
        if event_range is not None:
            self.event_range = event_range
        if event_context_range is not None:
            self.event_context_range = event_context_range
        if description is not None:
            self.description = description
        if rca_result is not None:
            self.rca_result = rca_result
        if severity is not None:
            self.severity = severity
        if last_detection_time is not None:
            self.last_detection_time = last_detection_time

    @property
    def firewall_id(self):
        """Gets the firewall_id of this DetectionDegradationEvent.  # noqa: E501

        Parent firewall of the degradation event.  # noqa: E501

        :return: The firewall_id of this DetectionDegradationEvent.  # noqa: E501
        :rtype: str
        """
        return self._firewall_id

    @firewall_id.setter
    def firewall_id(self, firewall_id):
        """Sets the firewall_id of this DetectionDegradationEvent.

        Parent firewall of the degradation event.  # noqa: E501

        :param firewall_id: The firewall_id of this DetectionDegradationEvent.  # noqa: E501
        :type: str
        """

        self._firewall_id = firewall_id

    @property
    def degradation_event_id(self):
        """Gets the degradation_event_id of this DetectionDegradationEvent.  # noqa: E501


        :return: The degradation_event_id of this DetectionDegradationEvent.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._degradation_event_id

    @degradation_event_id.setter
    def degradation_event_id(self, degradation_event_id):
        """Sets the degradation_event_id of this DetectionDegradationEvent.


        :param degradation_event_id: The degradation_event_id of this DetectionDegradationEvent.  # noqa: E501
        :type: RimeUUID
        """

        self._degradation_event_id = degradation_event_id

    @property
    def monitor_id(self):
        """Gets the monitor_id of this DetectionDegradationEvent.  # noqa: E501


        :return: The monitor_id of this DetectionDegradationEvent.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._monitor_id

    @monitor_id.setter
    def monitor_id(self, monitor_id):
        """Sets the monitor_id of this DetectionDegradationEvent.


        :param monitor_id: The monitor_id of this DetectionDegradationEvent.  # noqa: E501
        :type: RimeUUID
        """

        self._monitor_id = monitor_id

    @property
    def event_range(self):
        """Gets the event_range of this DetectionDegradationEvent.  # noqa: E501


        :return: The event_range of this DetectionDegradationEvent.  # noqa: E501
        :rtype: RimeTimeInterval
        """
        return self._event_range

    @event_range.setter
    def event_range(self, event_range):
        """Sets the event_range of this DetectionDegradationEvent.


        :param event_range: The event_range of this DetectionDegradationEvent.  # noqa: E501
        :type: RimeTimeInterval
        """

        self._event_range = event_range

    @property
    def event_context_range(self):
        """Gets the event_context_range of this DetectionDegradationEvent.  # noqa: E501


        :return: The event_context_range of this DetectionDegradationEvent.  # noqa: E501
        :rtype: RimeTimeInterval
        """
        return self._event_context_range

    @event_context_range.setter
    def event_context_range(self, event_context_range):
        """Sets the event_context_range of this DetectionDegradationEvent.


        :param event_context_range: The event_context_range of this DetectionDegradationEvent.  # noqa: E501
        :type: RimeTimeInterval
        """

        self._event_context_range = event_context_range

    @property
    def description(self):
        """Gets the description of this DetectionDegradationEvent.  # noqa: E501

        Human-readable description of the decline in the high-level metric.  # noqa: E501

        :return: The description of this DetectionDegradationEvent.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DetectionDegradationEvent.

        Human-readable description of the decline in the high-level metric.  # noqa: E501

        :param description: The description of this DetectionDegradationEvent.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def rca_result(self):
        """Gets the rca_result of this DetectionDegradationEvent.  # noqa: E501


        :return: The rca_result of this DetectionDegradationEvent.  # noqa: E501
        :rtype: RcaRCAResult
        """
        return self._rca_result

    @rca_result.setter
    def rca_result(self, rca_result):
        """Sets the rca_result of this DetectionDegradationEvent.


        :param rca_result: The rca_result of this DetectionDegradationEvent.  # noqa: E501
        :type: RcaRCAResult
        """

        self._rca_result = rca_result

    @property
    def severity(self):
        """Gets the severity of this DetectionDegradationEvent.  # noqa: E501


        :return: The severity of this DetectionDegradationEvent.  # noqa: E501
        :rtype: RimeSeverity
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this DetectionDegradationEvent.


        :param severity: The severity of this DetectionDegradationEvent.  # noqa: E501
        :type: RimeSeverity
        """

        self._severity = severity

    @property
    def last_detection_time(self):
        """Gets the last_detection_time of this DetectionDegradationEvent.  # noqa: E501

        Keep track of when detection was last run. For instance, for old test run bins that we update after the fact, we want some way of knowing that it is currently relevant. The event start and end time do not convey that information on their own.  # noqa: E501

        :return: The last_detection_time of this DetectionDegradationEvent.  # noqa: E501
        :rtype: datetime
        """
        return self._last_detection_time

    @last_detection_time.setter
    def last_detection_time(self, last_detection_time):
        """Sets the last_detection_time of this DetectionDegradationEvent.

        Keep track of when detection was last run. For instance, for old test run bins that we update after the fact, we want some way of knowing that it is currently relevant. The event start and end time do not convey that information on their own.  # noqa: E501

        :param last_detection_time: The last_detection_time of this DetectionDegradationEvent.  # noqa: E501
        :type: datetime
        """

        self._last_detection_time = last_detection_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DetectionDegradationEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DetectionDegradationEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
