"""init

Revision ID: d39766e64a84
Revises: 
Create Date: 2019-05-10 17:46:04.376145

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'd39766e64a84'
down_revision = None
branch_labels = None
depends_on = None

def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('access_tokens',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('token', sa.Text(), nullable=True),
    sa.Column('expires_at', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_access_tokens'))
    )
    op.create_index('token_index', 'access_tokens', ['token'], unique=True, mysql_length=255)
    op.create_table('services',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('url', sa.Text(), nullable=True),
    sa.Column('name', sa.Text(), nullable=True),
    sa.Column('type', sa.Text(), nullable=True),
    sa.Column('purl', sa.Text(), nullable=True),
    sa.Column('public', sa.Integer(), nullable=True),
    sa.Column('verify', sa.Integer(), nullable=True),
    sa.Column('auth', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_services'))
    )
    op.create_index('name_index', 'services', ['name'], unique=True, mysql_length=255)
    # ### end Alembic commands ###

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('name_index', table_name='services')
    op.drop_table('services')
    op.drop_index('token_index', table_name='access_tokens')
    op.drop_table('access_tokens')
    # ### end Alembic commands ###
