import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleKmsCryptoKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The KeyRing that this key belongs to. Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}''.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key.html#key_ring DataGoogleKmsCryptoKey#key_ring}
     *
     * @stability stable
     */
    readonly keyRing: string;
    /**
     * The resource name for the CryptoKey.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key.html#name DataGoogleKmsCryptoKey#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleKmsCryptoKeyVersionTemplate extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    get protectionLevel(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key.html google_kms_crypto_key}.
 *
 * @stability stable
 */
export declare class DataGoogleKmsCryptoKey extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key.html google_kms_crypto_key} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleKmsCryptoKeyConfig);
    /**
     * @stability stable
     */
    get destroyScheduledDuration(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get importOnly(): any;
    private _keyRing?;
    /**
     * @stability stable
     */
    get keyRing(): string;
    /**
     * @stability stable
     */
    set keyRing(value: string);
    /**
     * @stability stable
     */
    get keyRingInput(): string | undefined;
    /**
     * @stability stable
     */
    labels(key: string): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get purpose(): string;
    /**
     * @stability stable
     */
    get rotationPeriod(): string;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get skipInitialVersionCreation(): any;
    /**
     * @stability stable
     */
    versionTemplate(index: string): DataGoogleKmsCryptoKeyVersionTemplate;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
