import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudPrivateCrossconnectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/private_crossconnect#description DataIonoscloudPrivateCrossconnect#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/private_crossconnect#id DataIonoscloudPrivateCrossconnect#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/private_crossconnect#name DataIonoscloudPrivateCrossconnect#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/private_crossconnect#timeouts DataIonoscloudPrivateCrossconnect#timeouts}
    */
    readonly timeouts?: DataIonoscloudPrivateCrossconnectTimeouts;
}
export interface DataIonoscloudPrivateCrossconnectConnectableDatacenters {
}
export declare function dataIonoscloudPrivateCrossconnectConnectableDatacentersToTerraform(struct?: DataIonoscloudPrivateCrossconnectConnectableDatacenters): any;
export declare class DataIonoscloudPrivateCrossconnectConnectableDatacentersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudPrivateCrossconnectConnectableDatacenters | undefined;
    set internalValue(value: DataIonoscloudPrivateCrossconnectConnectableDatacenters | undefined);
    get id(): string;
    get location(): string;
    get name(): string;
}
export declare class DataIonoscloudPrivateCrossconnectConnectableDatacentersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudPrivateCrossconnectConnectableDatacentersOutputReference;
}
export interface DataIonoscloudPrivateCrossconnectPeers {
}
export declare function dataIonoscloudPrivateCrossconnectPeersToTerraform(struct?: DataIonoscloudPrivateCrossconnectPeers): any;
export declare class DataIonoscloudPrivateCrossconnectPeersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudPrivateCrossconnectPeers | undefined;
    set internalValue(value: DataIonoscloudPrivateCrossconnectPeers | undefined);
    get datacenterId(): string;
    get datacenterName(): string;
    get lanId(): string;
    get lanName(): string;
    get location(): string;
}
export declare class DataIonoscloudPrivateCrossconnectPeersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudPrivateCrossconnectPeersOutputReference;
}
export interface DataIonoscloudPrivateCrossconnectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/private_crossconnect#create DataIonoscloudPrivateCrossconnect#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/private_crossconnect#default DataIonoscloudPrivateCrossconnect#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/private_crossconnect#delete DataIonoscloudPrivateCrossconnect#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/private_crossconnect#update DataIonoscloudPrivateCrossconnect#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudPrivateCrossconnectTimeoutsToTerraform(struct?: DataIonoscloudPrivateCrossconnectTimeoutsOutputReference | DataIonoscloudPrivateCrossconnectTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudPrivateCrossconnectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudPrivateCrossconnectTimeouts | undefined;
    set internalValue(value: DataIonoscloudPrivateCrossconnectTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/private_crossconnect ionoscloud_private_crossconnect}
*/
export declare class DataIonoscloudPrivateCrossconnect extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_private_crossconnect";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/private_crossconnect ionoscloud_private_crossconnect} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudPrivateCrossconnectConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudPrivateCrossconnectConfig);
    private _connectableDatacenters;
    get connectableDatacenters(): DataIonoscloudPrivateCrossconnectConnectableDatacentersList;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _peers;
    get peers(): DataIonoscloudPrivateCrossconnectPeersList;
    private _timeouts;
    get timeouts(): DataIonoscloudPrivateCrossconnectTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudPrivateCrossconnectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudPrivateCrossconnectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-ionoscloud-private-crossconnect.d.ts.map