"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Channel = exports.ChannelType = exports.LatencyMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("@aws-cdk/core");
const ivs_generated_1 = require("./ivs.generated");
const stream_key_1 = require("./stream-key");
/**
 * Reference to a new or existing IVS Channel
 */
class ChannelBase extends core.Resource {
    /**
     * (experimental) Adds a stream key for this IVS Channel.
     *
     * @experimental
     */
    addStreamKey(id) {
        return new stream_key_1.StreamKey(this, id, {
            channel: this,
        });
    }
}
/**
 * (experimental) Channel latency mode.
 *
 * @experimental
 */
var LatencyMode;
(function (LatencyMode) {
    LatencyMode["LOW"] = "LOW";
    LatencyMode["NORMAL"] = "NORMAL";
})(LatencyMode = exports.LatencyMode || (exports.LatencyMode = {}));
/**
 * (experimental) The channel type, which determines the allowable resolution and bitrate.
 *
 * If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
 *
 * @experimental
 */
var ChannelType;
(function (ChannelType) {
    ChannelType["STANDARD"] = "STANDARD";
    ChannelType["BASIC"] = "BASIC";
})(ChannelType = exports.ChannelType || (exports.ChannelType = {}));
/**
 * (experimental) A new IVS channel.
 *
 * @experimental
 */
class Channel extends ChannelBase {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.name,
        });
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new ivs_generated_1.CfnChannel(this, 'Resource', {
            authorized: props.authorized,
            latencyMode: props.latencyMode,
            name: props.name,
            type: props.type,
        });
        this.channelArn = resource.attrArn;
        this.channelIngestEndpoint = resource.attrIngestEndpoint;
        this.channelPlaybackUrl = resource.attrPlaybackUrl;
    }
    /**
     * (experimental) Import an existing channel.
     *
     * @experimental
     */
    static fromChannelArn(scope, id, channelArn) {
        // This will throw an error if the arn cannot be parsed
        let arnComponents = core.Arn.parse(channelArn);
        if (!core.Token.isUnresolved(arnComponents.service) && arnComponents.service !== 'ivs') {
            throw new Error(`Invalid service, expected 'ivs', got '${arnComponents.service}'`);
        }
        if (!core.Token.isUnresolved(arnComponents.resource) && arnComponents.resource !== 'channel') {
            throw new Error(`Invalid resource, expected 'channel', got '${arnComponents.resource}'`);
        }
        class Import extends ChannelBase {
            constructor() {
                super(...arguments);
                this.channelArn = channelArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.Channel = Channel;
_a = JSII_RTTI_SYMBOL_1;
Channel[_a] = { fqn: "@aws-cdk/aws-ivs.Channel", version: "1.125.0" };
//# sourceMappingURL=data:application/json;base64,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