{% macro db2_for_i__get_catalog(information_schemas, schemas) -%}

  {%- call statement('catalog', fetch_result=True) -%}

    WITH columns AS (
      SELECT
        main_cols.COLUMN_NAME AS COLUMN_NAME,
        main_cols.SYSTEM_COLUMN_NAME,
        main_cols.DATA_TYPE,
        cols_cat.TABLE_CATALOG AS DATABASE,
        main_cols.TABLE_NAME,
        main_cols.TABLE_SCHEMA,
        main_cols.ORDINAL_POSITION
      FROM QSYS2.SYSCOLUMNS AS main_cols
      LEFT JOIN (
        SELECT * FROM QSYS2.COLUMNS
      ) AS cols_cat
      ON main_cols.table_schema = cols_cat.table_schema
        AND main_cols.table_name = cols_cat.table_name
        AND main_cols.column_name = cols_cat.column_name
    ),

    tables AS (
      SELECT
        tabs_cat.TABLE_CATALOG AS DATABASE,
        main_tabs.TABLE_SCHEMA,
        main_tabs.TABLE_NAME,
        CASE
          WHEN tabs_cat.TABLE_TYPE LIKE '%TABLE%' THEN 'table'
          WHEN tabs_cat.TABLE_TYPE = 'VIEW' THEN 'view'
        END AS TABLE_TYPE,
        main_tabs.TABLE_DEFINER,
        main_tabs.COLUMN_COUNT,
        main_tabs.TABLE_TEXT,
        main_tabs.SYSTEM_TABLE_NAME,
        main_tabs.FILE_TYPE,
        main_tabs.LAST_ALTERED_TIMESTAMP
      FROM QSYS2.SYSTABLES AS main_tabs
      LEFT JOIN (
        SELECT * FROM QSYS2.TABLES
      ) AS tabs_cat
      ON main_tabs.table_schema = tabs_cat.table_schema
        AND main_tabs.table_name = tabs_cat.table_name
      WHERE tabs_cat.TABLE_TYPE = 'VIEW' OR tabs_cat.TABLE_TYPE LIKE '%TABLE%'
    )

    SELECT
      TRIM(tables.DATABASE) AS "table_database",
      TRIM(tables.TABLE_SCHEMA) AS "table_schema",
      TRIM(tables.TABLE_NAME) AS "table_name",
      tables.TABLE_TYPE AS "table_type",
      tables.TABLE_TEXT AS "table_comment",
      tables.TABLE_DEFINER AS "table_owner",

      'File Type' AS "stats:file_type:label",
      'Type of file' AS "stats:file_type:description",
      tables.FILE_TYPE AS "stats:file_type:value",
      -- the include ones should be a boolean but at the moment, db2 does not support returning boolean
      -- ideally, this should be (tables.FILE_TYPE IS NOT NULL). I am using 0 and 1 in place of true and false for now
      CASE WHEN tables.FILE_TYPE IS NULL THEN 0 ELSE 1 END AS "stats:file_type:include",

      'System Table Name' AS "stats:system_table_name:label",
      'A 10-character name that is generated by the system automatically when not defined' AS "stats:system_table_name:description",
      tables.SYSTEM_TABLE_NAME AS "stats:system_table_name:value",
      CASE WHEN tables.SYSTEM_TABLE_NAME IS NULL THEN 0 ELSE 1 END AS "stats:system_table_name:include",

      'Column Count' AS "stats:column_count:label",
      'Number of columns in the table' AS "stats:column_count:description",
      tables.COLUMN_COUNT AS "stats:column_count:value",
      CASE WHEN tables.COLUMN_COUNT IS NULL THEN 0 ELSE 1 END AS "stats:column_count:include",

      'Last Altered Timestamp' AS "stats:last_altered_timestamp:label",
      'Last time table was modified' AS "stats:last_altered_timestamp:description",
      tables.LAST_ALTERED_TIMESTAMP AS "stats:last_altered_timestamp:value",
      CASE WHEN tables.LAST_ALTERED_TIMESTAMP IS NULL THEN 0 ELSE 1 END AS "stats:last_altered_timestamp:include",

      LOWER(TRIM(columns.COLUMN_NAME)) AS "column_name",
      columns.ORDINAL_POSITION AS "column_index",
      columns.DATA_TYPE AS "column_type",
      NULLIF('','') AS "column_comment",
      TRIM(columns.SYSTEM_COLUMN_NAME) AS "system_column_name"
    FROM tables
    INNER JOIN columns ON
      columns.DATABASE = tables.DATABASE AND
      columns.TABLE_SCHEMA = tables.TABLE_SCHEMA AND
      columns.TABLE_NAME = tables.TABLE_NAME
    WHERE (
        {%- for schema in schemas -%}
          tables.TABLE_SCHEMA = UPPER('{{ schema }}') {%- if not loop.last %} OR {% endif -%}
        {%- endfor -%}
    )
    ORDER BY
      tables.TABLE_SCHEMA,
      tables.TABLE_NAME,
      columns.ORDINAL_POSITION

  {%- endcall -%}

  {{ return(load_result('catalog').table) }}

{%- endmacro %}
