"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Drs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [drs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticdisasterrecovery.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Drs extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [drs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticdisasterrecovery.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'drs';
        this.accessLevelList = {
            Write: [
                'AssociateFailbackClientToRecoveryInstanceForDrs',
                'BatchCreateVolumeSnapshotGroupForDrs',
                'BatchDeleteSnapshotRequestForDrs',
                'CreateConvertedSnapshotForDrs',
                'CreateExtendedSourceServer',
                'CreateRecoveryInstanceForDrs',
                'CreateReplicationConfigurationTemplate',
                'CreateSessionForDrs',
                'CreateSourceServerForDrs',
                'DeleteJob',
                'DeleteRecoveryInstance',
                'DeleteReplicationConfigurationTemplate',
                'DeleteSourceServer',
                'DisconnectRecoveryInstance',
                'DisconnectSourceServer',
                'InitializeService',
                'IssueAgentCertificateForDrs',
                'NotifyAgentAuthenticationForDrs',
                'NotifyAgentConnectedForDrs',
                'NotifyAgentDisconnectedForDrs',
                'NotifyAgentReplicationProgressForDrs',
                'NotifyConsistencyAttainedForDrs',
                'NotifyReplicationServerAuthenticationForDrs',
                'NotifyVolumeEventForDrs',
                'RetryDataReplication',
                'SendAgentLogsForDrs',
                'SendAgentMetricsForDrs',
                'SendChannelCommandResultForDrs',
                'SendClientLogsForDrs',
                'SendClientMetricsForDrs',
                'SendVolumeStatsForDrs',
                'StartFailbackLaunch',
                'StartRecovery',
                'StopFailback',
                'TerminateRecoveryInstances',
                'UpdateAgentBacklogForDrs',
                'UpdateAgentConversionInfoForDrs',
                'UpdateAgentReplicationInfoForDrs',
                'UpdateAgentReplicationProcessStateForDrs',
                'UpdateAgentSourcePropertiesForDrs',
                'UpdateFailbackClientDeviceMappingForDrs',
                'UpdateFailbackClientLastSeenForDrs',
                'UpdateFailbackReplicationConfiguration',
                'UpdateLaunchConfiguration',
                'UpdateReplicationCertificateForDrs',
                'UpdateReplicationConfiguration',
                'UpdateReplicationConfigurationTemplate'
            ],
            Read: [
                'DescribeJobLogItems',
                'DescribeJobs',
                'DescribeRecoveryInstances',
                'DescribeRecoverySnapshots',
                'DescribeReplicationConfigurationTemplates',
                'DescribeReplicationServerAssociationsForDrs',
                'DescribeSnapshotRequestsForDrs',
                'DescribeSourceServers',
                'GetAgentCommandForDrs',
                'GetAgentConfirmedResumeInfoForDrs',
                'GetAgentInstallationAssetsForDrs',
                'GetAgentReplicationInfoForDrs',
                'GetAgentRuntimeConfigurationForDrs',
                'GetAgentSnapshotCreditsForDrs',
                'GetChannelCommandsForDrs',
                'GetFailbackCommandForDrs',
                'GetFailbackLaunchRequestedForDrs',
                'GetFailbackReplicationConfiguration',
                'GetLaunchConfiguration',
                'GetReplicationConfiguration',
                'GetSuggestedFailbackClientDeviceMappingForDrs',
                'ListExtensibleSourceServers',
                'ListStagingAccounts',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to get associate failback client to recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toAssociateFailbackClientToRecoveryInstanceForDrs() {
        return this.to('AssociateFailbackClientToRecoveryInstanceForDrs');
    }
    /**
     * Grants permission to batch create volume snapshot group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toBatchCreateVolumeSnapshotGroupForDrs() {
        return this.to('BatchCreateVolumeSnapshotGroupForDrs');
    }
    /**
     * Grants permission to batch delete snapshot request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toBatchDeleteSnapshotRequestForDrs() {
        return this.to('BatchDeleteSnapshotRequestForDrs');
    }
    /**
     * Grants permission to create converted snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateConvertedSnapshotForDrs() {
        return this.to('CreateConvertedSnapshotForDrs');
    }
    /**
     * Grants permission to extend a source server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_CreateExtendedSourceServer.html
     */
    toCreateExtendedSourceServer() {
        return this.to('CreateExtendedSourceServer');
    }
    /**
     * Grants permission to create recovery instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateRecoveryInstanceForDrs() {
        return this.to('CreateRecoveryInstanceForDrs');
    }
    /**
     * Grants permission to create replication configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_CreateReplicationConfigurationTemplate.html
     */
    toCreateReplicationConfigurationTemplate() {
        return this.to('CreateReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to create a session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateSessionForDrs() {
        return this.to('CreateSessionForDrs');
    }
    /**
     * Grants permission to create a source server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateSourceServerForDrs() {
        return this.to('CreateSourceServerForDrs');
    }
    /**
     * Grants permission to delete a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteJob.html
     */
    toDeleteJob() {
        return this.to('DeleteJob');
    }
    /**
     * Grants permission to delete recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteRecoveryInstance.html
     */
    toDeleteRecoveryInstance() {
        return this.to('DeleteRecoveryInstance');
    }
    /**
     * Grants permission to delete replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteReplicationConfigurationTemplate.html
     */
    toDeleteReplicationConfigurationTemplate() {
        return this.to('DeleteReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to delete source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteSourceServer.html
     */
    toDeleteSourceServer() {
        return this.to('DeleteSourceServer');
    }
    /**
     * Grants permission to describe job log items
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeJobLogItems.html
     */
    toDescribeJobLogItems() {
        return this.to('DescribeJobLogItems');
    }
    /**
     * Grants permission to describe jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeJobs.html
     */
    toDescribeJobs() {
        return this.to('DescribeJobs');
    }
    /**
     * Grants permission to describe recovery instances
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeRecoveryInstances.html
     */
    toDescribeRecoveryInstances() {
        return this.to('DescribeRecoveryInstances');
    }
    /**
     * Grants permission to describe recovery snapshots
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeRecoverySnapshots.html
     */
    toDescribeRecoverySnapshots() {
        return this.to('DescribeRecoverySnapshots');
    }
    /**
     * Grants permission to describe replication configuration template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeReplicationConfigurationTemplates.html
     */
    toDescribeReplicationConfigurationTemplates() {
        return this.to('DescribeReplicationConfigurationTemplates');
    }
    /**
     * Grants permission to describe replication server associations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toDescribeReplicationServerAssociationsForDrs() {
        return this.to('DescribeReplicationServerAssociationsForDrs');
    }
    /**
     * Grants permission to describe snapshot requests
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toDescribeSnapshotRequestsForDrs() {
        return this.to('DescribeSnapshotRequestsForDrs');
    }
    /**
     * Grants permission to describe source servers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeSourceServers.html
     */
    toDescribeSourceServers() {
        return this.to('DescribeSourceServers');
    }
    /**
     * Grants permission to disconnect recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DisconnectRecoveryInstance.html
     */
    toDisconnectRecoveryInstance() {
        return this.to('DisconnectRecoveryInstance');
    }
    /**
     * Grants permission to disconnect source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DisconnectSourceServer.html
     */
    toDisconnectSourceServer() {
        return this.to('DisconnectSourceServer');
    }
    /**
     * Grants permission to get agent command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentCommandForDrs() {
        return this.to('GetAgentCommandForDrs');
    }
    /**
     * Grants permission to get agent confirmed resume info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentConfirmedResumeInfoForDrs() {
        return this.to('GetAgentConfirmedResumeInfoForDrs');
    }
    /**
     * Grants permission to get agent installation assets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentInstallationAssetsForDrs() {
        return this.to('GetAgentInstallationAssetsForDrs');
    }
    /**
     * Grants permission to get agent replication info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentReplicationInfoForDrs() {
        return this.to('GetAgentReplicationInfoForDrs');
    }
    /**
     * Grants permission to get agent runtime configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentRuntimeConfigurationForDrs() {
        return this.to('GetAgentRuntimeConfigurationForDrs');
    }
    /**
     * Grants permission to get agent snapshot credits
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentSnapshotCreditsForDrs() {
        return this.to('GetAgentSnapshotCreditsForDrs');
    }
    /**
     * Grants permission to get channel commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetChannelCommandsForDrs() {
        return this.to('GetChannelCommandsForDrs');
    }
    /**
     * Grants permission to get failback command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetFailbackCommandForDrs() {
        return this.to('GetFailbackCommandForDrs');
    }
    /**
     * Grants permission to get failback launch requested
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetFailbackLaunchRequestedForDrs() {
        return this.to('GetFailbackLaunchRequestedForDrs');
    }
    /**
     * Grants permission to get failback replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetFailbackReplicationConfiguration.html
     */
    toGetFailbackReplicationConfiguration() {
        return this.to('GetFailbackReplicationConfiguration');
    }
    /**
     * Grants permission to get launch configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetLaunchConfiguration.html
     */
    toGetLaunchConfiguration() {
        return this.to('GetLaunchConfiguration');
    }
    /**
     * Grants permission to get replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetReplicationConfiguration.html
     */
    toGetReplicationConfiguration() {
        return this.to('GetReplicationConfiguration');
    }
    /**
     * Grants permission to get suggested failback client device mapping
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetSuggestedFailbackClientDeviceMappingForDrs() {
        return this.to('GetSuggestedFailbackClientDeviceMappingForDrs');
    }
    /**
     * Grants permission to initialize service
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AddRoleToInstanceProfile
     * - iam:CreateInstanceProfile
     * - iam:CreateServiceLinkedRole
     * - iam:GetInstanceProfile
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_InitializeService.html
     */
    toInitializeService() {
        return this.to('InitializeService');
    }
    /**
     * Grants permission to issue an agent certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toIssueAgentCertificateForDrs() {
        return this.to('IssueAgentCertificateForDrs');
    }
    /**
     * Grants permission to list extensible source servers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_ListExtensibleSourceServers.html
     */
    toListExtensibleSourceServers() {
        return this.to('ListExtensibleSourceServers');
    }
    /**
     * Grants permission to list staging accounts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_ListStagingAccounts.html
     */
    toListStagingAccounts() {
        return this.to('ListStagingAccounts');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to notify agent authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentAuthenticationForDrs() {
        return this.to('NotifyAgentAuthenticationForDrs');
    }
    /**
     * Grants permission to notify agent is connected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentConnectedForDrs() {
        return this.to('NotifyAgentConnectedForDrs');
    }
    /**
     * Grants permission to notify agent is disconnected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentDisconnectedForDrs() {
        return this.to('NotifyAgentDisconnectedForDrs');
    }
    /**
     * Grants permission to notify agent replication progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentReplicationProgressForDrs() {
        return this.to('NotifyAgentReplicationProgressForDrs');
    }
    /**
     * Grants permission to notify consistency attained
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyConsistencyAttainedForDrs() {
        return this.to('NotifyConsistencyAttainedForDrs');
    }
    /**
     * Grants permission to notify replication server authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyReplicationServerAuthenticationForDrs() {
        return this.to('NotifyReplicationServerAuthenticationForDrs');
    }
    /**
     * Grants permission to notify replicator volume events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyVolumeEventForDrs() {
        return this.to('NotifyVolumeEventForDrs');
    }
    /**
     * Grants permission to retry data replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_RetryDataReplication.html
     */
    toRetryDataReplication() {
        return this.to('RetryDataReplication');
    }
    /**
     * Grants permission to send agent logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendAgentLogsForDrs() {
        return this.to('SendAgentLogsForDrs');
    }
    /**
     * Grants permission to send agent metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendAgentMetricsForDrs() {
        return this.to('SendAgentMetricsForDrs');
    }
    /**
     * Grants permission to send channel command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendChannelCommandResultForDrs() {
        return this.to('SendChannelCommandResultForDrs');
    }
    /**
     * Grants permission to send client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendClientLogsForDrs() {
        return this.to('SendClientLogsForDrs');
    }
    /**
     * Grants permission to send client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendClientMetricsForDrs() {
        return this.to('SendClientMetricsForDrs');
    }
    /**
     * Grants permission to send volume throughput statistics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendVolumeStatsForDrs() {
        return this.to('SendVolumeStatsForDrs');
    }
    /**
     * Grants permission to start failback launch
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartFailbackLaunch.html
     */
    toStartFailbackLaunch() {
        return this.to('StartFailbackLaunch');
    }
    /**
     * Grants permission to start recovery
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - drs:CreateRecoveryInstanceForDrs
     * - drs:ListTagsForResource
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartRecovery.html
     */
    toStartRecovery() {
        return this.to('StartRecovery');
    }
    /**
     * Grants permission to stop failback
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StopFailback.html
     */
    toStopFailback() {
        return this.to('StopFailback');
    }
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCreateAction()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to terminate recovery instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DeleteVolume
     * - ec2:DescribeInstances
     * - ec2:DescribeVolumes
     * - ec2:TerminateInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_TerminateRecoveryInstances.html
     */
    toTerminateRecoveryInstances() {
        return this.to('TerminateRecoveryInstances');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update agent backlog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentBacklogForDrs() {
        return this.to('UpdateAgentBacklogForDrs');
    }
    /**
     * Grants permission to update agent conversion info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentConversionInfoForDrs() {
        return this.to('UpdateAgentConversionInfoForDrs');
    }
    /**
     * Grants permission to update agent replication info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentReplicationInfoForDrs() {
        return this.to('UpdateAgentReplicationInfoForDrs');
    }
    /**
     * Grants permission to update agent replication process state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentReplicationProcessStateForDrs() {
        return this.to('UpdateAgentReplicationProcessStateForDrs');
    }
    /**
     * Grants permission to update agent source properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentSourcePropertiesForDrs() {
        return this.to('UpdateAgentSourcePropertiesForDrs');
    }
    /**
     * Grants permission to update failback client device mapping
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateFailbackClientDeviceMappingForDrs() {
        return this.to('UpdateFailbackClientDeviceMappingForDrs');
    }
    /**
     * Grants permission to update failback client last seen
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateFailbackClientLastSeenForDrs() {
        return this.to('UpdateFailbackClientLastSeenForDrs');
    }
    /**
     * Grants permission to update failback replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateFailbackReplicationConfiguration.html
     */
    toUpdateFailbackReplicationConfiguration() {
        return this.to('UpdateFailbackReplicationConfiguration');
    }
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateLaunchConfiguration.html
     */
    toUpdateLaunchConfiguration() {
        return this.to('UpdateLaunchConfiguration');
    }
    /**
     * Grants permission to update a replication certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateReplicationCertificateForDrs() {
        return this.to('UpdateReplicationCertificateForDrs');
    }
    /**
     * Grants permission to update replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateReplicationConfiguration.html
     */
    toUpdateReplicationConfiguration() {
        return this.to('UpdateReplicationConfiguration');
    }
    /**
     * Grants permission to update replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateReplicationConfigurationTemplate.html
     */
    toUpdateReplicationConfigurationTemplate() {
        return this.to('UpdateReplicationConfigurationTemplate');
    }
    /**
     * Adds a resource of type JobResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/failback-overview.html
     *
     * @param jobID - Identifier for the jobID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobResource(jobID, account, region, partition) {
        return this.on(`arn:${partition || Drs.defaultPartition}:drs:${region || '*'}:${account || '*'}:job/${jobID}`);
    }
    /**
     * Adds a resource of type RecoveryInstanceResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/recovery-instances.html
     *
     * @param recoveryInstanceID - Identifier for the recoveryInstanceID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifEC2InstanceARN()
     */
    onRecoveryInstanceResource(recoveryInstanceID, account, region, partition) {
        return this.on(`arn:${partition || Drs.defaultPartition}:drs:${region || '*'}:${account || '*'}:recovery-instance/${recoveryInstanceID}`);
    }
    /**
     * Adds a resource of type ReplicationConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/replication-settings-template.html
     *
     * @param replicationConfigurationTemplateID - Identifier for the replicationConfigurationTemplateID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReplicationConfigurationTemplateResource(replicationConfigurationTemplateID, account, region, partition) {
        return this.on(`arn:${partition || Drs.defaultPartition}:drs:${region || '*'}:${account || '*'}:replication-configuration-template/${replicationConfigurationTemplateID}`);
    }
    /**
     * Adds a resource of type SourceServerResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/source-servers.html
     *
     * @param sourceServerID - Identifier for the sourceServerID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSourceServerResource(sourceServerID, account, region, partition) {
        return this.on(`arn:${partition || Drs.defaultPartition}:drs:${region || '*'}:${account || '*'}:source-server/${sourceServerID}`);
    }
    /**
     * Filters access by the name of a resource-creating API action
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/supported-iam-actions-tagging.html
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreateAction(value, operator) {
        return this.if(`CreateAction`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the EC2 instance the request originated from
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/security_iam_authentication.html
     *
     * Applies to resource types:
     * - RecoveryInstanceResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifEC2InstanceARN(value, operator) {
        return this.if(`EC2InstanceARN`, value, operator || 'StringLike');
    }
}
exports.Drs = Drs;
_a = JSII_RTTI_SYMBOL_1;
Drs[_a] = { fqn: "iam-floyd.Drs", version: "0.395.0" };
//# sourceMappingURL=data:application/json;base64,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