"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitySource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents an identity source.
 *
 * The source can be specified either as a literal value (e.g: `Auth`) which
 * cannot be blank, or as an unresolved string token.
 *
 * @stability stable
 */
class IdentitySource {
    /**
     * Provides a properly formatted header identity source.
     *
     * @param headerName the name of the header the `IdentitySource` will represent.
     * @returns a header identity source.
     * @stability stable
     */
    static header(headerName) {
        return IdentitySource.toString(headerName, 'method.request.header');
    }
    /**
     * Provides a properly formatted query string identity source.
     *
     * @param queryString the name of the query string the `IdentitySource` will represent.
     * @returns a query string identity source.
     * @stability stable
     */
    static queryString(queryString) {
        return IdentitySource.toString(queryString, 'method.request.querystring');
    }
    /**
     * Provides a properly formatted API Gateway stage variable identity source.
     *
     * @param stageVariable the name of the stage variable the `IdentitySource` will represent.
     * @returns an API Gateway stage variable identity source.
     * @stability stable
     */
    static stageVariable(stageVariable) {
        return IdentitySource.toString(stageVariable, 'stageVariables');
    }
    /**
     * Provides a properly formatted request context identity source.
     *
     * @param context the name of the context variable the `IdentitySource` will represent.
     * @returns a request context identity source.
     * @stability stable
     */
    static context(context) {
        return IdentitySource.toString(context, 'context');
    }
    static toString(source, type) {
        if (!source.trim()) {
            throw new Error('IdentitySources must be a non-empty string.');
        }
        return `${type}.${source}`;
    }
}
exports.IdentitySource = IdentitySource;
_a = JSII_RTTI_SYMBOL_1;
IdentitySource[_a] = { fqn: "@aws-cdk/aws-apigateway.IdentitySource", version: "1.138.1" };
//# sourceMappingURL=data:application/json;base64,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