# Honeycomb OpenTelemetry Distro for Python

<!-- Uncomment once repo is public -->
[![OSS Lifecycle](https://img.shields.io/osslifecycle/honeycombio/honeycomb-opentelemetry-python)](https://github.com/honeycombio/home/blob/main/honeycomb-oss-lifecycle-and-practices.md)
[![CircleCI](https://circleci.com/gh/honeycombio/honeycomb-opentelemetry-python.svg?style=shield)](https://circleci.com/gh/honeycombio/honeycomb-opentelemetry-python)

This is Honeycomb's Distribution of OpenTelemetry for python.
It makes getting started with OpenTelemetry and Honeycomb easier!

## Requirements

* Python 3.7 or higher

## Getting Started

Honeycomb's Distribution of OpenTelemetry for python allows you to streamline configuration and to instrument as quickly and easily as possible.

- [Documentation](https://docs.honeycomb.io/getting-data-in/opentelemetry/python/)
- [Examples](/examples/)
- See [DEVELOPING.md](/DEVELOPING.md) for additional instructions for building and testing this project in development.

## Why would I want to use this?

- Streamlined configuration for sending data to Honeycomb!
- Easy interop with existing instrumentation with OpenTelemetry!
- Deterministic sampling!
- Multi-span attributes!
- Local visualizations!

## License

[Apache 2.0 License](./LICENSE).

## Examples

### Example Flask Application

Readme can be found [here](examples/hello-world-flask/README.md) for setting this up.

### Example Python Application

Readme can be found [here](examples/hello-world/README.md) for setting this up.
