"""
Provides constants for the application.
"""

from enum import Enum
from os import getenv
from pathlib import Path


class constants(Enum):  # pylint: disable=invalid-name
    """
    Constants for the application
    """

    # Time
    SECOND = 1
    MINUTE = 60 * SECOND
    HOUR = 60 * MINUTE
    DAY = 24 * HOUR
    WEEK = 7 * DAY
    MONTH = 30 * DAY
    YEAR = 365 * DAY

    # Redis
    REDIS_HOST_ENV = "REDIS_HOST"
    REDIS_HOST_ENV_DEFAULT = "localhost"
    REDIS_PORT_ENV = "REDIS_PORT"
    REDIS_PORT_ENV_DEFAULT = 6379
    REDIS_DB_ENV = "REDIS_DB"
    REDIS_DB_ENV_DEFAULT = 0
    REDIS_PASSWORD_ENV = "REDIS_PASSWORD"
    REDIS_PASSWORD_ENV_DEFAULT = None
    REDIS_QUEUE_NAME_ENV = "REDIS_QUEUE_NAME"
    REDIS_QUEUE_NAME_ENV_DEFAULT = None

    # Database
    DB_HOST_ENV = "DB_HOST"
    DB_HOST_ENV_DEFAULT = None
    DB_PORT_ENV = "DB_PORT"
    DB_PORT_ENV_DEFAULT = 5432
    DB_USER_ENV = "DB_USER"
    DB_USER_ENV_DEFAULT = "postgres"
    DB_PASSWORD_ENV = "DB_PASSWORD"
    DB_PASSWORD_ENV_DEFAULT = None
    DB_NAME_ENV = "DB_NAME"
    DB_NAME_ENV_DEFAULT = "scoach"
    RUN_STATUS_CREATED = "CREATED"
    RUN_STATUS_QUEUED = "QUEUED"
    RUN_STATUS_RUNNING = "RUNNING"
    RUN_STATUS_COMPLETED = "COMPLETED"
    RUN_STATUS_FAILED = "FAILED"
    RUN_STATUS_CANCELED = "CANCELED"

    # SLURM
    SLURM_PARTITION_ENV = "SLURM_PARTITION"
    SLURM_PARTITION_ENV_DEFAULT = None
    SLURM_CORES_PER_JOB_ENV = "SLURM_CORES_PER_JOB"
    SLURM_CORES_PER_JOB_ENV_DEFAULT = 1
    SLURM_MEMORY_PER_JOB_ENV = "SLURM_MEMORY_PER_JOB"
    SLURM_MEMORY_PER_JOB_ENV_DEFAULT = "1G"
    SLURM_WORKER_NAME_ENV = "SLURM_WORKER_NAME"
    SLURM_WORKER_NAME_ENV_DEFAULT = None
    SLURM_JOB_EXCLUSIVE_ENV = "SLURM_JOB_EXCLUSIVE"
    SLURM_JOB_EXCLUSIVE_ENV_DEFAULT = False
    SLURM_MAX_WORKERS_ENV = "SLURM_MAX_WORKERS"
    SLURM_MAX_WORKERS_ENV_DEFAULT = 1

    # MinIO
    MINIO_ENDPOINT_ENV = "MINIO_ENDPOINT"
    MINIO_ENDPOINT_ENV_DEFAULT = None
    MINIO_ENDPOINT_SCHEMA_ENV = "MINIO_ENDPOINT_SCHEMA"
    MINIO_ENDPOINT_SCHEMA_ENV_DEFAULT = "https"
    MINIO_ENDPOINT_PORT_ENV = "MINIO_ENDPOINT_PORT"
    MINIO_ENDPOINT_PORT_ENV_DEFAULT = 443
    MINIO_ACCESS_KEY_ENV = "MINIO_ACCESS_KEY"
    MINIO_ACCESS_KEY_ENV_DEFAULT = None
    MINIO_SECRET_KEY_ENV = "MINIO_SECRET_KEY"
    MINIO_SECRET_KEY_ENV_DEFAULT = None
    MINIO_BUCKET_ENV = "MINIO_BUCKET"
    MINIO_BUCKET_ENV_DEFAULT = None
    WEIGHTS_PATH_PREFIX = "weights/"
    SCRIPTS_PATH_PREFIX = "scripts/"
    DATASETS_PATH_PREFIX = "datasets"

    # Dask scheduler
    DASK_DEFAULT_WORKERS = 0

    # scoach
    SCOACH_DEFAULT_CONFIG_PATH = Path.home() / ".scoach/config.yaml"
    SCHEDULER_SLEEP_TIME = 30 * SECOND

    # Django
    DJANGO_SETTINGS_MODE_ENV = "DJANGO_SETTINGS_MODE"
    DJANGO_SETTINGS_MODE_ENV_DEFAULT = "prod"
