# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['plugin']
install_requires = \
['Jinja2>=3.0.3,<4.0.0', 'requests>=2.27.1,<3.0.0']

entry_points = \
{'mkdocs.plugins': ['external-markdown = '
                    'external_markdown.plugin:EmbedExternalMarkdown']}

setup_kwargs = {
    'name': 'mkdocs-embed-external-markdown-sd0408',
    'version': '2.1.5',
    'description': 'Mkdocs plugin that allow to inject external markdown or markdown section from given url',
    'long_description': '# MkDocs Embed External Markdown Plugin\n\n[![PyPI - Downloads][pypi-image]][pypi-url]\n[![contributions welcome][contributions-image]][contributions-url]\n[![MIT license][license-image]][license-url]\n\n[pypi-image]: https://img.shields.io/pypi/dm/mkdocs-embed-external-markdown\n[pypi-url]: https://pypi.org/project/mkdocs-embed-external-markdown/\n[contributions-image]: https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat\n[contributions-url]: https://github.com/fire1ce/mkdocs-embed-external-markdown\n[license-image]: https://img.shields.io/badge/License-MIT-blue.svg\n[license-url]: https://mit-license.org/\n\n## About\n\nMkDocs Embed External Markdown plugin that allows to inject **section** or **full markdown** content from a given url.\nThe goal is to embed different markdown from different sources inside your MkDocs project.\n\n## Version 2.xx\n\n**Braking change: Section name must include Markdown Section header like: `## Section name`**\n\nChangelog:\n\n- [x] Added support for multi level sections such as `### Section name` and `#### Section name`\n- [x] Better Handling of parsing makrdowns wich contains `#` in the content\n- [x] Failing Mkdocs Build when Markdown content cannot be fetched\n\n## Installation\n\nInstall the package with pip:\n\n```shell\npip install mkdocs-embed-external-markdown\n```\n\n## Configuration\n\nEnable the plugin in your `mkdocs.yml` file:\n\n```yaml\nplugins:\n  - external-markdown\n```\n\n## Usage\n\n- Section defined by **"##/###/####..."** header (h2/h3/h4...)\n- **"#"** header (h1) will be **removed** from source content so you can use use your own header\n- **"##/###/####..."** header (h2/h3/h4...) will be **removed** from source **section** content so you can use use your own header\n- Supports multiple **sections** from any source\n\n`external_markdown` requires 2 parameters: **url** and **section name**.\n\n```makrdown\n{{ external_markdown(\'url\', \'## section name\') }}\n```\n\n### Full Markdown Content\n\nEmbed full markdown content from a given url, you can use the following example:\n\n```markdown\n{{ external_markdown(\'https://raw.githubusercontent.com/fire1ce/DDNS-Cloudflare-Bash/main/README.md\', \'\') }}\n```\n\n### Specific Section\n\nEmbed markdown section from a given url, you can use the following example:\n\n```markdown\n{{ external_markdown(\'https://raw.githubusercontent.com/fire1ce/DDNS-Cloudflare-Bash/main/README.md\', \'## Installation\') }}\n```\n\n## MkDocs Example\n\nThe following example shows how to use the plugin in mkdocs project:\n\n````markdown\n# Example Page\n\nThis is an example page.\n\n## Embedding Multiple Markdown Sections From Different URLs\n\n### First Embedded Section\n\n```markdown\n{{ external_markdown(\'https://raw.githubusercontent.com/mkdocs/mkdocs/master/README.md\', \'## Features\') }}\n```\n\n### Second Embedded Section\n\n```markdown\n{{ external_markdown(\'https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/README.md\', \'## Quick start\') }}\n```\n````\n\nWill produce the following page:\n\n![MkDocs Embed External Markdown Plugin](https://user-images.githubusercontent.com/16795594/155761254-17b47e65-d27e-438b-a476-15bd04fdc3ec.jpg)\n\n## How To Prevent Accidental Interpretation Of `Jinja-like` Statements\n\nThe most frequent issue when adding the `MkDocs Embed External Markdown Plugin` to an existing mkdocs project, is that some markdown pages may not be rendered correctly, or cause a syntax error, or some other error.\n\nThe reason is that if Jinja2 template engine in the **MkDocs Embed External Markdown Plugin** meets any text that has the standard markers (typically starting with `{%`} or `{{`) this will cause a conflict: it will try to interpret that text as a macro and fail to behave properly.\n\nThe most likely places where this can occur are the following:\n\n| Location in Markdown file (Block or Inline) | Description                                                                                                |\n| ------------------------------------------- | ---------------------------------------------------------------------------------------------------------- |\n| **Code**                                    | Documented Jinja2 statements (or similar syntax), LaTeX                                                    |\n| **Maths**                                   | LaTeX statements                                                                                           |\n| _*Elsewhere*_                               | Some pre-existing templating or macro language, typically with some constructs starting with `{#` or `{{`. |\n\n### Code Blocks Containing Similar Languages\n\nWith MkDocs, this situation typically occurs when the website\nis documenting an application that relies on a\n[djangolike/jinjalike language](https://medium.com/@i5ar/template-languages-a7b362971cbc) like:\n\n- Django Template Language\n- Jinja2 (Python)\n- Nunjucks (Javascript)\n- Twig (PHP)\n- ...\n\nThis may also happen for pages that documents\n[Ansible](https://ansible-docs.readthedocs.io/zh/stable-2.0/rst/intro.html) directives, which often contain\n[variables expressed in a Jinja2 syntax](https://ansible-docs.readthedocs.io/zh/stable-2.0/rst/playbooks_variables.html#using-variables-about-jinja2).\n\n### Solutions - Explicitly Marking The Snippets as `raw`\n\n````markdown\n{% raw %}\n\n```bash\ndocker inspect -f \'{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}\' container_name_or_id\n```\n\n{% endraw %}\n````\n\n## Known Issues\n\n- [ ] Embedding links without `.md` extension not working properly\n\n## License\n\n### MIT License\n\nCopyright© 3os.org @ 2022\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to\ndeal in the Software without restriction, including without limitation the\nrights to use, copy, modify, merge, publish, distribute, sublicense, and/or\nsell copies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in\nall copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\nFROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS\nIN THE SOFTWARE.\n',
    'author': 'fire1ce',
    'author_email': 'dev@3os.org',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://3os.org/guides/markdown-cheatsheet/external-markdown/',
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
