"""Initial database layout

Revision ID: 1b4b1c179e5a
Revises:
Create Date: 2022-07-02 20:36:23.501403

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = '1b4b1c179e5a'
down_revision = None
branch_labels = None
depends_on = None

def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('badges',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.Text(), nullable=True),
    sa.Column('image', sa.LargeBinary(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_badges'))
    )
    op.create_table('users',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=True),
    sa.Column('password', sa.LargeBinary(), nullable=True),
    sa.Column('salt', sa.LargeBinary(), nullable=True),
    sa.Column('email', sa.Text(), nullable=True),
    sa.Column('is_admin', sa.Boolean(), nullable=True),
    sa.Column('is_verified', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_users'))
    )
    op.create_index('idx_users_email', 'users', ['email'], unique=True)
    op.create_table('friend_requests',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('sender_id', sa.Integer(), nullable=True),
    sa.Column('recipient_id', sa.Integer(), nullable=True),
    sa.Column('date', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['recipient_id'], ['users.id'], name=op.f('fk_friend_requests_recipient_id_users')),
    sa.ForeignKeyConstraint(['sender_id'], ['users.id'], name=op.f('fk_friend_requests_sender_id_users')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_friend_requests')),
    sa.UniqueConstraint('sender_id', 'recipient_id', name=op.f('uq_friend_requests_sender_id'))
    )
    op.create_table('friends_assoc',
    sa.Column('user_1_id', sa.Integer(), nullable=False),
    sa.Column('user_2_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_1_id'], ['users.id'], name=op.f('fk_friends_assoc_user_1_id_users')),
    sa.ForeignKeyConstraint(['user_2_id'], ['users.id'], name=op.f('fk_friends_assoc_user_2_id_users')),
    sa.PrimaryKeyConstraint('user_1_id', 'user_2_id', name=op.f('pk_friends_assoc'))
    )
    op.create_table('tokens',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('uuid', sa.Text(), nullable=True),
    sa.Column('token_type', sa.Enum('VERIFY_EMAIL', 'RESET_PASSWORD', name='tokentype'), nullable=True),
    sa.Column('date', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], name=op.f('fk_tokens_user_id_users')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tokens'))
    )
    op.create_index('idx_token_uuid', 'tokens', ['uuid'], unique=True)
    op.create_table('tracks',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('owner_id', sa.Integer(), nullable=True),
    sa.Column('title', sa.Text(), nullable=True),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('date', sa.DateTime(), nullable=True),
    sa.Column('gpx', sa.LargeBinary(), nullable=True),
    sa.Column('visibility', sa.Enum('PRIVATE', 'FRIENDS', 'FRIENDS_TAGGED', 'LOGGED_IN', 'PUBLIC', name='visibility'), nullable=True),
    sa.Column('link_secret', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['owner_id'], ['users.id'], name=op.f('fk_tracks_owner_id_users')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tracks'))
    )
    op.create_table('uploads',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uploaded_at', sa.DateTime(), nullable=True),
    sa.Column('owner_id', sa.Integer(), nullable=True),
    sa.Column('gpx', sa.LargeBinary(), nullable=True),
    sa.ForeignKeyConstraint(['owner_id'], ['users.id'], name=op.f('fk_uploads_owner_id_users')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_uploads'))
    )
    op.create_table('comments',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('author_id', sa.Integer(), nullable=True),
    sa.Column('track_id', sa.Integer(), nullable=True),
    sa.Column('date', sa.DateTime(), nullable=True),
    sa.Column('title', sa.Text(), nullable=True),
    sa.Column('text', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['author_id'], ['users.id'], name=op.f('fk_comments_author_id_users')),
    sa.ForeignKeyConstraint(['track_id'], ['tracks.id'], name=op.f('fk_comments_track_id_tracks')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_comments'))
    )
    op.create_table('tags',
    sa.Column('track_id', sa.Integer(), nullable=False),
    sa.Column('tag', sa.Text(), nullable=False),
    sa.ForeignKeyConstraint(['track_id'], ['tracks.id'], name=op.f('fk_tags_track_id_tracks')),
    sa.PrimaryKeyConstraint('track_id', 'tag', name=op.f('pk_tags'))
    )
    op.create_table('track_badge_assoc',
    sa.Column('track_id', sa.Integer(), nullable=False),
    sa.Column('badge_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['badge_id'], ['badges.id'], name=op.f('fk_track_badge_assoc_badge_id_badges')),
    sa.ForeignKeyConstraint(['track_id'], ['tracks.id'], name=op.f('fk_track_badge_assoc_track_id_tracks')),
    sa.PrimaryKeyConstraint('track_id', 'badge_id', name=op.f('pk_track_badge_assoc'))
    )
    op.create_table('track_cache',
    sa.Column('track_id', sa.Integer(), nullable=False),
    sa.Column('length', sa.Float(), nullable=True),
    sa.Column('uphill', sa.Float(), nullable=True),
    sa.Column('downhill', sa.Float(), nullable=True),
    sa.Column('moving_time', sa.Float(), nullable=True),
    sa.Column('stopped_time', sa.Float(), nullable=True),
    sa.Column('max_speed', sa.Float(), nullable=True),
    sa.Column('avg_speed', sa.Float(), nullable=True),
    sa.Column('start_time', sa.DateTime(), nullable=True),
    sa.Column('end_time', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['track_id'], ['tracks.id'], name=op.f('fk_track_cache_track_id_tracks')),
    sa.PrimaryKeyConstraint('track_id', name=op.f('pk_track_cache'))
    )
    op.create_table('track_people_assoc',
    sa.Column('track_id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['track_id'], ['tracks.id'], name=op.f('fk_track_people_assoc_track_id_tracks')),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], name=op.f('fk_track_people_assoc_user_id_users')),
    sa.PrimaryKeyConstraint('track_id', 'user_id', name=op.f('pk_track_people_assoc'))
    )
    # ### end Alembic commands ###

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('track_people_assoc')
    op.drop_table('track_cache')
    op.drop_table('track_badge_assoc')
    op.drop_table('tags')
    op.drop_table('comments')
    op.drop_table('uploads')
    op.drop_table('tracks')
    op.drop_index('idx_token_uuid', table_name='tokens')
    op.drop_table('tokens')
    op.drop_table('friends_assoc')
    op.drop_table('friend_requests')
    op.drop_index('idx_users_email', table_name='users')
    op.drop_table('users')
    op.drop_table('badges')
    # ### end Alembic commands ###
