"""remove gpx data from db

Revision ID: c939800af428
Revises: d085998b49ca
Create Date: 2022-12-14 23:58:37.983942

"""
import logging

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = 'c939800af428'
down_revision = 'd085998b49ca'
branch_labels = None
depends_on = None

def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    try:
        op.drop_column('tracks', 'gpx')
    except sa.exc.OperationalError as exc:
        # sqlite < 3.35.0 does not know "ALTER TABLE DROP COLUMN", in which
        # case we probably don't want to break the DB. Instead, we simply
        # "drop" the column by setting it empty, which should still help in
        # saving some space.
        logging.getLogger(__name__).warning(
            "Your database does not support dropping a column. "
            "We're setting the content to zero instead (%s).",
            exc,
        )
        op.execute("UPDATE tracks SET gpx = '';")
    # ### end Alembic commands ###

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    try:
        op.add_column('tracks', sa.Column('gpx', sa.BLOB(), nullable=True))
    except sa.exc.OperationalError as exc:
        logging.getLogger(__name__).warning(
            "The column already exists - doing nothing (%s).",
            exc,
        )
    # ### end Alembic commands ###
