'''
# `vault_transform_template`

Refer to the Terraform Registory for docs: [`vault_transform_template`](https://www.terraform.io/docs/providers/vault/r/transform_template).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdktf
import constructs


class TransformTemplate(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-vault.transformTemplate.TransformTemplate",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/vault/r/transform_template vault_transform_template}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id_: builtins.str,
        *,
        name: builtins.str,
        path: builtins.str,
        alphabet: typing.Optional[builtins.str] = None,
        decode_formats: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        encode_format: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
        pattern: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
        connection: typing.Optional[typing.Union[typing.Union[cdktf.SSHProvisionerConnection, typing.Dict[str, typing.Any]], typing.Union[cdktf.WinrmProvisionerConnection, typing.Dict[str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        for_each: typing.Optional[cdktf.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[cdktf.TerraformResourceLifecycle, typing.Dict[str, typing.Any]]] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[cdktf.FileProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.LocalExecProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.RemoteExecProvisioner, typing.Dict[str, typing.Any]]]]] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/vault/r/transform_template vault_transform_template} Resource.

        :param scope: The scope in which to define this construct.
        :param id_: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param name: The name of the template. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#name TransformTemplate#name}
        :param path: The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws". Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#path TransformTemplate#path}
        :param alphabet: The alphabet to use for this template. This is only used during FPE transformations. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#alphabet TransformTemplate#alphabet}
        :param decode_formats: The map of regular expression templates used to customize decoded outputs. Only applicable to FPE transformations. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#decode_formats TransformTemplate#decode_formats}
        :param encode_format: The regular expression template used for encoding values. Only applicable to FPE transformations. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#encode_format TransformTemplate#encode_format}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#id TransformTemplate#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param namespace: Target namespace. (requires Enterprise). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#namespace TransformTemplate#namespace}
        :param pattern: The pattern used for matching. Currently, only regular expression pattern is supported. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#pattern TransformTemplate#pattern}
        :param type: The pattern type to use for match detection. Currently, only regex is supported. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#type TransformTemplate#type}
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(TransformTemplate.__init__)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id_", value=id_, expected_type=type_hints["id_"])
        config = TransformTemplateConfig(
            name=name,
            path=path,
            alphabet=alphabet,
            decode_formats=decode_formats,
            encode_format=encode_format,
            id=id,
            namespace=namespace,
            pattern=pattern,
            type=type,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id_, config])

    @jsii.member(jsii_name="resetAlphabet")
    def reset_alphabet(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAlphabet", []))

    @jsii.member(jsii_name="resetDecodeFormats")
    def reset_decode_formats(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDecodeFormats", []))

    @jsii.member(jsii_name="resetEncodeFormat")
    def reset_encode_format(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEncodeFormat", []))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetNamespace")
    def reset_namespace(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetNamespace", []))

    @jsii.member(jsii_name="resetPattern")
    def reset_pattern(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetPattern", []))

    @jsii.member(jsii_name="resetType")
    def reset_type(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetType", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property
    @jsii.member(jsii_name="alphabetInput")
    def alphabet_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "alphabetInput"))

    @builtins.property
    @jsii.member(jsii_name="decodeFormatsInput")
    def decode_formats_input(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], jsii.get(self, "decodeFormatsInput"))

    @builtins.property
    @jsii.member(jsii_name="encodeFormatInput")
    def encode_format_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "encodeFormatInput"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="nameInput")
    def name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "nameInput"))

    @builtins.property
    @jsii.member(jsii_name="namespaceInput")
    def namespace_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "namespaceInput"))

    @builtins.property
    @jsii.member(jsii_name="pathInput")
    def path_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "pathInput"))

    @builtins.property
    @jsii.member(jsii_name="patternInput")
    def pattern_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "patternInput"))

    @builtins.property
    @jsii.member(jsii_name="typeInput")
    def type_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "typeInput"))

    @builtins.property
    @jsii.member(jsii_name="alphabet")
    def alphabet(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "alphabet"))

    @alphabet.setter
    def alphabet(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(TransformTemplate, "alphabet").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "alphabet", value)

    @builtins.property
    @jsii.member(jsii_name="decodeFormats")
    def decode_formats(self) -> typing.Mapping[builtins.str, builtins.str]:
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "decodeFormats"))

    @decode_formats.setter
    def decode_formats(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(TransformTemplate, "decode_formats").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "decodeFormats", value)

    @builtins.property
    @jsii.member(jsii_name="encodeFormat")
    def encode_format(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "encodeFormat"))

    @encode_format.setter
    def encode_format(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(TransformTemplate, "encode_format").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "encodeFormat", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @id.setter
    def id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(TransformTemplate, "id").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(TransformTemplate, "name").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="namespace")
    def namespace(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "namespace"))

    @namespace.setter
    def namespace(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(TransformTemplate, "namespace").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "namespace", value)

    @builtins.property
    @jsii.member(jsii_name="path")
    def path(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "path"))

    @path.setter
    def path(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(TransformTemplate, "path").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "path", value)

    @builtins.property
    @jsii.member(jsii_name="pattern")
    def pattern(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "pattern"))

    @pattern.setter
    def pattern(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(TransformTemplate, "pattern").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "pattern", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))

    @type.setter
    def type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(TransformTemplate, "type").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "type", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-vault.transformTemplate.TransformTemplateConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "name": "name",
        "path": "path",
        "alphabet": "alphabet",
        "decode_formats": "decodeFormats",
        "encode_format": "encodeFormat",
        "id": "id",
        "namespace": "namespace",
        "pattern": "pattern",
        "type": "type",
    },
)
class TransformTemplateConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[cdktf.SSHProvisionerConnection, typing.Dict[str, typing.Any]], typing.Union[cdktf.WinrmProvisionerConnection, typing.Dict[str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        for_each: typing.Optional[cdktf.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[cdktf.TerraformResourceLifecycle, typing.Dict[str, typing.Any]]] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[cdktf.FileProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.LocalExecProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.RemoteExecProvisioner, typing.Dict[str, typing.Any]]]]] = None,
        name: builtins.str,
        path: builtins.str,
        alphabet: typing.Optional[builtins.str] = None,
        decode_formats: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        encode_format: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
        pattern: typing.Optional[builtins.str] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param name: The name of the template. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#name TransformTemplate#name}
        :param path: The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws". Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#path TransformTemplate#path}
        :param alphabet: The alphabet to use for this template. This is only used during FPE transformations. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#alphabet TransformTemplate#alphabet}
        :param decode_formats: The map of regular expression templates used to customize decoded outputs. Only applicable to FPE transformations. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#decode_formats TransformTemplate#decode_formats}
        :param encode_format: The regular expression template used for encoding values. Only applicable to FPE transformations. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#encode_format TransformTemplate#encode_format}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#id TransformTemplate#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param namespace: Target namespace. (requires Enterprise). Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#namespace TransformTemplate#namespace}
        :param pattern: The pattern used for matching. Currently, only regular expression pattern is supported. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#pattern TransformTemplate#pattern}
        :param type: The pattern type to use for match detection. Currently, only regex is supported. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#type TransformTemplate#type}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if __debug__:
            type_hints = typing.get_type_hints(TransformTemplateConfig.__init__)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument alphabet", value=alphabet, expected_type=type_hints["alphabet"])
            check_type(argname="argument decode_formats", value=decode_formats, expected_type=type_hints["decode_formats"])
            check_type(argname="argument encode_format", value=encode_format, expected_type=type_hints["encode_format"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            check_type(argname="argument pattern", value=pattern, expected_type=type_hints["pattern"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[str, typing.Any] = {
            "name": name,
            "path": path,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if alphabet is not None:
            self._values["alphabet"] = alphabet
        if decode_formats is not None:
            self._values["decode_formats"] = decode_formats
        if encode_format is not None:
            self._values["encode_format"] = encode_format
        if id is not None:
            self._values["id"] = id
        if namespace is not None:
            self._values["namespace"] = namespace
        if pattern is not None:
            self._values["pattern"] = pattern
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]], result)

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[cdktf.ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[cdktf.ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the template.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#name TransformTemplate#name}
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws".

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#path TransformTemplate#path}
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alphabet(self) -> typing.Optional[builtins.str]:
        '''The alphabet to use for this template. This is only used during FPE transformations.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#alphabet TransformTemplate#alphabet}
        '''
        result = self._values.get("alphabet")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def decode_formats(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''The map of regular expression templates used to customize decoded outputs. Only applicable to FPE transformations.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#decode_formats TransformTemplate#decode_formats}
        '''
        result = self._values.get("decode_formats")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def encode_format(self) -> typing.Optional[builtins.str]:
        '''The regular expression template used for encoding values. Only applicable to FPE transformations.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#encode_format TransformTemplate#encode_format}
        '''
        result = self._values.get("encode_format")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#id TransformTemplate#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''Target namespace. (requires Enterprise).

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#namespace TransformTemplate#namespace}
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def pattern(self) -> typing.Optional[builtins.str]:
        '''The pattern used for matching. Currently, only regular expression pattern is supported.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#pattern TransformTemplate#pattern}
        '''
        result = self._values.get("pattern")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''The pattern type to use for match detection. Currently, only regex is supported.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#type TransformTemplate#type}
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TransformTemplateConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "TransformTemplate",
    "TransformTemplateConfig",
]

publication.publish()
