"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdSecretBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend vault_ad_secret_backend}
*/
class AdSecretBackend extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_backend vault_ad_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdSecretBackendConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_ad_secret_backend',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.9.1',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._anonymousGroupSearch = config.anonymousGroupSearch;
        this._backend = config.backend;
        this._binddn = config.binddn;
        this._bindpass = config.bindpass;
        this._caseSensitiveNames = config.caseSensitiveNames;
        this._certificate = config.certificate;
        this._clientTlsCert = config.clientTlsCert;
        this._clientTlsKey = config.clientTlsKey;
        this._defaultLeaseTtlSeconds = config.defaultLeaseTtlSeconds;
        this._denyNullBind = config.denyNullBind;
        this._description = config.description;
        this._disableRemount = config.disableRemount;
        this._discoverdn = config.discoverdn;
        this._formatter = config.formatter;
        this._groupattr = config.groupattr;
        this._groupdn = config.groupdn;
        this._groupfilter = config.groupfilter;
        this._id = config.id;
        this._insecureTls = config.insecureTls;
        this._lastRotationTolerance = config.lastRotationTolerance;
        this._length = config.length;
        this._local = config.local;
        this._maxLeaseTtlSeconds = config.maxLeaseTtlSeconds;
        this._maxTtl = config.maxTtl;
        this._namespace = config.namespace;
        this._passwordPolicy = config.passwordPolicy;
        this._requestTimeout = config.requestTimeout;
        this._starttls = config.starttls;
        this._tlsMaxVersion = config.tlsMaxVersion;
        this._tlsMinVersion = config.tlsMinVersion;
        this._ttl = config.ttl;
        this._upndomain = config.upndomain;
        this._url = config.url;
        this._usePre111GroupCnBehavior = config.usePre111GroupCnBehavior;
        this._useTokenGroups = config.useTokenGroups;
        this._userattr = config.userattr;
        this._userdn = config.userdn;
    }
    get anonymousGroupSearch() {
        return this.getBooleanAttribute('anonymous_group_search');
    }
    set anonymousGroupSearch(value) {
        this._anonymousGroupSearch = value;
    }
    resetAnonymousGroupSearch() {
        this._anonymousGroupSearch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get anonymousGroupSearchInput() {
        return this._anonymousGroupSearch;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get binddn() {
        return this.getStringAttribute('binddn');
    }
    set binddn(value) {
        this._binddn = value;
    }
    // Temporarily expose input value. Use with caution.
    get binddnInput() {
        return this._binddn;
    }
    get bindpass() {
        return this.getStringAttribute('bindpass');
    }
    set bindpass(value) {
        this._bindpass = value;
    }
    // Temporarily expose input value. Use with caution.
    get bindpassInput() {
        return this._bindpass;
    }
    get caseSensitiveNames() {
        return this.getBooleanAttribute('case_sensitive_names');
    }
    set caseSensitiveNames(value) {
        this._caseSensitiveNames = value;
    }
    resetCaseSensitiveNames() {
        this._caseSensitiveNames = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caseSensitiveNamesInput() {
        return this._caseSensitiveNames;
    }
    get certificate() {
        return this.getStringAttribute('certificate');
    }
    set certificate(value) {
        this._certificate = value;
    }
    resetCertificate() {
        this._certificate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certificateInput() {
        return this._certificate;
    }
    get clientTlsCert() {
        return this.getStringAttribute('client_tls_cert');
    }
    set clientTlsCert(value) {
        this._clientTlsCert = value;
    }
    resetClientTlsCert() {
        this._clientTlsCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientTlsCertInput() {
        return this._clientTlsCert;
    }
    get clientTlsKey() {
        return this.getStringAttribute('client_tls_key');
    }
    set clientTlsKey(value) {
        this._clientTlsKey = value;
    }
    resetClientTlsKey() {
        this._clientTlsKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientTlsKeyInput() {
        return this._clientTlsKey;
    }
    get defaultLeaseTtlSeconds() {
        return this.getNumberAttribute('default_lease_ttl_seconds');
    }
    set defaultLeaseTtlSeconds(value) {
        this._defaultLeaseTtlSeconds = value;
    }
    resetDefaultLeaseTtlSeconds() {
        this._defaultLeaseTtlSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultLeaseTtlSecondsInput() {
        return this._defaultLeaseTtlSeconds;
    }
    get denyNullBind() {
        return this.getBooleanAttribute('deny_null_bind');
    }
    set denyNullBind(value) {
        this._denyNullBind = value;
    }
    resetDenyNullBind() {
        this._denyNullBind = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get denyNullBindInput() {
        return this._denyNullBind;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get disableRemount() {
        return this.getBooleanAttribute('disable_remount');
    }
    set disableRemount(value) {
        this._disableRemount = value;
    }
    resetDisableRemount() {
        this._disableRemount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableRemountInput() {
        return this._disableRemount;
    }
    get discoverdn() {
        return this.getBooleanAttribute('discoverdn');
    }
    set discoverdn(value) {
        this._discoverdn = value;
    }
    resetDiscoverdn() {
        this._discoverdn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get discoverdnInput() {
        return this._discoverdn;
    }
    get formatter() {
        return this.getStringAttribute('formatter');
    }
    set formatter(value) {
        this._formatter = value;
    }
    resetFormatter() {
        this._formatter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get formatterInput() {
        return this._formatter;
    }
    get groupattr() {
        return this.getStringAttribute('groupattr');
    }
    set groupattr(value) {
        this._groupattr = value;
    }
    resetGroupattr() {
        this._groupattr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupattrInput() {
        return this._groupattr;
    }
    get groupdn() {
        return this.getStringAttribute('groupdn');
    }
    set groupdn(value) {
        this._groupdn = value;
    }
    resetGroupdn() {
        this._groupdn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupdnInput() {
        return this._groupdn;
    }
    get groupfilter() {
        return this.getStringAttribute('groupfilter');
    }
    set groupfilter(value) {
        this._groupfilter = value;
    }
    resetGroupfilter() {
        this._groupfilter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupfilterInput() {
        return this._groupfilter;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get insecureTls() {
        return this.getBooleanAttribute('insecure_tls');
    }
    set insecureTls(value) {
        this._insecureTls = value;
    }
    resetInsecureTls() {
        this._insecureTls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureTlsInput() {
        return this._insecureTls;
    }
    get lastRotationTolerance() {
        return this.getNumberAttribute('last_rotation_tolerance');
    }
    set lastRotationTolerance(value) {
        this._lastRotationTolerance = value;
    }
    resetLastRotationTolerance() {
        this._lastRotationTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lastRotationToleranceInput() {
        return this._lastRotationTolerance;
    }
    get length() {
        return this.getNumberAttribute('length');
    }
    set length(value) {
        this._length = value;
    }
    resetLength() {
        this._length = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lengthInput() {
        return this._length;
    }
    get local() {
        return this.getBooleanAttribute('local');
    }
    set local(value) {
        this._local = value;
    }
    resetLocal() {
        this._local = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localInput() {
        return this._local;
    }
    get maxLeaseTtlSeconds() {
        return this.getNumberAttribute('max_lease_ttl_seconds');
    }
    set maxLeaseTtlSeconds(value) {
        this._maxLeaseTtlSeconds = value;
    }
    resetMaxLeaseTtlSeconds() {
        this._maxLeaseTtlSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxLeaseTtlSecondsInput() {
        return this._maxLeaseTtlSeconds;
    }
    get maxTtl() {
        return this.getNumberAttribute('max_ttl');
    }
    set maxTtl(value) {
        this._maxTtl = value;
    }
    resetMaxTtl() {
        this._maxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTtlInput() {
        return this._maxTtl;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get passwordPolicy() {
        return this.getStringAttribute('password_policy');
    }
    set passwordPolicy(value) {
        this._passwordPolicy = value;
    }
    resetPasswordPolicy() {
        this._passwordPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordPolicyInput() {
        return this._passwordPolicy;
    }
    get requestTimeout() {
        return this.getNumberAttribute('request_timeout');
    }
    set requestTimeout(value) {
        this._requestTimeout = value;
    }
    resetRequestTimeout() {
        this._requestTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestTimeoutInput() {
        return this._requestTimeout;
    }
    get starttls() {
        return this.getBooleanAttribute('starttls');
    }
    set starttls(value) {
        this._starttls = value;
    }
    resetStarttls() {
        this._starttls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get starttlsInput() {
        return this._starttls;
    }
    get tlsMaxVersion() {
        return this.getStringAttribute('tls_max_version');
    }
    set tlsMaxVersion(value) {
        this._tlsMaxVersion = value;
    }
    resetTlsMaxVersion() {
        this._tlsMaxVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsMaxVersionInput() {
        return this._tlsMaxVersion;
    }
    get tlsMinVersion() {
        return this.getStringAttribute('tls_min_version');
    }
    set tlsMinVersion(value) {
        this._tlsMinVersion = value;
    }
    resetTlsMinVersion() {
        this._tlsMinVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsMinVersionInput() {
        return this._tlsMinVersion;
    }
    get ttl() {
        return this.getNumberAttribute('ttl');
    }
    set ttl(value) {
        this._ttl = value;
    }
    resetTtl() {
        this._ttl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ttlInput() {
        return this._ttl;
    }
    get upndomain() {
        return this.getStringAttribute('upndomain');
    }
    set upndomain(value) {
        this._upndomain = value;
    }
    resetUpndomain() {
        this._upndomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get upndomainInput() {
        return this._upndomain;
    }
    get url() {
        return this.getStringAttribute('url');
    }
    set url(value) {
        this._url = value;
    }
    resetUrl() {
        this._url = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get urlInput() {
        return this._url;
    }
    get usePre111GroupCnBehavior() {
        return this.getBooleanAttribute('use_pre111_group_cn_behavior');
    }
    set usePre111GroupCnBehavior(value) {
        this._usePre111GroupCnBehavior = value;
    }
    resetUsePre111GroupCnBehavior() {
        this._usePre111GroupCnBehavior = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usePre111GroupCnBehaviorInput() {
        return this._usePre111GroupCnBehavior;
    }
    get useTokenGroups() {
        return this.getBooleanAttribute('use_token_groups');
    }
    set useTokenGroups(value) {
        this._useTokenGroups = value;
    }
    resetUseTokenGroups() {
        this._useTokenGroups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useTokenGroupsInput() {
        return this._useTokenGroups;
    }
    get userattr() {
        return this.getStringAttribute('userattr');
    }
    set userattr(value) {
        this._userattr = value;
    }
    resetUserattr() {
        this._userattr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userattrInput() {
        return this._userattr;
    }
    get userdn() {
        return this.getStringAttribute('userdn');
    }
    set userdn(value) {
        this._userdn = value;
    }
    resetUserdn() {
        this._userdn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userdnInput() {
        return this._userdn;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            anonymous_group_search: cdktf.booleanToTerraform(this._anonymousGroupSearch),
            backend: cdktf.stringToTerraform(this._backend),
            binddn: cdktf.stringToTerraform(this._binddn),
            bindpass: cdktf.stringToTerraform(this._bindpass),
            case_sensitive_names: cdktf.booleanToTerraform(this._caseSensitiveNames),
            certificate: cdktf.stringToTerraform(this._certificate),
            client_tls_cert: cdktf.stringToTerraform(this._clientTlsCert),
            client_tls_key: cdktf.stringToTerraform(this._clientTlsKey),
            default_lease_ttl_seconds: cdktf.numberToTerraform(this._defaultLeaseTtlSeconds),
            deny_null_bind: cdktf.booleanToTerraform(this._denyNullBind),
            description: cdktf.stringToTerraform(this._description),
            disable_remount: cdktf.booleanToTerraform(this._disableRemount),
            discoverdn: cdktf.booleanToTerraform(this._discoverdn),
            formatter: cdktf.stringToTerraform(this._formatter),
            groupattr: cdktf.stringToTerraform(this._groupattr),
            groupdn: cdktf.stringToTerraform(this._groupdn),
            groupfilter: cdktf.stringToTerraform(this._groupfilter),
            id: cdktf.stringToTerraform(this._id),
            insecure_tls: cdktf.booleanToTerraform(this._insecureTls),
            last_rotation_tolerance: cdktf.numberToTerraform(this._lastRotationTolerance),
            length: cdktf.numberToTerraform(this._length),
            local: cdktf.booleanToTerraform(this._local),
            max_lease_ttl_seconds: cdktf.numberToTerraform(this._maxLeaseTtlSeconds),
            max_ttl: cdktf.numberToTerraform(this._maxTtl),
            namespace: cdktf.stringToTerraform(this._namespace),
            password_policy: cdktf.stringToTerraform(this._passwordPolicy),
            request_timeout: cdktf.numberToTerraform(this._requestTimeout),
            starttls: cdktf.booleanToTerraform(this._starttls),
            tls_max_version: cdktf.stringToTerraform(this._tlsMaxVersion),
            tls_min_version: cdktf.stringToTerraform(this._tlsMinVersion),
            ttl: cdktf.numberToTerraform(this._ttl),
            upndomain: cdktf.stringToTerraform(this._upndomain),
            url: cdktf.stringToTerraform(this._url),
            use_pre111_group_cn_behavior: cdktf.booleanToTerraform(this._usePre111GroupCnBehavior),
            use_token_groups: cdktf.booleanToTerraform(this._useTokenGroups),
            userattr: cdktf.stringToTerraform(this._userattr),
            userdn: cdktf.stringToTerraform(this._userdn),
        };
    }
}
exports.AdSecretBackend = AdSecretBackend;
_a = JSII_RTTI_SYMBOL_1;
AdSecretBackend[_a] = { fqn: "@cdktf/provider-vault.adSecretBackend.AdSecretBackend", version: "3.0.13" };
// =================
// STATIC PROPERTIES
// =================
AdSecretBackend.tfResourceType = "vault_ad_secret_backend";
//# sourceMappingURL=data:application/json;base64,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