"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GcpAuthBackendRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role vault_gcp_auth_backend_role}
*/
class GcpAuthBackendRole extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/gcp_auth_backend_role vault_gcp_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GcpAuthBackendRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_gcp_auth_backend_role',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.9.1',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._addGroupAliases = config.addGroupAliases;
        this._allowGceInference = config.allowGceInference;
        this._backend = config.backend;
        this._boundInstanceGroups = config.boundInstanceGroups;
        this._boundLabels = config.boundLabels;
        this._boundProjects = config.boundProjects;
        this._boundRegions = config.boundRegions;
        this._boundServiceAccounts = config.boundServiceAccounts;
        this._boundZones = config.boundZones;
        this._id = config.id;
        this._maxJwtExp = config.maxJwtExp;
        this._namespace = config.namespace;
        this._role = config.role;
        this._tokenBoundCidrs = config.tokenBoundCidrs;
        this._tokenExplicitMaxTtl = config.tokenExplicitMaxTtl;
        this._tokenMaxTtl = config.tokenMaxTtl;
        this._tokenNoDefaultPolicy = config.tokenNoDefaultPolicy;
        this._tokenNumUses = config.tokenNumUses;
        this._tokenPeriod = config.tokenPeriod;
        this._tokenPolicies = config.tokenPolicies;
        this._tokenTtl = config.tokenTtl;
        this._tokenType = config.tokenType;
        this._type = config.type;
    }
    get addGroupAliases() {
        return this.getBooleanAttribute('add_group_aliases');
    }
    set addGroupAliases(value) {
        this._addGroupAliases = value;
    }
    resetAddGroupAliases() {
        this._addGroupAliases = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get addGroupAliasesInput() {
        return this._addGroupAliases;
    }
    get allowGceInference() {
        return this.getBooleanAttribute('allow_gce_inference');
    }
    set allowGceInference(value) {
        this._allowGceInference = value;
    }
    resetAllowGceInference() {
        this._allowGceInference = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowGceInferenceInput() {
        return this._allowGceInference;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get boundInstanceGroups() {
        return cdktf.Fn.tolist(this.getListAttribute('bound_instance_groups'));
    }
    set boundInstanceGroups(value) {
        this._boundInstanceGroups = value;
    }
    resetBoundInstanceGroups() {
        this._boundInstanceGroups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundInstanceGroupsInput() {
        return this._boundInstanceGroups;
    }
    get boundLabels() {
        return cdktf.Fn.tolist(this.getListAttribute('bound_labels'));
    }
    set boundLabels(value) {
        this._boundLabels = value;
    }
    resetBoundLabels() {
        this._boundLabels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundLabelsInput() {
        return this._boundLabels;
    }
    get boundProjects() {
        return cdktf.Fn.tolist(this.getListAttribute('bound_projects'));
    }
    set boundProjects(value) {
        this._boundProjects = value;
    }
    resetBoundProjects() {
        this._boundProjects = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundProjectsInput() {
        return this._boundProjects;
    }
    get boundRegions() {
        return cdktf.Fn.tolist(this.getListAttribute('bound_regions'));
    }
    set boundRegions(value) {
        this._boundRegions = value;
    }
    resetBoundRegions() {
        this._boundRegions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundRegionsInput() {
        return this._boundRegions;
    }
    get boundServiceAccounts() {
        return cdktf.Fn.tolist(this.getListAttribute('bound_service_accounts'));
    }
    set boundServiceAccounts(value) {
        this._boundServiceAccounts = value;
    }
    resetBoundServiceAccounts() {
        this._boundServiceAccounts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundServiceAccountsInput() {
        return this._boundServiceAccounts;
    }
    get boundZones() {
        return cdktf.Fn.tolist(this.getListAttribute('bound_zones'));
    }
    set boundZones(value) {
        this._boundZones = value;
    }
    resetBoundZones() {
        this._boundZones = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundZonesInput() {
        return this._boundZones;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get maxJwtExp() {
        return this.getStringAttribute('max_jwt_exp');
    }
    set maxJwtExp(value) {
        this._maxJwtExp = value;
    }
    resetMaxJwtExp() {
        this._maxJwtExp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxJwtExpInput() {
        return this._maxJwtExp;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get role() {
        return this.getStringAttribute('role');
    }
    set role(value) {
        this._role = value;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    get tokenBoundCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('token_bound_cidrs'));
    }
    set tokenBoundCidrs(value) {
        this._tokenBoundCidrs = value;
    }
    resetTokenBoundCidrs() {
        this._tokenBoundCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenBoundCidrsInput() {
        return this._tokenBoundCidrs;
    }
    get tokenExplicitMaxTtl() {
        return this.getNumberAttribute('token_explicit_max_ttl');
    }
    set tokenExplicitMaxTtl(value) {
        this._tokenExplicitMaxTtl = value;
    }
    resetTokenExplicitMaxTtl() {
        this._tokenExplicitMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenExplicitMaxTtlInput() {
        return this._tokenExplicitMaxTtl;
    }
    get tokenMaxTtl() {
        return this.getNumberAttribute('token_max_ttl');
    }
    set tokenMaxTtl(value) {
        this._tokenMaxTtl = value;
    }
    resetTokenMaxTtl() {
        this._tokenMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenMaxTtlInput() {
        return this._tokenMaxTtl;
    }
    get tokenNoDefaultPolicy() {
        return this.getBooleanAttribute('token_no_default_policy');
    }
    set tokenNoDefaultPolicy(value) {
        this._tokenNoDefaultPolicy = value;
    }
    resetTokenNoDefaultPolicy() {
        this._tokenNoDefaultPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNoDefaultPolicyInput() {
        return this._tokenNoDefaultPolicy;
    }
    get tokenNumUses() {
        return this.getNumberAttribute('token_num_uses');
    }
    set tokenNumUses(value) {
        this._tokenNumUses = value;
    }
    resetTokenNumUses() {
        this._tokenNumUses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNumUsesInput() {
        return this._tokenNumUses;
    }
    get tokenPeriod() {
        return this.getNumberAttribute('token_period');
    }
    set tokenPeriod(value) {
        this._tokenPeriod = value;
    }
    resetTokenPeriod() {
        this._tokenPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPeriodInput() {
        return this._tokenPeriod;
    }
    get tokenPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('token_policies'));
    }
    set tokenPolicies(value) {
        this._tokenPolicies = value;
    }
    resetTokenPolicies() {
        this._tokenPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPoliciesInput() {
        return this._tokenPolicies;
    }
    get tokenTtl() {
        return this.getNumberAttribute('token_ttl');
    }
    set tokenTtl(value) {
        this._tokenTtl = value;
    }
    resetTokenTtl() {
        this._tokenTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTtlInput() {
        return this._tokenTtl;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            add_group_aliases: cdktf.booleanToTerraform(this._addGroupAliases),
            allow_gce_inference: cdktf.booleanToTerraform(this._allowGceInference),
            backend: cdktf.stringToTerraform(this._backend),
            bound_instance_groups: cdktf.listMapper(cdktf.stringToTerraform, false)(this._boundInstanceGroups),
            bound_labels: cdktf.listMapper(cdktf.stringToTerraform, false)(this._boundLabels),
            bound_projects: cdktf.listMapper(cdktf.stringToTerraform, false)(this._boundProjects),
            bound_regions: cdktf.listMapper(cdktf.stringToTerraform, false)(this._boundRegions),
            bound_service_accounts: cdktf.listMapper(cdktf.stringToTerraform, false)(this._boundServiceAccounts),
            bound_zones: cdktf.listMapper(cdktf.stringToTerraform, false)(this._boundZones),
            id: cdktf.stringToTerraform(this._id),
            max_jwt_exp: cdktf.stringToTerraform(this._maxJwtExp),
            namespace: cdktf.stringToTerraform(this._namespace),
            role: cdktf.stringToTerraform(this._role),
            token_bound_cidrs: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenBoundCidrs),
            token_explicit_max_ttl: cdktf.numberToTerraform(this._tokenExplicitMaxTtl),
            token_max_ttl: cdktf.numberToTerraform(this._tokenMaxTtl),
            token_no_default_policy: cdktf.booleanToTerraform(this._tokenNoDefaultPolicy),
            token_num_uses: cdktf.numberToTerraform(this._tokenNumUses),
            token_period: cdktf.numberToTerraform(this._tokenPeriod),
            token_policies: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenPolicies),
            token_ttl: cdktf.numberToTerraform(this._tokenTtl),
            token_type: cdktf.stringToTerraform(this._tokenType),
            type: cdktf.stringToTerraform(this._type),
        };
    }
}
exports.GcpAuthBackendRole = GcpAuthBackendRole;
_a = JSII_RTTI_SYMBOL_1;
GcpAuthBackendRole[_a] = { fqn: "@cdktf/provider-vault.gcpAuthBackendRole.GcpAuthBackendRole", version: "3.0.13" };
// =================
// STATIC PROPERTIES
// =================
GcpAuthBackendRole.tfResourceType = "vault_gcp_auth_backend_role";
//# sourceMappingURL=data:application/json;base64,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