import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityMfaDuoConfig extends cdktf.TerraformMetaArguments {
    /**
    * API hostname for Duo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_duo#api_hostname IdentityMfaDuo#api_hostname}
    */
    readonly apiHostname: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_duo#id IdentityMfaDuo#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Integration key for Duo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_duo#integration_key IdentityMfaDuo#integration_key}
    */
    readonly integrationKey: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_duo#namespace IdentityMfaDuo#namespace}
    */
    readonly namespace?: string;
    /**
    * Push information for Duo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_duo#push_info IdentityMfaDuo#push_info}
    */
    readonly pushInfo?: string;
    /**
    * Secret key for Duo
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_duo#secret_key IdentityMfaDuo#secret_key}
    */
    readonly secretKey: string;
    /**
    * Require passcode upon MFA validation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_duo#use_passcode IdentityMfaDuo#use_passcode}
    */
    readonly usePasscode?: boolean | cdktf.IResolvable;
    /**
    * A template string for mapping Identity names to MFA methods.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_duo#username_format IdentityMfaDuo#username_format}
    */
    readonly usernameFormat?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_duo vault_identity_mfa_duo}
*/
export declare class IdentityMfaDuo extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_mfa_duo";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_duo vault_identity_mfa_duo} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityMfaDuoConfig
    */
    constructor(scope: Construct, id: string, config: IdentityMfaDuoConfig);
    private _apiHostname?;
    get apiHostname(): string;
    set apiHostname(value: string);
    get apiHostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationKey?;
    get integrationKey(): string;
    set integrationKey(value: string);
    get integrationKeyInput(): string | undefined;
    get methodId(): string;
    get mountAccessor(): string;
    get name(): string;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get namespaceId(): string;
    get namespacePath(): string;
    private _pushInfo?;
    get pushInfo(): string;
    set pushInfo(value: string);
    resetPushInfo(): void;
    get pushInfoInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    get secretKeyInput(): string | undefined;
    get type(): string;
    private _usePasscode?;
    get usePasscode(): boolean | cdktf.IResolvable;
    set usePasscode(value: boolean | cdktf.IResolvable);
    resetUsePasscode(): void;
    get usePasscodeInput(): boolean | cdktf.IResolvable | undefined;
    private _usernameFormat?;
    get usernameFormat(): string;
    set usernameFormat(value: string);
    resetUsernameFormat(): void;
    get usernameFormatInput(): string | undefined;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
