import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityMfaLoginEnforcementConfig extends cdktf.TerraformMetaArguments {
    /**
    * Set of auth method accessor IDs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_login_enforcement#auth_method_accessors IdentityMfaLoginEnforcement#auth_method_accessors}
    */
    readonly authMethodAccessors?: string[];
    /**
    * Set of auth method types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_login_enforcement#auth_method_types IdentityMfaLoginEnforcement#auth_method_types}
    */
    readonly authMethodTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_login_enforcement#id IdentityMfaLoginEnforcement#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of identity entity IDs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_login_enforcement#identity_entity_ids IdentityMfaLoginEnforcement#identity_entity_ids}
    */
    readonly identityEntityIds?: string[];
    /**
    * Set of identity group IDs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_login_enforcement#identity_group_ids IdentityMfaLoginEnforcement#identity_group_ids}
    */
    readonly identityGroupIds?: string[];
    /**
    * Set of MFA method UUIDs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_login_enforcement#mfa_method_ids IdentityMfaLoginEnforcement#mfa_method_ids}
    */
    readonly mfaMethodIds: string[];
    /**
    * Login enforcement name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_login_enforcement#name IdentityMfaLoginEnforcement#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_login_enforcement#namespace IdentityMfaLoginEnforcement#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_login_enforcement vault_identity_mfa_login_enforcement}
*/
export declare class IdentityMfaLoginEnforcement extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_mfa_login_enforcement";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_login_enforcement vault_identity_mfa_login_enforcement} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityMfaLoginEnforcementConfig
    */
    constructor(scope: Construct, id: string, config: IdentityMfaLoginEnforcementConfig);
    private _authMethodAccessors?;
    get authMethodAccessors(): string[];
    set authMethodAccessors(value: string[]);
    resetAuthMethodAccessors(): void;
    get authMethodAccessorsInput(): string[] | undefined;
    private _authMethodTypes?;
    get authMethodTypes(): string[];
    set authMethodTypes(value: string[]);
    resetAuthMethodTypes(): void;
    get authMethodTypesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identityEntityIds?;
    get identityEntityIds(): string[];
    set identityEntityIds(value: string[]);
    resetIdentityEntityIds(): void;
    get identityEntityIdsInput(): string[] | undefined;
    private _identityGroupIds?;
    get identityGroupIds(): string[];
    set identityGroupIds(value: string[]);
    resetIdentityGroupIds(): void;
    get identityGroupIdsInput(): string[] | undefined;
    private _mfaMethodIds?;
    get mfaMethodIds(): string[];
    set mfaMethodIds(value: string[]);
    get mfaMethodIdsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get namespaceId(): string;
    get namespacePath(): string;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
