import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityMfaPingidConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_pingid#id IdentityMfaPingid#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_pingid#namespace IdentityMfaPingid#namespace}
    */
    readonly namespace?: string;
    /**
    * A base64-encoded third-party settings contents as retrieved from PingID's configuration page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_pingid#settings_file_base64 IdentityMfaPingid#settings_file_base64}
    */
    readonly settingsFileBase64: string;
    /**
    * A template string for mapping Identity names to MFA methods.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_pingid#username_format IdentityMfaPingid#username_format}
    */
    readonly usernameFormat?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_pingid vault_identity_mfa_pingid}
*/
export declare class IdentityMfaPingid extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_mfa_pingid";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_pingid vault_identity_mfa_pingid} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityMfaPingidConfig
    */
    constructor(scope: Construct, id: string, config: IdentityMfaPingidConfig);
    get adminUrl(): string;
    get authenticatorUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idpUrl(): string;
    get methodId(): string;
    get mountAccessor(): string;
    get name(): string;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get namespaceId(): string;
    get namespacePath(): string;
    get orgAlias(): string;
    private _settingsFileBase64?;
    get settingsFileBase64(): string;
    set settingsFileBase64(value: string);
    get settingsFileBase64Input(): string | undefined;
    get type(): string;
    get useSignature(): cdktf.IResolvable;
    private _usernameFormat?;
    get usernameFormat(): string;
    set usernameFormat(value: string);
    resetUsernameFormat(): void;
    get usernameFormatInput(): string | undefined;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
