import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityMfaTotpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the hashing algorithm used to generate the TOTP code. Options include SHA1, SHA256, SHA512.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp#algorithm IdentityMfaTotp#algorithm}
    */
    readonly algorithm?: string;
    /**
    * The number of digits in the generated TOTP token. This value can either be 6 or 8
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp#digits IdentityMfaTotp#digits}
    */
    readonly digits?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp#id IdentityMfaTotp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the key's issuing organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp#issuer IdentityMfaTotp#issuer}
    */
    readonly issuer: string;
    /**
    * Specifies the size in bytes of the generated key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp#key_size IdentityMfaTotp#key_size}
    */
    readonly keySize?: number;
    /**
    * The maximum number of consecutive failed validation attempts allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp#max_validation_attempts IdentityMfaTotp#max_validation_attempts}
    */
    readonly maxValidationAttempts?: number;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp#namespace IdentityMfaTotp#namespace}
    */
    readonly namespace?: string;
    /**
    * The length of time in seconds used to generate a counter for the TOTP token calculation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp#period IdentityMfaTotp#period}
    */
    readonly period?: number;
    /**
    * The number of delay periods that are allowed when validating a TOTP token. This value can either be 0 or 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp#skew IdentityMfaTotp#skew}
    */
    readonly skew?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp vault_identity_mfa_totp}
*/
export declare class IdentityMfaTotp extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_mfa_totp";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_mfa_totp vault_identity_mfa_totp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityMfaTotpConfig
    */
    constructor(scope: Construct, id: string, config: IdentityMfaTotpConfig);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    resetAlgorithm(): void;
    get algorithmInput(): string | undefined;
    private _digits?;
    get digits(): number;
    set digits(value: number);
    resetDigits(): void;
    get digitsInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
    private _keySize?;
    get keySize(): number;
    set keySize(value: number);
    resetKeySize(): void;
    get keySizeInput(): number | undefined;
    private _maxValidationAttempts?;
    get maxValidationAttempts(): number;
    set maxValidationAttempts(value: number);
    resetMaxValidationAttempts(): void;
    get maxValidationAttemptsInput(): number | undefined;
    get methodId(): string;
    get mountAccessor(): string;
    get name(): string;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get namespaceId(): string;
    get namespacePath(): string;
    private _period?;
    get period(): number;
    set period(value: number);
    resetPeriod(): void;
    get periodInput(): number | undefined;
    get qrSize(): number;
    private _skew?;
    get skew(): number;
    set skew(value: number);
    resetSkew(): void;
    get skewInput(): number | undefined;
    get type(): string;
    get uuid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
