"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JwtAuthBackendRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role vault_jwt_auth_backend_role}
*/
class JwtAuthBackendRole extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role vault_jwt_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JwtAuthBackendRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_jwt_auth_backend_role',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.9.1',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._allowedRedirectUris = config.allowedRedirectUris;
        this._backend = config.backend;
        this._boundAudiences = config.boundAudiences;
        this._boundClaims = config.boundClaims;
        this._boundClaimsType = config.boundClaimsType;
        this._boundSubject = config.boundSubject;
        this._claimMappings = config.claimMappings;
        this._clockSkewLeeway = config.clockSkewLeeway;
        this._disableBoundClaimsParsing = config.disableBoundClaimsParsing;
        this._expirationLeeway = config.expirationLeeway;
        this._groupsClaim = config.groupsClaim;
        this._id = config.id;
        this._maxAge = config.maxAge;
        this._namespace = config.namespace;
        this._notBeforeLeeway = config.notBeforeLeeway;
        this._oidcScopes = config.oidcScopes;
        this._roleName = config.roleName;
        this._roleType = config.roleType;
        this._tokenBoundCidrs = config.tokenBoundCidrs;
        this._tokenExplicitMaxTtl = config.tokenExplicitMaxTtl;
        this._tokenMaxTtl = config.tokenMaxTtl;
        this._tokenNoDefaultPolicy = config.tokenNoDefaultPolicy;
        this._tokenNumUses = config.tokenNumUses;
        this._tokenPeriod = config.tokenPeriod;
        this._tokenPolicies = config.tokenPolicies;
        this._tokenTtl = config.tokenTtl;
        this._tokenType = config.tokenType;
        this._userClaim = config.userClaim;
        this._userClaimJsonPointer = config.userClaimJsonPointer;
        this._verboseOidcLogging = config.verboseOidcLogging;
    }
    get allowedRedirectUris() {
        return cdktf.Fn.tolist(this.getListAttribute('allowed_redirect_uris'));
    }
    set allowedRedirectUris(value) {
        this._allowedRedirectUris = value;
    }
    resetAllowedRedirectUris() {
        this._allowedRedirectUris = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedRedirectUrisInput() {
        return this._allowedRedirectUris;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get boundAudiences() {
        return cdktf.Fn.tolist(this.getListAttribute('bound_audiences'));
    }
    set boundAudiences(value) {
        this._boundAudiences = value;
    }
    resetBoundAudiences() {
        this._boundAudiences = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundAudiencesInput() {
        return this._boundAudiences;
    }
    get boundClaims() {
        return this.getStringMapAttribute('bound_claims');
    }
    set boundClaims(value) {
        this._boundClaims = value;
    }
    resetBoundClaims() {
        this._boundClaims = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundClaimsInput() {
        return this._boundClaims;
    }
    get boundClaimsType() {
        return this.getStringAttribute('bound_claims_type');
    }
    set boundClaimsType(value) {
        this._boundClaimsType = value;
    }
    resetBoundClaimsType() {
        this._boundClaimsType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundClaimsTypeInput() {
        return this._boundClaimsType;
    }
    get boundSubject() {
        return this.getStringAttribute('bound_subject');
    }
    set boundSubject(value) {
        this._boundSubject = value;
    }
    resetBoundSubject() {
        this._boundSubject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundSubjectInput() {
        return this._boundSubject;
    }
    get claimMappings() {
        return this.getStringMapAttribute('claim_mappings');
    }
    set claimMappings(value) {
        this._claimMappings = value;
    }
    resetClaimMappings() {
        this._claimMappings = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get claimMappingsInput() {
        return this._claimMappings;
    }
    get clockSkewLeeway() {
        return this.getNumberAttribute('clock_skew_leeway');
    }
    set clockSkewLeeway(value) {
        this._clockSkewLeeway = value;
    }
    resetClockSkewLeeway() {
        this._clockSkewLeeway = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clockSkewLeewayInput() {
        return this._clockSkewLeeway;
    }
    get disableBoundClaimsParsing() {
        return this.getBooleanAttribute('disable_bound_claims_parsing');
    }
    set disableBoundClaimsParsing(value) {
        this._disableBoundClaimsParsing = value;
    }
    resetDisableBoundClaimsParsing() {
        this._disableBoundClaimsParsing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableBoundClaimsParsingInput() {
        return this._disableBoundClaimsParsing;
    }
    get expirationLeeway() {
        return this.getNumberAttribute('expiration_leeway');
    }
    set expirationLeeway(value) {
        this._expirationLeeway = value;
    }
    resetExpirationLeeway() {
        this._expirationLeeway = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expirationLeewayInput() {
        return this._expirationLeeway;
    }
    get groupsClaim() {
        return this.getStringAttribute('groups_claim');
    }
    set groupsClaim(value) {
        this._groupsClaim = value;
    }
    resetGroupsClaim() {
        this._groupsClaim = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupsClaimInput() {
        return this._groupsClaim;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get maxAge() {
        return this.getNumberAttribute('max_age');
    }
    set maxAge(value) {
        this._maxAge = value;
    }
    resetMaxAge() {
        this._maxAge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxAgeInput() {
        return this._maxAge;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get notBeforeLeeway() {
        return this.getNumberAttribute('not_before_leeway');
    }
    set notBeforeLeeway(value) {
        this._notBeforeLeeway = value;
    }
    resetNotBeforeLeeway() {
        this._notBeforeLeeway = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notBeforeLeewayInput() {
        return this._notBeforeLeeway;
    }
    get oidcScopes() {
        return cdktf.Fn.tolist(this.getListAttribute('oidc_scopes'));
    }
    set oidcScopes(value) {
        this._oidcScopes = value;
    }
    resetOidcScopes() {
        this._oidcScopes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcScopesInput() {
        return this._oidcScopes;
    }
    get roleName() {
        return this.getStringAttribute('role_name');
    }
    set roleName(value) {
        this._roleName = value;
    }
    // Temporarily expose input value. Use with caution.
    get roleNameInput() {
        return this._roleName;
    }
    get roleType() {
        return this.getStringAttribute('role_type');
    }
    set roleType(value) {
        this._roleType = value;
    }
    resetRoleType() {
        this._roleType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleTypeInput() {
        return this._roleType;
    }
    get tokenBoundCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('token_bound_cidrs'));
    }
    set tokenBoundCidrs(value) {
        this._tokenBoundCidrs = value;
    }
    resetTokenBoundCidrs() {
        this._tokenBoundCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenBoundCidrsInput() {
        return this._tokenBoundCidrs;
    }
    get tokenExplicitMaxTtl() {
        return this.getNumberAttribute('token_explicit_max_ttl');
    }
    set tokenExplicitMaxTtl(value) {
        this._tokenExplicitMaxTtl = value;
    }
    resetTokenExplicitMaxTtl() {
        this._tokenExplicitMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenExplicitMaxTtlInput() {
        return this._tokenExplicitMaxTtl;
    }
    get tokenMaxTtl() {
        return this.getNumberAttribute('token_max_ttl');
    }
    set tokenMaxTtl(value) {
        this._tokenMaxTtl = value;
    }
    resetTokenMaxTtl() {
        this._tokenMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenMaxTtlInput() {
        return this._tokenMaxTtl;
    }
    get tokenNoDefaultPolicy() {
        return this.getBooleanAttribute('token_no_default_policy');
    }
    set tokenNoDefaultPolicy(value) {
        this._tokenNoDefaultPolicy = value;
    }
    resetTokenNoDefaultPolicy() {
        this._tokenNoDefaultPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNoDefaultPolicyInput() {
        return this._tokenNoDefaultPolicy;
    }
    get tokenNumUses() {
        return this.getNumberAttribute('token_num_uses');
    }
    set tokenNumUses(value) {
        this._tokenNumUses = value;
    }
    resetTokenNumUses() {
        this._tokenNumUses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNumUsesInput() {
        return this._tokenNumUses;
    }
    get tokenPeriod() {
        return this.getNumberAttribute('token_period');
    }
    set tokenPeriod(value) {
        this._tokenPeriod = value;
    }
    resetTokenPeriod() {
        this._tokenPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPeriodInput() {
        return this._tokenPeriod;
    }
    get tokenPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('token_policies'));
    }
    set tokenPolicies(value) {
        this._tokenPolicies = value;
    }
    resetTokenPolicies() {
        this._tokenPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPoliciesInput() {
        return this._tokenPolicies;
    }
    get tokenTtl() {
        return this.getNumberAttribute('token_ttl');
    }
    set tokenTtl(value) {
        this._tokenTtl = value;
    }
    resetTokenTtl() {
        this._tokenTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTtlInput() {
        return this._tokenTtl;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    get userClaim() {
        return this.getStringAttribute('user_claim');
    }
    set userClaim(value) {
        this._userClaim = value;
    }
    // Temporarily expose input value. Use with caution.
    get userClaimInput() {
        return this._userClaim;
    }
    get userClaimJsonPointer() {
        return this.getBooleanAttribute('user_claim_json_pointer');
    }
    set userClaimJsonPointer(value) {
        this._userClaimJsonPointer = value;
    }
    resetUserClaimJsonPointer() {
        this._userClaimJsonPointer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userClaimJsonPointerInput() {
        return this._userClaimJsonPointer;
    }
    get verboseOidcLogging() {
        return this.getBooleanAttribute('verbose_oidc_logging');
    }
    set verboseOidcLogging(value) {
        this._verboseOidcLogging = value;
    }
    resetVerboseOidcLogging() {
        this._verboseOidcLogging = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get verboseOidcLoggingInput() {
        return this._verboseOidcLogging;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allowed_redirect_uris: cdktf.listMapper(cdktf.stringToTerraform, false)(this._allowedRedirectUris),
            backend: cdktf.stringToTerraform(this._backend),
            bound_audiences: cdktf.listMapper(cdktf.stringToTerraform, false)(this._boundAudiences),
            bound_claims: cdktf.hashMapper(cdktf.stringToTerraform)(this._boundClaims),
            bound_claims_type: cdktf.stringToTerraform(this._boundClaimsType),
            bound_subject: cdktf.stringToTerraform(this._boundSubject),
            claim_mappings: cdktf.hashMapper(cdktf.stringToTerraform)(this._claimMappings),
            clock_skew_leeway: cdktf.numberToTerraform(this._clockSkewLeeway),
            disable_bound_claims_parsing: cdktf.booleanToTerraform(this._disableBoundClaimsParsing),
            expiration_leeway: cdktf.numberToTerraform(this._expirationLeeway),
            groups_claim: cdktf.stringToTerraform(this._groupsClaim),
            id: cdktf.stringToTerraform(this._id),
            max_age: cdktf.numberToTerraform(this._maxAge),
            namespace: cdktf.stringToTerraform(this._namespace),
            not_before_leeway: cdktf.numberToTerraform(this._notBeforeLeeway),
            oidc_scopes: cdktf.listMapper(cdktf.stringToTerraform, false)(this._oidcScopes),
            role_name: cdktf.stringToTerraform(this._roleName),
            role_type: cdktf.stringToTerraform(this._roleType),
            token_bound_cidrs: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenBoundCidrs),
            token_explicit_max_ttl: cdktf.numberToTerraform(this._tokenExplicitMaxTtl),
            token_max_ttl: cdktf.numberToTerraform(this._tokenMaxTtl),
            token_no_default_policy: cdktf.booleanToTerraform(this._tokenNoDefaultPolicy),
            token_num_uses: cdktf.numberToTerraform(this._tokenNumUses),
            token_period: cdktf.numberToTerraform(this._tokenPeriod),
            token_policies: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenPolicies),
            token_ttl: cdktf.numberToTerraform(this._tokenTtl),
            token_type: cdktf.stringToTerraform(this._tokenType),
            user_claim: cdktf.stringToTerraform(this._userClaim),
            user_claim_json_pointer: cdktf.booleanToTerraform(this._userClaimJsonPointer),
            verbose_oidc_logging: cdktf.booleanToTerraform(this._verboseOidcLogging),
        };
    }
}
exports.JwtAuthBackendRole = JwtAuthBackendRole;
_a = JSII_RTTI_SYMBOL_1;
JwtAuthBackendRole[_a] = { fqn: "@cdktf/provider-vault.jwtAuthBackendRole.JwtAuthBackendRole", version: "3.0.13" };
// =================
// STATIC PROPERTIES
// =================
JwtAuthBackendRole.tfResourceType = "vault_jwt_auth_backend_role";
//# sourceMappingURL=data:application/json;base64,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