import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedKeysConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#id ManagedKeys#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#namespace ManagedKeys#namespace}
    */
    readonly namespace?: string;
    /**
    * aws block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#aws ManagedKeys#aws}
    */
    readonly aws?: ManagedKeysAws[] | cdktf.IResolvable;
    /**
    * azure block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#azure ManagedKeys#azure}
    */
    readonly azure?: ManagedKeysAzure[] | cdktf.IResolvable;
    /**
    * pkcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#pkcs ManagedKeys#pkcs}
    */
    readonly pkcs?: ManagedKeysPkcs[] | cdktf.IResolvable;
}
export interface ManagedKeysAws {
    /**
    * The AWS access key to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#access_key ManagedKeys#access_key}
    */
    readonly accessKey: string;
    /**
    * If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#allow_generate_key ManagedKeys#allow_generate_key}
    */
    readonly allowGenerateKey?: boolean | cdktf.IResolvable;
    /**
    * Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#allow_replace_key ManagedKeys#allow_replace_key}
    */
    readonly allowReplaceKey?: boolean | cdktf.IResolvable;
    /**
    * Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#allow_store_key ManagedKeys#allow_store_key}
    */
    readonly allowStoreKey?: boolean | cdktf.IResolvable;
    /**
    * Allow usage from any mount point within the namespace if 'true'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#any_mount ManagedKeys#any_mount}
    */
    readonly anyMount?: boolean | cdktf.IResolvable;
    /**
    * The curve to use for an ECDSA key. Used when key_type is 'ECDSA'. Required if 'allow_generate_key' is true
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#curve ManagedKeys#curve}
    */
    readonly curve?: string;
    /**
    * Used to specify a custom AWS endpoint
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#endpoint ManagedKeys#endpoint}
    */
    readonly endpoint?: string;
    /**
    * The size in bits for an RSA key. This field is required when 'key_type' is 'RSA'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#key_bits ManagedKeys#key_bits}
    */
    readonly keyBits: string;
    /**
    * The type of key to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#key_type ManagedKeys#key_type}
    */
    readonly keyType: string;
    /**
    * An identifier for the key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#kms_key ManagedKeys#kms_key}
    */
    readonly kmsKey: string;
    /**
    * A unique lowercase name that serves as identifying the key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#name ManagedKeys#name}
    */
    readonly name: string;
    /**
    * The AWS region where the keys are stored (or will be stored)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#region ManagedKeys#region}
    */
    readonly region?: string;
    /**
    * The AWS secret key to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#secret_key ManagedKeys#secret_key}
    */
    readonly secretKey: string;
}
export declare function managedKeysAwsToTerraform(struct?: ManagedKeysAws | cdktf.IResolvable): any;
export declare class ManagedKeysAwsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedKeysAws | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedKeysAws | cdktf.IResolvable | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    private _allowGenerateKey?;
    get allowGenerateKey(): boolean | cdktf.IResolvable;
    set allowGenerateKey(value: boolean | cdktf.IResolvable);
    resetAllowGenerateKey(): void;
    get allowGenerateKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _allowReplaceKey?;
    get allowReplaceKey(): boolean | cdktf.IResolvable;
    set allowReplaceKey(value: boolean | cdktf.IResolvable);
    resetAllowReplaceKey(): void;
    get allowReplaceKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _allowStoreKey?;
    get allowStoreKey(): boolean | cdktf.IResolvable;
    set allowStoreKey(value: boolean | cdktf.IResolvable);
    resetAllowStoreKey(): void;
    get allowStoreKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _anyMount?;
    get anyMount(): boolean | cdktf.IResolvable;
    set anyMount(value: boolean | cdktf.IResolvable);
    resetAnyMount(): void;
    get anyMountInput(): boolean | cdktf.IResolvable | undefined;
    private _curve?;
    get curve(): string;
    set curve(value: string);
    resetCurve(): void;
    get curveInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _keyBits?;
    get keyBits(): string;
    set keyBits(value: string);
    get keyBitsInput(): string | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    get keyTypeInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    get kmsKeyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    get secretKeyInput(): string | undefined;
    get uuid(): string;
}
export declare class ManagedKeysAwsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedKeysAws[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedKeysAwsOutputReference;
}
export interface ManagedKeysAzure {
    /**
    * If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#allow_generate_key ManagedKeys#allow_generate_key}
    */
    readonly allowGenerateKey?: boolean | cdktf.IResolvable;
    /**
    * Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#allow_replace_key ManagedKeys#allow_replace_key}
    */
    readonly allowReplaceKey?: boolean | cdktf.IResolvable;
    /**
    * Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#allow_store_key ManagedKeys#allow_store_key}
    */
    readonly allowStoreKey?: boolean | cdktf.IResolvable;
    /**
    * Allow usage from any mount point within the namespace if 'true'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#any_mount ManagedKeys#any_mount}
    */
    readonly anyMount?: boolean | cdktf.IResolvable;
    /**
    * The client id for credentials to query the Azure APIs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#client_id ManagedKeys#client_id}
    */
    readonly clientId: string;
    /**
    * The client secret for credentials to query the Azure APIs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#client_secret ManagedKeys#client_secret}
    */
    readonly clientSecret: string;
    /**
    * The Azure Cloud environment API endpoints to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#environment ManagedKeys#environment}
    */
    readonly environment?: string;
    /**
    * The size in bits for an RSA key. This field is required when 'key_type' is 'RSA' or when 'allow_generate_key' is true
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#key_bits ManagedKeys#key_bits}
    */
    readonly keyBits?: string;
    /**
    * The Key Vault key to use for encryption and decryption
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#key_name ManagedKeys#key_name}
    */
    readonly keyName: string;
    /**
    * The type of key to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#key_type ManagedKeys#key_type}
    */
    readonly keyType: string;
    /**
    * A unique lowercase name that serves as identifying the key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#name ManagedKeys#name}
    */
    readonly name: string;
    /**
    * The Azure Key Vault resource's DNS Suffix to connect to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#resource ManagedKeys#resource}
    */
    readonly resource?: string;
    /**
    * The tenant id for the Azure Active Directory organization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#tenant_id ManagedKeys#tenant_id}
    */
    readonly tenantId: string;
    /**
    * The Key Vault vault to use the encryption keys for encryption and decryption
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#vault_name ManagedKeys#vault_name}
    */
    readonly vaultName: string;
}
export declare function managedKeysAzureToTerraform(struct?: ManagedKeysAzure | cdktf.IResolvable): any;
export declare class ManagedKeysAzureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedKeysAzure | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedKeysAzure | cdktf.IResolvable | undefined);
    private _allowGenerateKey?;
    get allowGenerateKey(): boolean | cdktf.IResolvable;
    set allowGenerateKey(value: boolean | cdktf.IResolvable);
    resetAllowGenerateKey(): void;
    get allowGenerateKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _allowReplaceKey?;
    get allowReplaceKey(): boolean | cdktf.IResolvable;
    set allowReplaceKey(value: boolean | cdktf.IResolvable);
    resetAllowReplaceKey(): void;
    get allowReplaceKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _allowStoreKey?;
    get allowStoreKey(): boolean | cdktf.IResolvable;
    set allowStoreKey(value: boolean | cdktf.IResolvable);
    resetAllowStoreKey(): void;
    get allowStoreKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _anyMount?;
    get anyMount(): boolean | cdktf.IResolvable;
    set anyMount(value: boolean | cdktf.IResolvable);
    resetAnyMount(): void;
    get anyMountInput(): boolean | cdktf.IResolvable | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    resetEnvironment(): void;
    get environmentInput(): string | undefined;
    private _keyBits?;
    get keyBits(): string;
    set keyBits(value: string);
    resetKeyBits(): void;
    get keyBitsInput(): string | undefined;
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    get keyNameInput(): string | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    get keyTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
    get uuid(): string;
    private _vaultName?;
    get vaultName(): string;
    set vaultName(value: string);
    get vaultNameInput(): string | undefined;
}
export declare class ManagedKeysAzureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedKeysAzure[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedKeysAzureOutputReference;
}
export interface ManagedKeysPkcs {
    /**
    * If no existing key can be found in the referenced backend, instructs Vault to generate a key within the backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#allow_generate_key ManagedKeys#allow_generate_key}
    */
    readonly allowGenerateKey?: boolean | cdktf.IResolvable;
    /**
    * Controls the ability for Vault to replace through generation or importing a key into the configured backend even if a key is present, if set to false those operations are forbidden if a key exists.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#allow_replace_key ManagedKeys#allow_replace_key}
    */
    readonly allowReplaceKey?: boolean | cdktf.IResolvable;
    /**
    * Controls the ability for Vault to import a key to the configured backend, if 'false', those operations will be forbidden
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#allow_store_key ManagedKeys#allow_store_key}
    */
    readonly allowStoreKey?: boolean | cdktf.IResolvable;
    /**
    * Allow usage from any mount point within the namespace if 'true'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#any_mount ManagedKeys#any_mount}
    */
    readonly anyMount?: boolean | cdktf.IResolvable;
    /**
    * Supplies the curve value when using the 'CKM_ECDSA' mechanism. Required if 'allow_generate_key' is true
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#curve ManagedKeys#curve}
    */
    readonly curve?: string;
    /**
    * Force all operations to open up a read-write session to the HSM
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#force_rw_session ManagedKeys#force_rw_session}
    */
    readonly forceRwSession?: string;
    /**
    * Supplies the size in bits of the key when using 'CKM_RSA_PKCS_PSS', 'CKM_RSA_PKCS_OAEP' or 'CKM_RSA_PKCS' as a value for 'mechanism'. Required if 'allow_generate_key' is true
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#key_bits ManagedKeys#key_bits}
    */
    readonly keyBits?: string;
    /**
    * The id of a PKCS#11 key to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#key_id ManagedKeys#key_id}
    */
    readonly keyId: string;
    /**
    * The label of the key to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#key_label ManagedKeys#key_label}
    */
    readonly keyLabel: string;
    /**
    * The name of the kms_library stanza to use from Vault's config to lookup the local library path
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#library ManagedKeys#library}
    */
    readonly library: string;
    /**
    * The encryption/decryption mechanism to use, specified as a hexadecimal (prefixed by 0x) string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#mechanism ManagedKeys#mechanism}
    */
    readonly mechanism: string;
    /**
    * A unique lowercase name that serves as identifying the key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#name ManagedKeys#name}
    */
    readonly name: string;
    /**
    * The PIN for login
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#pin ManagedKeys#pin}
    */
    readonly pin: string;
    /**
    * The slot number to use, specified as a string in a decimal format (e.g. '2305843009213693953')
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#slot ManagedKeys#slot}
    */
    readonly slot?: string;
    /**
    * The slot token label to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/managed_keys#token_label ManagedKeys#token_label}
    */
    readonly tokenLabel?: string;
}
export declare function managedKeysPkcsToTerraform(struct?: ManagedKeysPkcs | cdktf.IResolvable): any;
export declare class ManagedKeysPkcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedKeysPkcs | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedKeysPkcs | cdktf.IResolvable | undefined);
    private _allowGenerateKey?;
    get allowGenerateKey(): boolean | cdktf.IResolvable;
    set allowGenerateKey(value: boolean | cdktf.IResolvable);
    resetAllowGenerateKey(): void;
    get allowGenerateKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _allowReplaceKey?;
    get allowReplaceKey(): boolean | cdktf.IResolvable;
    set allowReplaceKey(value: boolean | cdktf.IResolvable);
    resetAllowReplaceKey(): void;
    get allowReplaceKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _allowStoreKey?;
    get allowStoreKey(): boolean | cdktf.IResolvable;
    set allowStoreKey(value: boolean | cdktf.IResolvable);
    resetAllowStoreKey(): void;
    get allowStoreKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _anyMount?;
    get anyMount(): boolean | cdktf.IResolvable;
    set anyMount(value: boolean | cdktf.IResolvable);
    resetAnyMount(): void;
    get anyMountInput(): boolean | cdktf.IResolvable | undefined;
    private _curve?;
    get curve(): string;
    set curve(value: string);
    resetCurve(): void;
    get curveInput(): string | undefined;
    private _forceRwSession?;
    get forceRwSession(): string;
    set forceRwSession(value: string);
    resetForceRwSession(): void;
    get forceRwSessionInput(): string | undefined;
    private _keyBits?;
    get keyBits(): string;
    set keyBits(value: string);
    resetKeyBits(): void;
    get keyBitsInput(): string | undefined;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
    private _keyLabel?;
    get keyLabel(): string;
    set keyLabel(value: string);
    get keyLabelInput(): string | undefined;
    private _library?;
    get library(): string;
    set library(value: string);
    get libraryInput(): string | undefined;
    private _mechanism?;
    get mechanism(): string;
    set mechanism(value: string);
    get mechanismInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pin?;
    get pin(): string;
    set pin(value: string);
    get pinInput(): string | undefined;
    private _slot?;
    get slot(): string;
    set slot(value: string);
    resetSlot(): void;
    get slotInput(): string | undefined;
    private _tokenLabel?;
    get tokenLabel(): string;
    set tokenLabel(value: string);
    resetTokenLabel(): void;
    get tokenLabelInput(): string | undefined;
    get uuid(): string;
}
export declare class ManagedKeysPkcsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedKeysPkcs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedKeysPkcsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/managed_keys vault_managed_keys}
*/
export declare class ManagedKeys extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_managed_keys";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/managed_keys vault_managed_keys} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedKeysConfig = {}
    */
    constructor(scope: Construct, id: string, config?: ManagedKeysConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _aws;
    get aws(): ManagedKeysAwsList;
    putAws(value: ManagedKeysAws[] | cdktf.IResolvable): void;
    resetAws(): void;
    get awsInput(): cdktf.IResolvable | ManagedKeysAws[] | undefined;
    private _azure;
    get azure(): ManagedKeysAzureList;
    putAzure(value: ManagedKeysAzure[] | cdktf.IResolvable): void;
    resetAzure(): void;
    get azureInput(): cdktf.IResolvable | ManagedKeysAzure[] | undefined;
    private _pkcs;
    get pkcs(): ManagedKeysPkcsList;
    putPkcs(value: ManagedKeysPkcs[] | cdktf.IResolvable): void;
    resetPkcs(): void;
    get pkcsInput(): cdktf.IResolvable | ManagedKeysPkcs[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
