"""Initial migration

Revision ID: 1318a586f31d
Revises:
Create Date: 2021-08-01 13:45:43.059646+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
from sqlalchemy.engine.reflection import Inspector

revision = "1318a586f31d"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    conn = op.get_bind()
    inspector = Inspector.from_engine(conn)
    tables = inspector.get_table_names()
    # ### commands auto generated by Alembic - please adjust! ###
    if "Experiments" not in tables:
        op.create_table(
            "Experiments",
            sa.Column("id", sa.Integer(), nullable=False),
            sa.Column("label", sa.String(), nullable=True),
            sa.Column("script", sa.String(), nullable=True),
            sa.Column("start_time", sa.DATETIME(), nullable=False),
            sa.Column("end_time", sa.DATETIME(), nullable=True),
            sa.Column("user", sa.String(), nullable=True),
            sa.Column("story", sa.String(), nullable=True),
            sa.Column("success", sa.Boolean(), nullable=True),
            sa.PrimaryKeyConstraint("id"),
        )
    if "Resources" not in tables:
        op.create_table(
            "Resources",
            sa.Column("id", sa.Integer(), nullable=False),
            sa.Column("update_time", sa.DATETIME(), nullable=False),
            sa.Column("name", sa.String(), nullable=True),
            sa.Column("driver", sa.String(), nullable=True),
            sa.Column("module", sa.String(), nullable=True),
            sa.Column("class_name", sa.String(), nullable=True),
            sa.Column("version", sa.String(), nullable=True),
            sa.Column(
                "driver_type",
                sa.Enum("Packaged", "Local", name="drivertype"),
                nullable=True,
            ),
            sa.Column("args", sa.String(), nullable=True),
            sa.Column("kwargs", sa.String(), nullable=True),
            sa.Column("deleted", sa.Boolean(), nullable=True),
            sa.Column("number_of_experiment_args", sa.Integer(), nullable=True),
            sa.Column("keys_of_experiment_kwargs", sa.String(), nullable=True),
            sa.Column("cached_metadata", sa.String(), nullable=True),
            sa.PrimaryKeyConstraint("id"),
        )
    if "Debug" not in tables:
        op.create_table(
            "Debug",
            sa.Column("id", sa.Integer(), nullable=False),
            sa.Column("experiment_id", sa.Integer(), nullable=True),
            sa.Column("python_env", sa.String(), nullable=True),
            sa.Column("python_history", sa.String(), nullable=True),
            sa.Column("station_specs", sa.String(), nullable=True),
            sa.Column("extra", sa.String(), nullable=True),
            sa.ForeignKeyConstraint(
                ["experiment_id"], ["Experiments.id"], ondelete="CASCADE"
            ),
            sa.PrimaryKeyConstraint("id"),
        )
    if "ExperimentMetadata" not in tables:
        op.create_table(
            "ExperimentMetadata",
            sa.Column("id", sa.Integer(), nullable=False),
            sa.Column("experiment_id", sa.Integer(), nullable=True),
            sa.Column("stage", sa.Integer(), nullable=True),
            sa.Column("label", sa.String(), nullable=True),
            sa.Column("time", sa.DATETIME(), nullable=False),
            sa.Column("data", sa.BLOB(), nullable=True),
            sa.Column(
                "data_type",
                sa.Enum("Pickled", "String", "Npy", name="resultdatatype"),
                nullable=True,
            ),
            sa.ForeignKeyConstraint(
                ["experiment_id"], ["Experiments.id"], ondelete="CASCADE"
            ),
            sa.PrimaryKeyConstraint("id"),
        )
    if "Nodes" not in tables:
        op.create_table(
            "Nodes",
            sa.Column("experiment_id", sa.Integer(), nullable=False),
            sa.Column("id", sa.Integer(), nullable=False),
            sa.Column("label", sa.String(), nullable=True),
            sa.Column("start", sa.DATETIME(), nullable=False),
            sa.Column("is_key_node", sa.Boolean(), nullable=True),
            sa.ForeignKeyConstraint(
                ["experiment_id"], ["Experiments.id"], ondelete="CASCADE"
            ),
            sa.PrimaryKeyConstraint("experiment_id", "id"),
        )
    if "Plots" not in tables:
        op.create_table(
            "Plots",
            sa.Column("id", sa.Integer(), nullable=False),
            sa.Column("experiment_id", sa.Integer(), nullable=True),
            sa.Column("plot_data", sa.BLOB(), nullable=True),
            sa.Column(
                "data_type",
                sa.Enum("Pickled", "String", "Npy", name="resultdatatype"),
                nullable=True,
            ),
            sa.Column("generator_module", sa.String(), nullable=True),
            sa.Column("generator_class", sa.String(), nullable=True),
            sa.Column("time", sa.DATETIME(), nullable=True),
            sa.Column("label", sa.String(), nullable=True),
            sa.Column("story", sa.String(), nullable=True),
            sa.ForeignKeyConstraint(
                ["experiment_id"], ["Experiments.id"], ondelete="CASCADE"
            ),
            sa.PrimaryKeyConstraint("id"),
        )
    if "ResourcesSnapshots" not in tables:
        op.create_table(
            "ResourcesSnapshots",
            sa.Column("id", sa.Integer(), nullable=False),
            sa.Column("update_time", sa.DATETIME(), nullable=False),
            sa.Column("name", sa.String(), nullable=True),
            sa.Column("driver_id", sa.Integer(), nullable=True),
            sa.Column("state", sa.String(), nullable=True),
            sa.ForeignKeyConstraint(
                ["driver_id"], ["Resources.id"], ondelete="CASCADE"
            ),
            sa.PrimaryKeyConstraint("id"),
        )
    if "Results" not in tables:
        op.create_table(
            "Results",
            sa.Column("id", sa.Integer(), nullable=False),
            sa.Column("experiment_id", sa.Integer(), nullable=True),
            sa.Column("stage", sa.Integer(), nullable=True),
            sa.Column("story", sa.String(), nullable=True),
            sa.Column("label", sa.String(), nullable=True),
            sa.Column("time", sa.DATETIME(), nullable=False),
            sa.Column("data", sa.BLOB(), nullable=True),
            sa.Column(
                "data_type",
                sa.Enum("Pickled", "String", "Npy", name="resultdatatype"),
                nullable=True,
            ),
            sa.ForeignKeyConstraint(
                ["experiment_id"], ["Experiments.id"], ondelete="CASCADE"
            ),
            sa.PrimaryKeyConstraint("id"),
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("Results")
    op.drop_table("ResourcesSnapshots")
    op.drop_table("Plots")
    op.drop_table("Nodes")
    op.drop_table("ExperimentMetadata")
    op.drop_table("Debug")
    op.drop_table("Resources")
    op.drop_table("Experiments")
    # ### end Alembic commands ###
