import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudServersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers#datacenter_id DataIonoscloudServers#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers#id DataIonoscloudServers#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers#filter DataIonoscloudServers#filter}
    */
    readonly filter: DataIonoscloudServersFilter[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers#timeouts DataIonoscloudServers#timeouts}
    */
    readonly timeouts?: DataIonoscloudServersTimeouts;
}
export interface DataIonoscloudServersServersCdroms {
}
export declare function dataIonoscloudServersServersCdromsToTerraform(struct?: DataIonoscloudServersServersCdroms): any;
export declare class DataIonoscloudServersServersCdromsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServersServersCdroms | undefined;
    set internalValue(value: DataIonoscloudServersServersCdroms | undefined);
    get cloudInit(): string;
    get cpuHotPlug(): cdktf.IResolvable;
    get cpuHotUnplug(): cdktf.IResolvable;
    get description(): string;
    get discScsiHotPlug(): cdktf.IResolvable;
    get discScsiHotUnplug(): cdktf.IResolvable;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    get id(): string;
    get imageAliases(): string[];
    get imageType(): string;
    get licenceType(): string;
    get location(): string;
    get name(): string;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get public(): cdktf.IResolvable;
    get ramHotPlug(): cdktf.IResolvable;
    get ramHotUnplug(): cdktf.IResolvable;
    get size(): number;
}
export declare class DataIonoscloudServersServersCdromsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServersServersCdromsOutputReference;
}
export interface DataIonoscloudServersServersNicsFirewallRules {
}
export declare function dataIonoscloudServersServersNicsFirewallRulesToTerraform(struct?: DataIonoscloudServersServersNicsFirewallRules): any;
export declare class DataIonoscloudServersServersNicsFirewallRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServersServersNicsFirewallRules | undefined;
    set internalValue(value: DataIonoscloudServersServersNicsFirewallRules | undefined);
    get icmpCode(): number;
    get icmpType(): number;
    get id(): string;
    get name(): string;
    get portRangeEnd(): number;
    get portRangeStart(): number;
    get protocol(): string;
    get sourceIp(): string;
    get sourceMac(): string;
    get targetIp(): string;
    get type(): string;
}
export declare class DataIonoscloudServersServersNicsFirewallRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServersServersNicsFirewallRulesOutputReference;
}
export interface DataIonoscloudServersServersNics {
}
export declare function dataIonoscloudServersServersNicsToTerraform(struct?: DataIonoscloudServersServersNics): any;
export declare class DataIonoscloudServersServersNicsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServersServersNics | undefined;
    set internalValue(value: DataIonoscloudServersServersNics | undefined);
    get deviceNumber(): number;
    get dhcp(): cdktf.IResolvable;
    get firewallActive(): cdktf.IResolvable;
    private _firewallRules;
    get firewallRules(): DataIonoscloudServersServersNicsFirewallRulesList;
    get firewallType(): string;
    get id(): string;
    get ips(): string[];
    get lan(): number;
    get mac(): string;
    get name(): string;
    get pciSlot(): number;
}
export declare class DataIonoscloudServersServersNicsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServersServersNicsOutputReference;
}
export interface DataIonoscloudServersServersVolumes {
}
export declare function dataIonoscloudServersServersVolumesToTerraform(struct?: DataIonoscloudServersServersVolumes): any;
export declare class DataIonoscloudServersServersVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServersServersVolumes | undefined;
    set internalValue(value: DataIonoscloudServersServersVolumes | undefined);
    get availabilityZone(): string;
    get backupUnitId(): string;
    get bootServer(): string;
    get bus(): string;
    get cpuHotPlug(): cdktf.IResolvable;
    get deviceNumber(): number;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    get diskType(): string;
    get id(): string;
    get imageName(): string;
    get imagePassword(): string;
    get licenceType(): string;
    get name(): string;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get pciSlot(): number;
    get ramHotPlug(): cdktf.IResolvable;
    get size(): number;
    get sshKeys(): string[];
    get userData(): string;
}
export declare class DataIonoscloudServersServersVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServersServersVolumesOutputReference;
}
export interface DataIonoscloudServersServers {
}
export declare function dataIonoscloudServersServersToTerraform(struct?: DataIonoscloudServersServers): any;
export declare class DataIonoscloudServersServersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServersServers | undefined;
    set internalValue(value: DataIonoscloudServersServers | undefined);
    get availabilityZone(): string;
    get bootCdrom(): string;
    get bootImage(): string;
    get bootVolume(): string;
    private _cdroms;
    get cdroms(): DataIonoscloudServersServersCdromsList;
    get cores(): number;
    get cpuFamily(): string;
    get id(): string;
    get name(): string;
    private _nics;
    get nics(): DataIonoscloudServersServersNicsList;
    get ram(): number;
    get templateUuid(): string;
    get token(): string;
    get type(): string;
    get vmState(): string;
    private _volumes;
    get volumes(): DataIonoscloudServersServersVolumesList;
}
export declare class DataIonoscloudServersServersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServersServersOutputReference;
}
export interface DataIonoscloudServersFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers#name DataIonoscloudServers#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers#value DataIonoscloudServers#value}
    */
    readonly value: string;
}
export declare function dataIonoscloudServersFilterToTerraform(struct?: DataIonoscloudServersFilter | cdktf.IResolvable): any;
export declare class DataIonoscloudServersFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudServersFilter | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudServersFilter | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class DataIonoscloudServersFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataIonoscloudServersFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudServersFilterOutputReference;
}
export interface DataIonoscloudServersTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers#create DataIonoscloudServers#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers#default DataIonoscloudServers#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers#delete DataIonoscloudServers#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers#update DataIonoscloudServers#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudServersTimeoutsToTerraform(struct?: DataIonoscloudServersTimeoutsOutputReference | DataIonoscloudServersTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudServersTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudServersTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudServersTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers ionoscloud_servers}
*/
export declare class DataIonoscloudServers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_servers";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/servers ionoscloud_servers} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudServersConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudServersConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _servers;
    get servers(): DataIonoscloudServersServersList;
    private _filter;
    get filter(): DataIonoscloudServersFilterList;
    putFilter(value: DataIonoscloudServersFilter[] | cdktf.IResolvable): void;
    get filterInput(): cdktf.IResolvable | DataIonoscloudServersFilter[] | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudServersTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudServersTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudServersTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
