# drakaina

![Drakaina](content/drakaina.png "Drakaina"){width=200px height=205px}

[![image](https://img.shields.io/pypi/v/drakaina.svg)](https://pypi.python.org/pypi/drakaina)
[![image](https://img.shields.io/pypi/l/drakaina.svg)](https://pypi.python.org/pypi/drakaina)
[![image](https://img.shields.io/pypi/pyversions/drakaina.svg)](https://pypi.python.org/pypi/drakaina)
[![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/charliermarsh/ruff/main/assets/badge/v1.json)](https://github.com/charliermarsh/ruff)
[![Code style: black](https://img.shields.io/badge/code%20style-black-black.svg)](https://github.com/psf/black)
[![libera manifesto](https://img.shields.io/badge/libera-manifesto-lightgrey.svg)](https://liberamanifesto.com)

❗ WIP

Module for simple RPC service implementation


## Quickstart

Drakaina may be installed via `pip` and requires Python 3.7 or higher :

```shell
pip install drakaina
```

A minimal Drakaina example is:

```python
from drakaina import remote_procedure
from drakaina.wsgi import WSGIHandler


@remote_procedure
def my_method():
    return "Hello Bro! ✋️"


@remote_procedure(name="something.get")
def get_some_string():
    return "You called `something.get`."


@remote_procedure(provide_request=True)
def do_something_with_environ(request):
    return f"You called `do_something_with_environ`. Request: {request}."


@remote_procedure()
def tell_the_middleware_something():
    return "You called `tell_the_middleware_something`. It has a some extra conditions."


async def asynchronous_procedure():
    await asyncio.sleep(5)
    return "Ding-Dong 🔔!"


"""
>>> JsonRPCv2().handle({"jsonrpc": "2.0", "method": "my_method", "id": 1})
or define WSGI application
"""
app = WSGIHandler(route="/jrpc")
```

Drakaina may be ran with any WSGI-compliant server,
such as [Gunicorn](http://gunicorn.org).

```shell
gunicorn main:app
```


## Features

- WSGI protocol implementation
  - Implemented CORS middleware
  - Compatible with simple middlewares for others wsgi-frameworks,
    like as [Werkzeug](https://palletsprojects.com/p/werkzeug/),
    [Flask](https://palletsprojects.com/p/flask/)


# Documentation


## Installation

```shell
pip install drakaina
```


## Middlewares


### CORS


### JWT

Drakaina may be installed via `pip` and requires Python 3.7 or higher :

```shell
pip install drakaina[jwt]
```

A minimal Drakaina example is:

```python
from functools import partial
from drakaina import ENV_IS_AUTHENTICATED
from drakaina import ENV_USER_ID
from drakaina import remote_procedure
from drakaina import check_permissions
from drakaina import login_required
from drakaina import match_any
from drakaina.contrib.jwt.middleware import JWTAuthenticationMiddleware
from drakaina.wsgi import WSGIHandler


@login_required
@remote_procedure(provide_request=True)
def my_method(request):
    assert request[ENV_IS_AUTHENTICATED]
    return f"Hello Bro ✋! Your ID={request[ENV_USER_ID]}"


@check_permissions(
    scopes=["user_read", "app/user:admin", "username:johndoe"],
    comparator=match_any,
)
@remote_procedure
def my_method():
    return "Hello Bro! ✋️"




app = WSGIHandler(
    middlewares=[
        partial(
            JWTAuthenticationMiddleware,
            secret_phrase="_secret_",
            credentials_required=True,
        )
    ]
)
```


### Using with Django

Create file `rpc_views.py` in your django application.
Define function and wrap it `remote_procedure` decorator:

```python
from drakaina import remote_procedure

@remote_procedure
def my_method():
    return "Hello, Django Bro! ✋"
```

Add `RPCView` class to urlpatterns. The `as_view` method
must accept the `autodiscover` argument as the name of
the remote procedure files.

```python
from django.urls import path
from drakaina.contrib.django.views import RPCView

urlpatterns = [
    ...,
    path("api/", RPCView.as_view(autodiscover="rpc_views")),
]
```


### JWT Authentication in your Django project

Wrap an instance of `RPCView` with the `JWTAuthenticationMiddleware`.

```python
from django.urls import path
from drakaina.contrib.django import RPCView, JWTAuthenticationMiddleware

urlpatterns = [
    ...,
    path("api/", JWTAuthenticationMiddleware(
        RPCView.as_view(autodiscover="rpc_views")
    )),
]
```

Define the parameters in the `settings.py` file.

```python
...

DRAKAINA_JWT_SECRET_KEY = SECRET_KEY

...
```


## License

Apache License 2.0

## Artwork

"[drakaina.png](content/drakaina.png)" by Korolko Anastasia is licensed under
<a rel="license" href="http://creativecommons.org/licenses/by-sa/4.0/"><img alt="License Creative Commons" style="border-width:0" src="https://i.creativecommons.org/l/by-sa/4.0/80x15.png" /></a> ([CC BY-SA 4.0](http://creativecommons.org/licenses/by-sa/4.0/)).
