"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A subscription filter for an attribute.
 *
 * @stability stable
 */
class SubscriptionFilter {
    /**
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     * @stability stable
     */
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * Returns a subscription filter for a string attribute.
     *
     * @stability stable
     */
    static stringFilter(stringConditions) {
        var _b, _c;
        const conditions = new Array();
        if (stringConditions.whitelist && stringConditions.allowlist) {
            throw new Error('`whitelist` is deprecated; please use `allowlist` instead');
        }
        if (stringConditions.blacklist && stringConditions.denylist) {
            throw new Error('`blacklist` is deprecated; please use `denylist` instead');
        }
        const allowlist = (_b = stringConditions.allowlist) !== null && _b !== void 0 ? _b : stringConditions.whitelist;
        const denylist = (_c = stringConditions.denylist) !== null && _c !== void 0 ? _c : stringConditions.blacklist;
        if (allowlist) {
            conditions.push(...allowlist);
        }
        if (denylist) {
            conditions.push({ 'anything-but': denylist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for a numeric attribute.
     *
     * @stability stable
     */
    static numericFilter(numericConditions) {
        var _b;
        const conditions = new Array();
        if (numericConditions.whitelist && numericConditions.allowlist) {
            throw new Error('`whitelist` is deprecated; please use `allowlist` instead');
        }
        const allowlist = (_b = numericConditions.allowlist) !== null && _b !== void 0 ? _b : numericConditions.whitelist;
        if (allowlist) {
            conditions.push(...allowlist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for attribute key matching.
     *
     * @stability stable
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
_a = JSII_RTTI_SYMBOL_1;
SubscriptionFilter[_a] = { fqn: "@aws-cdk/aws-sns.SubscriptionFilter", version: "1.121.0" };
//# sourceMappingURL=data:application/json;base64,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