/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.owlapiv3.OWL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class EntailmentChecker
extends OWLAxiomVisitorAdapter
implements OWLAxiomVisitor {
    public static Logger log = Logger.getLogger(EntailmentChecker.class.getName());
    private IncrementalClassifier reasoner;
    private Boolean isEntailed;

    public EntailmentChecker(IncrementalClassifier incrementalClassifier) {
        this.reasoner = incrementalClassifier;
    }

    public boolean isEntailed(Set<? extends OWLAxiom> set) {
        for (OWLAxiom oWLAxiom : set) {
            if (this.isEntailed(oWLAxiom)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailed(OWLAxiom oWLAxiom) {
        this.isEntailed = null;
        oWLAxiom.accept((OWLAxiomVisitor)this);
        if (this.isEntailed == null) {
            throw new UnsupportedEntailmentTypeException(oWLAxiom);
        }
        return this.isEntailed;
    }

    public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        OWLClassExpression oWLClassExpression = oWLSubClassOfAxiom.getSubClass();
        OWLClassExpression oWLClassExpression2 = oWLSubClassOfAxiom.getSuperClass();
        this.isEntailed = !this.reasoner.isClassified() || oWLClassExpression.isAnonymous() || oWLClassExpression2.isAnonymous() ? Boolean.valueOf(this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLSubClassOfAxiom)) : Boolean.valueOf(this.reasoner.getTaxonomy().isSubNodeOf((OWLClass)oWLClassExpression, (OWLClass)oWLClassExpression2).isTrue());
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        this.isEntailed = true;
        Iterator iterator = oWLEquivalentClassesAxiom.getClassExpressions().iterator();
        if (iterator.hasNext()) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)iterator.next();
            while (iterator.hasNext() && this.isEntailed.booleanValue()) {
                OWLClassExpression oWLClassExpression2 = (OWLClassExpression)iterator.next();
                if (!this.reasoner.isClassified() || oWLClassExpression.isAnonymous() || oWLClassExpression2.isAnonymous()) {
                    this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)OWL.equivalentClasses(oWLClassExpression, oWLClassExpression2));
                    continue;
                }
                this.isEntailed = this.reasoner.getTaxonomy().isEquivalent((OWLClass)oWLClassExpression, (OWLClass)oWLClassExpression2).isTrue();
            }
        }
    }

    public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        if (this.reasoner.isRealized()) {
            boolean bl = true;
            Taxonomy<OWLClass> taxonomy = this.reasoner.getTaxonomy();
            Iterator iterator = oWLSameIndividualAxiom.getIndividuals().iterator();
            if (iterator.hasNext()) {
                OWLIndividual oWLIndividual = (OWLIndividual)iterator.next();
                Set set = EntailmentChecker.flatten(TaxonomyUtils.getTypes(taxonomy, oWLIndividual, true));
                while (iterator.hasNext() && bl) {
                    OWLIndividual oWLIndividual2 = (OWLIndividual)iterator.next();
                    Set set2 = EntailmentChecker.flatten(TaxonomyUtils.getTypes(taxonomy, oWLIndividual2, true));
                    bl = set.equals(set2);
                }
                this.isEntailed = bl ? Boolean.valueOf(this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLSameIndividualAxiom)) : Boolean.valueOf(false);
            }
        } else {
            this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLSameIndividualAxiom);
        }
    }

    public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        if (this.reasoner.isClassified() && !this.containsAnonymousClasses(oWLDisjointClassesAxiom.getClassExpressions())) {
            OWLClass[] oWLClassArray = new OWLClass[oWLDisjointClassesAxiom.getClassExpressions().size()];
            Iterator iterator = oWLDisjointClassesAxiom.getClassExpressions().iterator();
            for (int i = 0; i < oWLClassArray.length; ++i) {
                oWLClassArray[i] = ((OWLClassExpression)iterator.next()).asOWLClass();
            }
            this.isEntailed = this.possiblyDisjoint(oWLClassArray) ? Boolean.valueOf(this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDisjointClassesAxiom)) : Boolean.valueOf(false);
        } else {
            this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDisjointClassesAxiom);
        }
    }

    private boolean possiblyDisjoint(OWLClass[] oWLClassArray) {
        for (int i = 0; i < oWLClassArray.length - 1; ++i) {
            for (int j = i + 1; j < oWLClassArray.length; ++j) {
                if (this.possiblyDisjoint(oWLClassArray[i], oWLClassArray[j])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean possiblyDisjoint(OWLClass oWLClass, OWLClass oWLClass2) {
        Taxonomy<OWLClass> taxonomy = this.reasoner.getTaxonomy();
        if (taxonomy.getAllEquivalents(oWLClass).contains(oWLClass2)) {
            return false;
        }
        if (taxonomy.getFlattenedSupers(oWLClass, false).contains(oWLClass2)) {
            return false;
        }
        return !taxonomy.getFlattenedSupers(oWLClass2, false).contains(oWLClass);
    }

    private boolean containsAnonymousClasses(Collection<OWLClassExpression> collection) {
        for (OWLClassExpression oWLClassExpression : collection) {
            if (!oWLClassExpression.isAnonymous()) continue;
            return true;
        }
        return false;
    }

    public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        this.isEntailed = this.reasoner.isRealized() && !oWLClassAssertionAxiom.getClassExpression().isAnonymous() ? Boolean.valueOf(EntailmentChecker.contains(TaxonomyUtils.getTypes(this.reasoner.getTaxonomy(), oWLClassAssertionAxiom.getIndividual(), false), oWLClassAssertionAxiom.getClassExpression().asOWLClass())) : Boolean.valueOf(this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLClassAssertionAxiom));
    }

    public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDeclarationAxiom);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLNegativeObjectPropertyAssertionAxiom);
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLAsymmetricObjectPropertyAxiom);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLReflexiveObjectPropertyAxiom);
    }

    public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDataPropertyDomainAxiom);
    }

    public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLObjectPropertyDomainAxiom);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLEquivalentObjectPropertiesAxiom);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLNegativeDataPropertyAssertionAxiom);
    }

    public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDifferentIndividualsAxiom);
    }

    public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDisjointDataPropertiesAxiom);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDisjointObjectPropertiesAxiom);
    }

    public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLObjectPropertyRangeAxiom);
    }

    public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLObjectPropertyAssertionAxiom);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLFunctionalObjectPropertyAxiom);
    }

    public void visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLSubObjectPropertyOfAxiom);
    }

    public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDisjointUnionAxiom);
    }

    public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLSymmetricObjectPropertyAxiom);
    }

    public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDataPropertyRangeAxiom);
    }

    public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLFunctionalDataPropertyAxiom);
    }

    public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLEquivalentDataPropertiesAxiom);
    }

    public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDataPropertyAssertionAxiom);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLTransitiveObjectPropertyAxiom);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLIrreflexiveObjectPropertyAxiom);
    }

    public void visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLSubDataPropertyOfAxiom);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLInverseFunctionalObjectPropertyAxiom);
    }

    public void visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLSubPropertyChainOfAxiom);
    }

    public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLInverseObjectPropertiesAxiom);
    }

    public void visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLHasKeyAxiom);
    }

    public void visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)oWLDatatypeDefinitionAxiom);
    }

    public void visit(SWRLRule sWRLRule) {
        this.isEntailed = this.reasoner.getReasoner().isEntailed((OWLAxiom)sWRLRule);
    }

    private static <T> boolean contains(Set<Set<T>> set, T t) {
        for (Set<T> set2 : set) {
            if (!set2.contains(t)) continue;
            return true;
        }
        return false;
    }

    private static <T> Set<T> flatten(Set<Set<T>> set) {
        HashSet<T> hashSet = new HashSet<T>();
        for (Set<T> set2 : set) {
            hashSet.addAll(set2);
        }
        return hashSet;
    }
}

