/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.floating;

import com.clarkparsia.pellet.datatypes.DiscreteInterval;
import com.clarkparsia.pellet.datatypes.types.floating.FloatingPointType;

public class FloatingPointInterval<T extends Number>
extends DiscreteInterval<T, FloatingPointInterval<T>> {
    private final FloatingPointType<T> type;

    public static <U extends Number> FloatingPointInterval<U> unconstrained(FloatingPointType<U> floatingPointType) {
        return new FloatingPointInterval<U>(floatingPointType, floatingPointType.getNegativeInfinity(), floatingPointType.getPositiveInfinity());
    }

    public FloatingPointInterval(FloatingPointType<T> floatingPointType, T t) {
        super(t);
        if (floatingPointType == null) {
            throw new NullPointerException();
        }
        if (floatingPointType.isNaN(t)) {
            throw new IllegalArgumentException();
        }
        this.type = floatingPointType;
        if (!this.valid(t)) {
            throw new IllegalArgumentException();
        }
    }

    public FloatingPointInterval(FloatingPointType<T> floatingPointType, T t, T t2) {
        super(t, t2);
        if (floatingPointType == null) {
            throw new NullPointerException();
        }
        if (floatingPointType.isNaN(t)) {
            throw new IllegalArgumentException();
        }
        if (floatingPointType.isNaN(t2)) {
            throw new IllegalArgumentException();
        }
        this.type = floatingPointType;
        if (!this.valid(t)) {
            throw new IllegalArgumentException();
        }
        if (!this.valid(t2)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected FloatingPointInterval<T> cast(DiscreteInterval<T, FloatingPointInterval<T>> discreteInterval) {
        if (discreteInterval instanceof FloatingPointInterval) {
            return (FloatingPointInterval)discreteInterval;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected int compare(T t, DiscreteInterval.NullSemantics nullSemantics, T t2, DiscreteInterval.NullSemantics nullSemantics2) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (t2 == null) {
            throw new NullPointerException();
        }
        return ((Comparable)t).compareTo(t2);
    }

    @Override
    public boolean contains(T t) {
        if (this.type.isNaN(t)) {
            return false;
        }
        return super.contains(t);
    }

    @Override
    protected FloatingPointInterval<T> create(T t, T t2) {
        return new FloatingPointInterval<T>(this.type, t, t2);
    }

    @Override
    protected T decrement(T t) {
        return this.type.decrement(t);
    }

    @Override
    protected boolean equal(T t, T t2) {
        return t.equals(t2);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FloatingPointInterval floatingPointInterval = (FloatingPointInterval)object;
        if (!this.getLower().equals(floatingPointInterval.getLower())) {
            return false;
        }
        return this.getUpper().equals(floatingPointInterval.getUpper());
    }

    @Override
    public FloatingPointInterval<T> greater(T t) {
        if (this.type.isNaN(t)) {
            throw new IllegalArgumentException();
        }
        return (FloatingPointInterval)super.greater(t);
    }

    @Override
    protected T increment(T t) {
        return this.type.increment(t);
    }

    @Override
    public FloatingPointInterval<T> less(T t) {
        if (this.type.isNaN(t)) {
            throw new IllegalArgumentException();
        }
        return (FloatingPointInterval)super.less(t);
    }

    @Override
    public Number size() {
        return this.type.intervalSize(this.getLower(), this.getUpper());
    }

    @Override
    protected boolean valid(T t) {
        return t != null && (this.type == null || this.type.isInstance(t));
    }
}

