/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.DiscreteInterval;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;

public class IntegerInterval
extends DiscreteInterval<Number, IntegerInterval> {
    private static final IntegerInterval unconstrained = new IntegerInterval(null, null);

    public static IntegerInterval allIntegers() {
        return unconstrained;
    }

    public IntegerInterval(Number number) {
        super(number);
    }

    public IntegerInterval(Number number, Number number2) {
        super(number, number2);
    }

    @Override
    protected IntegerInterval cast(DiscreteInterval<Number, IntegerInterval> discreteInterval) {
        if (IntegerInterval.class.isInstance(discreteInterval)) {
            return (IntegerInterval)IntegerInterval.class.cast(discreteInterval);
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected int compare(Number number, DiscreteInterval.NullSemantics nullSemantics, Number number2, DiscreteInterval.NullSemantics nullSemantics2) {
        if (number == null && NA.equals((Object)nullSemantics)) {
            throw new NullPointerException();
        }
        if (number2 == null && NA.equals((Object)nullSemantics2)) {
            throw new NullPointerException();
        }
        if (number == null) {
            if (number2 == null) {
                if (nullSemantics.equals((Object)nullSemantics2)) {
                    return 0;
                }
                if (LEAST.equals((Object)nullSemantics)) {
                    return -1;
                }
                return 1;
            }
            if (LEAST.equals((Object)nullSemantics)) {
                return -1;
            }
            return 1;
        }
        if (number2 == null) {
            if (GREATEST.equals((Object)nullSemantics2)) {
                return -1;
            }
            return 1;
        }
        return OWLRealUtils.compare(number, number2);
    }

    @Override
    protected IntegerInterval create(Number number, Number number2) {
        return new IntegerInterval(number, number2);
    }

    @Override
    protected Number decrement(Number number) {
        return OWLRealUtils.integerDecrement(number);
    }

    @Override
    protected boolean equal(Number number, Number number2) {
        if (number == null) {
            throw new NullPointerException();
        }
        if (number2 == null) {
            throw new NullPointerException();
        }
        return OWLRealUtils.compare(number, number2) == 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IntegerInterval integerInterval = (IntegerInterval)object;
        if (this.getLower() == null) {
            if (integerInterval.getLower() != null) {
                return false;
            }
        } else {
            if (integerInterval.getLower() == null) {
                return false;
            }
            if (OWLRealUtils.compare(this.getLower(), integerInterval.getLower()) != 0) {
                return false;
            }
        }
        if (this.getUpper() == null) {
            if (integerInterval.getUpper() != null) {
                return false;
            }
        } else {
            if (integerInterval.getUpper() == null) {
                return false;
            }
            if (OWLRealUtils.compare(this.getUpper(), integerInterval.getUpper()) != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected Number increment(Number number) {
        return OWLRealUtils.integerIncrement(number);
    }

    @Override
    public Number size() {
        if (this.getLower() == null || this.getUpper() == null) {
            throw new IllegalStateException();
        }
        return OWLRealUtils.integerIncrement(OWLRealUtils.integerDifference(this.getUpper(), this.getLower()));
    }

    @Override
    protected boolean valid(Number number) {
        if (number == null) {
            return true;
        }
        return OWLRealUtils.acceptable(number.getClass()) && OWLRealUtils.isInteger(number);
    }
}

