/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;
import org.mindswap.pellet.utils.progress.SwingProgressMonitor;

public class PelletOptions {
    public static final Logger log = Logger.getLogger(PelletOptions.class.getName());
    public static boolean SATURATE_TABLEAU = false;
    public static boolean USE_UNIQUE_NAME_ASSUMPTION = false;
    public static boolean TRACK_BRANCH_EFFECTS = false;
    public static boolean TREAT_ALL_VARS_DISTINGUISHED = true;
    public static boolean USE_DISJUNCT_SORTING = !SATURATE_TABLEAU;
    public static MonitorType USE_CLASSIFICATION_MONITOR = MonitorType.CONSOLE;
    public static final String NO_SORTING = "NO";
    public static final String OLDEST_FIRST = "OLDEST_FIRST";
    public static String USE_DISJUNCTION_SORTING = "OLDEST_FIRST";
    public static boolean USE_ABSORPTION = true;
    public static UndefinedDatatypeHandling UNDEFINED_DATATYPE_HANDLING = UndefinedDatatypeHandling.INFINITE_STRING;
    public static boolean USE_ROLE_ABSORPTION = true;
    public static boolean USE_NOMINAL_ABSORPTION = true;
    public static boolean USE_HASVALUE_ABSORPTION = true;
    public static boolean USE_RULE_ABSORPTION = false;
    public static boolean USE_BINARY_ABSORPTION = true;
    public static boolean USE_BACKJUMPING = !SATURATE_TABLEAU & true;
    public static boolean USE_FULL_DATATYPE_REASONING = true;
    public static boolean USE_CACHING = true;
    public static boolean USE_ADVANCED_CACHING = true;
    public static boolean USE_INVERSE_CACHING = true;
    public static boolean USE_ANYWHERE_BLOCKING = true;
    public static int MAX_ANONYMOUS_CACHE = 20000;
    public static boolean CHECK_NOMINAL_EDGES = true;
    public static boolean USE_PSEUDO_NOMINALS = false;
    public static boolean IGNORE_INVERSES = false;
    public static boolean USE_COMPLETION_STRATEGY = !SATURATE_TABLEAU & true;
    public static boolean USE_CONTINUOUS_RULES = true;
    public static boolean ALWAYS_REBUILD_RETE = false;
    public static boolean USE_SEMANTIC_BRANCHING = !SATURATE_TABLEAU & true;
    @Deprecated
    public static Class<? extends CompletionStrategy> DEFAULT_COMPLETION_STRATEGY = null;
    public static boolean COPY_ON_WRITE = true;
    public static boolean SILENT_UNDEFINED_ENTITY_HANDLING = true;
    public static boolean REALIZE_INDIVIDUAL_AT_A_TIME = false;
    public static boolean VALIDATE_ABOX = false;
    public static boolean PRINT_ABOX = false;
    public static final boolean DEPTH_FIRST = true;
    public static final boolean BREADTH_FIRST = false;
    public static boolean KEEP_ABOX_ASSERTIONS = false;
    public static boolean SEARCH_TYPE = true;
    public static InstanceRetrievalMethod INSTANCE_RETRIEVAL = InstanceRetrievalMethod.BINARY;
    public static boolean INVALID_LITERAL_AS_INCONSISTENCY = true;
    public static boolean OPTIMIZE_DOWN_MONOTONIC = false;
    public static boolean SIMPLIFY_QUERY = true;
    public static double SAMPLING_RATIO = 0.2;
    public static int STATIC_REORDERING_LIMIT = 8;
    public static boolean FULL_SIZE_ESTIMATE = false;
    public static boolean CACHE_RETRIEVAL = false;
    public static boolean USE_TRACING = false;
    public static String DEFAULT_CONFIGURATION_FILE = "pellet.properties";
    public static boolean FREEZE_BUILTIN_NAMESPACES = true;
    public static boolean IGNORE_DEPRECATED_TERMS = true;
    public static boolean IGNORE_UNSUPPORTED_AXIOMS = true;
    public static boolean DL_SAFE_RULES = true;
    public static boolean RETURN_DEDUCTIONS_GRAPH = false;
    public static boolean USE_COMPLETION_QUEUE = false;
    public static boolean USE_OPTIMIZED_BASIC_COMPLETION_QUEUE = false;
    public static boolean USE_SMART_RESTORE = true;
    public static boolean USE_INCREMENTAL_CONSISTENCY = false;
    public static boolean USE_INCREMENTAL_DELETION = false;
    public static boolean MAINTAIN_COMPLETION_QUEUE = false;
    public static boolean USE_CD_CLASSIFICATION = true;
    @Deprecated
    public static boolean USE_NAIVE_QUERY_ENGINE = false;
    public static boolean USE_ANNOTATION_SUPPORT = false;
    public static boolean HIDE_TOP_PROPERTY_VALUES = true;
    public static boolean USE_LEGACY_TBOX = true;
    public static OrderedClassification ORDERED_CLASSIFICATION = OrderedClassification.ENABLED;
    public static boolean DISABLE_EL_CLASSIFIER = false;
    public static boolean PROCESS_JENA_UPDATES_INCREMENTALLY = true;
    public static boolean IGNORE_ANNOTATION_CLASSES = true;

    public static Properties setOptions(Properties properties) {
        Properties properties2 = new Properties();
        ALWAYS_REBUILD_RETE = PelletOptions.getBooleanProperty(properties, "ALWAYS_REBUILD_RETE", ALWAYS_REBUILD_RETE, properties2);
        CACHE_RETRIEVAL = PelletOptions.getBooleanProperty(properties, "CACHE_RETRIEVAL", CACHE_RETRIEVAL, properties2);
        DL_SAFE_RULES = PelletOptions.getBooleanProperty(properties, "DL_SAFE_RULES", DL_SAFE_RULES, properties2);
        FREEZE_BUILTIN_NAMESPACES = PelletOptions.getBooleanProperty(properties, "FREEZE_BUILTIN_NAMESPACES", FREEZE_BUILTIN_NAMESPACES, properties2);
        FULL_SIZE_ESTIMATE = PelletOptions.getBooleanProperty(properties, "FULL_SIZE_ESTIMATE", FULL_SIZE_ESTIMATE, properties2);
        IGNORE_DEPRECATED_TERMS = PelletOptions.getBooleanProperty(properties, "IGNORE_DEPRECATED_TERMS", IGNORE_DEPRECATED_TERMS, properties2);
        IGNORE_INVERSES = PelletOptions.getBooleanProperty(properties, "IGNORE_INVERSES", IGNORE_INVERSES, properties2);
        IGNORE_UNSUPPORTED_AXIOMS = PelletOptions.getBooleanProperty(properties, "IGNORE_UNSUPPORTED_AXIOMS", IGNORE_UNSUPPORTED_AXIOMS, properties2);
        MAINTAIN_COMPLETION_QUEUE = PelletOptions.getBooleanProperty(properties, "MAINTAIN_COMPLETION_QUEUE", MAINTAIN_COMPLETION_QUEUE, properties2);
        MAX_ANONYMOUS_CACHE = PelletOptions.getIntProperty(properties, "MAX_ANONYMOUS_CACHE", MAX_ANONYMOUS_CACHE, properties2);
        OPTIMIZE_DOWN_MONOTONIC = PelletOptions.getBooleanProperty(properties, "OPTIMIZE_DOWN_MONOTONIC", OPTIMIZE_DOWN_MONOTONIC, properties2);
        REALIZE_INDIVIDUAL_AT_A_TIME = PelletOptions.getBooleanProperty(properties, "REALIZE_INDIVIDUAL_AT_A_TIME", REALIZE_INDIVIDUAL_AT_A_TIME, properties2);
        RETURN_DEDUCTIONS_GRAPH = PelletOptions.getBooleanProperty(properties, "RETURN_DEDUCTIONS_GRAPH", RETURN_DEDUCTIONS_GRAPH, properties2);
        SAMPLING_RATIO = PelletOptions.getDoubleProperty(properties, "SAMPLING_RATIO", SAMPLING_RATIO, properties2);
        SILENT_UNDEFINED_ENTITY_HANDLING = PelletOptions.getBooleanProperty(properties, "SILENT_UNDEFINED_ENTITY_HANDLING", SILENT_UNDEFINED_ENTITY_HANDLING, properties2);
        SIMPLIFY_QUERY = PelletOptions.getBooleanProperty(properties, "SIMPLIFY_QUERY", SIMPLIFY_QUERY, properties2);
        STATIC_REORDERING_LIMIT = PelletOptions.getIntProperty(properties, "STATIC_REORDERING_LIMIT", STATIC_REORDERING_LIMIT, properties2);
        TRACK_BRANCH_EFFECTS = PelletOptions.getBooleanProperty(properties, "TRACK_BRANCH_EFFECTS", TRACK_BRANCH_EFFECTS, properties2);
        TREAT_ALL_VARS_DISTINGUISHED = PelletOptions.getBooleanProperty(properties, "TREAT_ALL_VARS_DISTINGUISHED", TREAT_ALL_VARS_DISTINGUISHED, properties2);
        USE_ABSORPTION = PelletOptions.getBooleanProperty(properties, "USE_ABSORPTION", USE_ABSORPTION, properties2);
        USE_NOMINAL_ABSORPTION = PelletOptions.getBooleanProperty(properties, "USE_NOMINAL_ABSORPTION", USE_NOMINAL_ABSORPTION, properties2);
        USE_HASVALUE_ABSORPTION = PelletOptions.getBooleanProperty(properties, "USE_HASVALUE_ABSORPTION", USE_HASVALUE_ABSORPTION, properties2);
        USE_ROLE_ABSORPTION = PelletOptions.getBooleanProperty(properties, "USE_ROLE_ABSORPTION", USE_ROLE_ABSORPTION, properties2);
        USE_RULE_ABSORPTION = PelletOptions.getBooleanProperty(properties, "USE_RULE_ABSORPTION", USE_RULE_ABSORPTION, properties2);
        USE_ADVANCED_CACHING = PelletOptions.getBooleanProperty(properties, "USE_ADVANCED_CACHING", USE_ADVANCED_CACHING, properties2);
        USE_ANNOTATION_SUPPORT = PelletOptions.getBooleanProperty(properties, "USE_ANNOTATION_SUPPORT", USE_ANNOTATION_SUPPORT, properties2);
        USE_BACKJUMPING = PelletOptions.getBooleanProperty(properties, "USE_BACKJUMPING", USE_BACKJUMPING, properties2);
        USE_CACHING = PelletOptions.getBooleanProperty(properties, "USE_CACHING", USE_CACHING, properties2);
        USE_CD_CLASSIFICATION = PelletOptions.getBooleanProperty(properties, "USE_CD_CLASSIFICATION", USE_CD_CLASSIFICATION, properties2);
        USE_CLASSIFICATION_MONITOR = PelletOptions.getEnumProperty(properties, "USE_CLASSIFICATION_MONITOR", USE_CLASSIFICATION_MONITOR, properties2);
        USE_COMPLETION_QUEUE = PelletOptions.getBooleanProperty(properties, "USE_COMPLETION_QUEUE", USE_COMPLETION_QUEUE, properties2);
        USE_CONTINUOUS_RULES = PelletOptions.getBooleanProperty(properties, "USE_CONTINUOUS_RULES", USE_CONTINUOUS_RULES, properties2);
        USE_FULL_DATATYPE_REASONING = PelletOptions.getBooleanProperty(properties, "USE_FULL_DATATYPE_REASONING", USE_FULL_DATATYPE_REASONING, properties2);
        USE_INCREMENTAL_CONSISTENCY = PelletOptions.getBooleanProperty(properties, "USE_INCREMENTAL_CONSISTENCY", USE_INCREMENTAL_CONSISTENCY, properties2);
        USE_INCREMENTAL_DELETION = PelletOptions.getBooleanProperty(properties, "USE_INCREMENTAL_DELETION", USE_INCREMENTAL_DELETION, properties2);
        USE_NAIVE_QUERY_ENGINE = PelletOptions.getBooleanProperty(properties, "USE_NAIVE_QUERY_ENGINE", USE_NAIVE_QUERY_ENGINE, properties2);
        USE_PSEUDO_NOMINALS = PelletOptions.getBooleanProperty(properties, "USE_PSEUDO_NOMINALS", USE_PSEUDO_NOMINALS, properties2);
        USE_SEMANTIC_BRANCHING = PelletOptions.getBooleanProperty(properties, "USE_SEMANTIC_BRANCHING", USE_SEMANTIC_BRANCHING, properties2);
        USE_SMART_RESTORE = PelletOptions.getBooleanProperty(properties, "USE_SMART_RESTORE", USE_SMART_RESTORE, properties2);
        USE_TRACING = PelletOptions.getBooleanProperty(properties, "USE_TRACING", USE_TRACING, properties2);
        USE_UNIQUE_NAME_ASSUMPTION = PelletOptions.getBooleanProperty(properties, "USE_UNIQUE_NAME_ASSUMPTION", USE_UNIQUE_NAME_ASSUMPTION, properties2);
        HIDE_TOP_PROPERTY_VALUES = PelletOptions.getBooleanProperty(properties, "HIDE_TOP_PROPERTY_VALUES", HIDE_TOP_PROPERTY_VALUES, properties2);
        ORDERED_CLASSIFICATION = PelletOptions.getEnumProperty(properties, "ORDERED_CLASSIFICATION", ORDERED_CLASSIFICATION, properties2);
        DISABLE_EL_CLASSIFIER = PelletOptions.getBooleanProperty(properties, "DISABLE_EL_CLASSIFIER", DISABLE_EL_CLASSIFIER, properties2);
        PROCESS_JENA_UPDATES_INCREMENTALLY = PelletOptions.getBooleanProperty(properties, "PROCESS_JENA_UPDATES_INCREMENTALLY", PROCESS_JENA_UPDATES_INCREMENTALLY, properties2);
        IGNORE_ANNOTATION_CLASSES = PelletOptions.getBooleanProperty(properties, "IGNORE_ANNOTATION_CLASSES", IGNORE_ANNOTATION_CLASSES, properties2);
        return properties2;
    }

    public static void load(URL uRL) throws FileNotFoundException, IOException {
        log.fine("Reading Pellet configuration file " + uRL);
        Properties properties = new Properties();
        properties.load(uRL.openStream());
        PelletOptions.setOptions(properties);
    }

    private static boolean getBooleanProperty(Properties properties, String string, boolean bl, Properties properties2) {
        properties2.setProperty(string, String.valueOf(bl));
        String string2 = properties.getProperty(string);
        boolean bl2 = bl;
        if (string2 != null) {
            if ((string2 = string2.trim()).equalsIgnoreCase("true")) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase("false")) {
                bl2 = false;
            } else {
                log.severe("Ignoring invalid value (" + string2 + ") for the configuration option " + string);
            }
        }
        properties.setProperty(string, String.valueOf(bl2));
        return bl2;
    }

    private static double getDoubleProperty(Properties properties, String string, double d, Properties properties2) {
        properties2.setProperty(string, String.valueOf(d));
        String string2 = properties.getProperty(string);
        double d2 = d;
        if (string2 != null) {
            try {
                d2 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.severe("Ignoring invalid double value (" + string2 + ") for the configuration option " + string);
            }
        }
        properties.setProperty(string, String.valueOf(d2));
        return d2;
    }

    private static int getIntProperty(Properties properties, String string, int n, Properties properties2) {
        properties2.setProperty(string, String.valueOf(n));
        String string2 = properties.getProperty(string);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.severe("Ignoring invalid int value (" + string2 + ") for the configuration option " + string);
            }
        }
        properties.setProperty(string, String.valueOf(n2));
        return n2;
    }

    private static <T extends Enum<T>> T getEnumProperty(Properties properties, String string, T t, Properties properties2) {
        properties2.setProperty(string, String.valueOf(t));
        String string2 = properties.getProperty(string);
        T t2 = t;
        if (string2 != null) {
            string2 = string2.trim().toUpperCase();
            try {
                t2 = Enum.valueOf(t.getDeclaringClass(), string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.severe("Ignoring invalid value (" + string2 + ") for the configuration option " + string);
            }
        }
        properties.setProperty(string, String.valueOf(t2));
        return t2;
    }

    static {
        String string = System.getProperty("pellet.configuration");
        URL uRL = null;
        if (string == null) {
            uRL = PelletOptions.class.getClassLoader().getResource(DEFAULT_CONFIGURATION_FILE);
        } else {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                uRL = PelletOptions.class.getClassLoader().getResource(string);
            }
            if (uRL == null) {
                log.severe("Cannot file Pellet configuration file " + string);
            }
        }
        if (uRL != null) {
            try {
                PelletOptions.load(uRL);
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.severe("Pellet configuration file cannot be found");
            }
            catch (IOException iOException) {
                log.severe("I/O error while reading Pellet configuration file");
            }
        }
    }

    public static enum OrderedClassification {
        DISABLED,
        ENABLED,
        ENABLED_LEGACY_ORDERING;

    }

    public static enum UndefinedDatatypeHandling {
        EMPTY,
        EXCEPTION,
        INFINITE_STRING;

    }

    public static enum InstanceRetrievalMethod {
        BINARY,
        LINEAR,
        TRACING_BASED;

    }

    public static enum MonitorType implements EnumFactory<ProgressMonitor>
    {
        CONSOLE(ConsoleProgressMonitor.class),
        SWING(SwingProgressMonitor.class),
        NONE(SilentProgressMonitor.class);

        private final Class<? extends ProgressMonitor> c;

        private MonitorType(Class<? extends ProgressMonitor> clazz) {
            this.c = clazz;
        }

        @Override
        public ProgressMonitor create() {
            try {
                return this.c.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new InternalReasonerException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalReasonerException(illegalAccessException);
            }
        }
    }

    private static interface EnumFactory<T> {
        public T create();
    }
}

