/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.tbox.impl.UnaryTBox;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.BinarySet;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class BinaryTBox {
    public static final Logger log = Logger.getLogger(UnaryTBox.class.getName());
    private Map<BinarySet<ATermAppl>, Unfolding> unfoldings = CollectionUtils.makeMap();
    private Map<ATermAppl, List<Unfolding>> conditionalUnfoldings = CollectionUtils.makeIdentityMap();

    public void add(BinarySet<ATermAppl> binarySet, ATermAppl aTermAppl, Set<ATermAppl> set) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Add sub: (" + ATermUtils.toString(binarySet.first()) + ", " + ATermUtils.toString(binarySet.second()) + ") < " + ATermUtils.toString(aTermAppl));
        }
        aTermAppl = ATermUtils.normalize(aTermAppl);
        this.unfoldings.put(binarySet, Unfolding.create(aTermAppl, set));
        this.addUnfolding(binarySet.first(), binarySet.second(), aTermAppl, set);
        this.addUnfolding(binarySet.second(), binarySet.first(), aTermAppl, set);
    }

    private void addUnfolding(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3, Set<ATermAppl> set) {
        List<Unfolding> list = this.conditionalUnfoldings.get(aTermAppl);
        if (list == null) {
            list = CollectionUtils.makeList();
            this.conditionalUnfoldings.put(aTermAppl, list);
        }
        list.add(Unfolding.create(aTermAppl3, aTermAppl2, set));
    }

    public Unfolding unfold(BinarySet<ATermAppl> binarySet) {
        return this.unfoldings.get(binarySet);
    }

    public Iterator<Unfolding> unfold(ATermAppl aTermAppl) {
        List<Unfolding> list = this.conditionalUnfoldings.get(aTermAppl);
        return list == null ? IteratorUtils.emptyIterator() : list.iterator();
    }

    public boolean contains(ATermAppl aTermAppl) {
        return this.conditionalUnfoldings.containsKey(aTermAppl);
    }

    public void print(Appendable appendable) throws IOException {
        for (Map.Entry<BinarySet<ATermAppl>, Unfolding> entry : this.unfoldings.entrySet()) {
            BinarySet<ATermAppl> binarySet = entry.getKey();
            appendable.append("(");
            appendable.append(ATermUtils.toString(binarySet.first()));
            appendable.append(",");
            appendable.append(ATermUtils.toString(binarySet.second()));
            appendable.append(") < ");
            appendable.append(entry.getValue().toString());
            appendable.append("\n");
        }
    }
}

