/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.owlapi.explanation.io.manchester.ManchesterSyntaxObjectRenderer;
import com.clarkparsia.owlapi.explanation.io.manchester.TextBlockWriter;
import com.clarkparsia.pellet.owlapiv3.EntailmentChecker;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import java.io.PrintWriter;
import java.util.Set;
import org.mindswap.pellet.utils.FileUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletEntailment
extends PelletCmdApp {
    private String entailmentFile;
    private boolean findAll;

    @Override
    public String getAppId() {
        return "PelletEntailment: Check if all axioms are entailed by the ontology";
    }

    @Override
    public String getAppCmd() {
        return "pellet entail " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions pelletCmdOptions = this.getGlobalOptions();
        pelletCmdOptions.add(this.getIgnoreImportsOption());
        PelletCmdOption pelletCmdOption = new PelletCmdOption("entailment-file");
        pelletCmdOption.setShortOption("e");
        pelletCmdOption.setType("<file URI>");
        pelletCmdOption.setDescription("Entailment ontology URI");
        pelletCmdOption.setIsMandatory(true);
        pelletCmdOption.setArg(PelletCmdOptionArg.REQUIRED);
        pelletCmdOptions.add(pelletCmdOption);
        pelletCmdOption = new PelletCmdOption("all");
        pelletCmdOption.setShortOption("a");
        pelletCmdOption.setDefaultValue(false);
        pelletCmdOption.setDescription("Show all non-entailments");
        pelletCmdOption.setDefaultValue(this.findAll);
        pelletCmdOption.setIsMandatory(false);
        pelletCmdOption.setArg(PelletCmdOptionArg.NONE);
        pelletCmdOptions.add(pelletCmdOption);
        return pelletCmdOptions;
    }

    @Override
    public void run() {
        Object object;
        this.entailmentFile = this.options.getOption("entailment-file").getValueAsString();
        this.findAll = this.options.getOption("all").getValueAsBoolean();
        OWLAPILoader oWLAPILoader = (OWLAPILoader)this.getLoader("OWLAPIv3");
        this.getKB();
        PelletReasoner pelletReasoner = oWLAPILoader.getReasoner();
        OWLOntology oWLOntology = null;
        try {
            this.verbose("Loading entailment file: ");
            this.verbose(this.entailmentFile);
            object = IRI.create((String)FileUtils.toURI(this.entailmentFile));
            oWLOntology = oWLAPILoader.getManager().loadOntology((IRI)object);
        }
        catch (Exception exception) {
            throw new PelletCmdException(exception);
        }
        object = new EntailmentChecker(pelletReasoner);
        Set set = oWLOntology.getLogicalAxioms();
        this.verbose("Check entailments for (" + set.size() + ") axioms");
        this.startTask("Checking");
        Set<OWLAxiom> set2 = ((EntailmentChecker)object).findNonEntailments(set, this.findAll);
        this.finishTask("Checking");
        if (set2.isEmpty()) {
            this.output("All axioms are entailed.");
        } else {
            this.output("Non-entailments (" + set2.size() + "): ");
            int n = 1;
            TextBlockWriter textBlockWriter = new TextBlockWriter(new PrintWriter(System.out));
            ManchesterSyntaxObjectRenderer manchesterSyntaxObjectRenderer = new ManchesterSyntaxObjectRenderer(textBlockWriter);
            textBlockWriter.println();
            for (OWLAxiom oWLAxiom : set2) {
                textBlockWriter.print(n++);
                textBlockWriter.print(")");
                textBlockWriter.printSpace();
                textBlockWriter.startBlock();
                oWLAxiom.accept((OWLObjectVisitor)manchesterSyntaxObjectRenderer);
                textBlockWriter.endBlock();
                textBlockWriter.println();
            }
            textBlockWriter.flush();
        }
    }
}

