/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.TreeSet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOptions;

public class PelletUnsatisfiable
extends PelletCmdApp {
    @Override
    public String getAppCmd() {
        return "pellet unsatisfiable " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public String getAppId() {
        return "PelletUnsatisfiable: Find the unsatisfiable classes in the ontology";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions pelletCmdOptions = this.getGlobalOptions();
        pelletCmdOptions.add(this.getLoaderOption());
        pelletCmdOptions.add(this.getIgnoreImportsOption());
        pelletCmdOptions.add(this.getInputFormatOption());
        return pelletCmdOptions;
    }

    @Override
    public void run() {
        KnowledgeBase knowledgeBase = this.getKB();
        this.startTask("consistency check");
        boolean bl = knowledgeBase.isConsistent();
        this.finishTask("consistency check");
        if (!bl) {
            throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
        }
        QNameProvider qNameProvider = new QNameProvider();
        TreeSet<Object> treeSet = new TreeSet<Object>(Comparators.stringComparator);
        ProgressMonitor progressMonitor = PelletOptions.USE_CLASSIFICATION_MONITOR.create();
        progressMonitor.setProgressTitle("Finding unsatisfiable");
        progressMonitor.setProgressLength(knowledgeBase.getClasses().size());
        this.startTask("find unsatisfiable");
        progressMonitor.taskStarted();
        Iterator<ATermAppl> iterator = knowledgeBase.getClasses().iterator();
        while (iterator.hasNext()) {
            progressMonitor.incrementProgress();
            ATermAppl aTermAppl = iterator.next();
            if (knowledgeBase.isSatisfiable(aTermAppl)) continue;
            treeSet.add(qNameProvider.shortForm(aTermAppl.getName()));
        }
        progressMonitor.taskFinished();
        this.finishTask("find unsatisfiable");
        this.output("");
        if (treeSet.isEmpty()) {
            this.output("Found no unsatisfiable concepts.");
        } else {
            this.output("Found " + treeSet.size() + " unsatisfiable concept(s):");
            for (String string : treeSet) {
                this.output(string);
            }
        }
    }
}

