<!--- Copyright 2021 eprbell --->

<!--- Licensed under the Apache License, Version 2.0 (the "License"); --->
<!--- you may not use this file except in compliance with the License. --->
<!--- You may obtain a copy of the License at --->

<!---     http://www.apache.org/licenses/LICENSE-2.0 --->

<!--- Unless required by applicable law or agreed to in writing, software --->
<!--- distributed under the License is distributed on an "AS IS" BASIS, --->
<!--- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --->
<!--- See the License for the specific language governing permissions and --->
<!--- limitations under the License. --->

# RP2 Frequently Asked Questions (Developer)

## Table of Contents
* **[General Questions](#general-questions)**
  * [What are the Contribution Guidelines?](#what-are-the-contribution-guidelines)
  * [What are the Design Guidelines?](#what-are-the-design-guidelines)
  * [What is the Best Way to Get Started on RP2 Development?](#what-is-the-best-way-to-get-started-on-rpd-development)
  * [How to Develop a RP2 Report Generator Plugin?](#how-to-develop-a-rp2-report-generator-plugin)
  * [How to Develop a RP2 Accounting Method Plugin?](#how-to-develop-a-rp2-accounting-method-plugin)
  * [How to Develop a RP2 Country Plugin?](#how-to-develop-a-rp2-country-plugin)
  * [Why the Strange Directory Structure with Src?](#why-the-strange-directory-structure-with-src)

## General Questions

## What are the Contribution Guidelines?
Read the [contribution guidelines](../CONTRIBUTING.md#contributing-to-the-repository) section of the documentation.

## What are the Design Guidelines?
Read the [design guidelines](../README.dev.md#design-guidelines) section of the documentation.

## What is the Best Way to Get Started on RP2 Development?
Read the [contribution guidelines](../CONTRIBUTING.md#contributing-to-the-repository) and the [developer documentation](../README.dev.md) (especially the Plugin Development section). Then look for an unassigned [issue](https://github.com/eprbell/rp2/issues) that is marked as `good first issue`, or ask the project maintainers.

## How to Develop a RP2 Report Generator Plugin?
Read the [Adding a New Report Generator](../README.dev.md#adding-a-new-report-generator) section of the Developer Documentation.

## How to Develop a RP2 Accounting Method Plugin?
Read the [Adding a New Accounting Method](../README.dev.md#adding-a-new-accounting-method) section of the Developer Documentation.

## How to Develop a RP2 Country Plugin?
Read the [Adding a New Country](../README.dev.md#adding-support-for-a-new-country) section of the Developer Documentation.

## Why the Strange Directory Structure with Src?
Because RP2 is a [src](https://bskinn.github.io/My-How-Why-Pyproject-Src/)-[based](https://hynek.me/articles/testing-packaging/) [project](https://blog.ionelmc.ro/2014/05/25/python-packaging/).
