import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ActiveDirectoryDomainTrustConfig extends cdktf.TerraformMetaArguments {
    /**
     * The fully qualified domain name. e.g. mydomain.myorganization.com, with the restrictions,  https://cloud.google.com/managed-microsoft-ad/reference/rest/v1/projects.locations.global.domains.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#domain ActiveDirectoryDomainTrust#domain}
     *
     * @stability stable
     */
    readonly domain: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#project ActiveDirectoryDomainTrust#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Whether the trusted side has forest/domain wide access or selective access to an approved set of resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#selective_authentication ActiveDirectoryDomainTrust#selective_authentication}
     *
     * @stability stable
     */
    readonly selectiveAuthentication?: boolean;
    /**
     * The target DNS server IP addresses which can resolve the remote domain involved in the trust.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#target_dns_ip_addresses ActiveDirectoryDomainTrust#target_dns_ip_addresses}
     *
     * @stability stable
     */
    readonly targetDnsIpAddresses: string[];
    /**
     * The fully qualified target domain name which will be in trust with the current domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#target_domain_name ActiveDirectoryDomainTrust#target_domain_name}
     *
     * @stability stable
     */
    readonly targetDomainName: string;
    /**
     * The trust direction, which decides if the current domain is trusted, trusting, or both. Possible values: ["INBOUND", "OUTBOUND", "BIDIRECTIONAL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#trust_direction ActiveDirectoryDomainTrust#trust_direction}
     *
     * @stability stable
     */
    readonly trustDirection: string;
    /**
     * The trust secret used for the handshake with the target domain. This will not be stored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#trust_handshake_secret ActiveDirectoryDomainTrust#trust_handshake_secret}
     *
     * @stability stable
     */
    readonly trustHandshakeSecret: string;
    /**
     * The type of trust represented by the trust resource. Possible values: ["FOREST", "EXTERNAL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#trust_type ActiveDirectoryDomainTrust#trust_type}
     *
     * @stability stable
     */
    readonly trustType: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#timeouts ActiveDirectoryDomainTrust#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ActiveDirectoryDomainTrustTimeouts;
}
/**
 * @stability stable
 */
export interface ActiveDirectoryDomainTrustTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#create ActiveDirectoryDomainTrust#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#delete ActiveDirectoryDomainTrust#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html#update ActiveDirectoryDomainTrust#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html google_active_directory_domain_trust}.
 *
 * @stability stable
 */
export declare class ActiveDirectoryDomainTrust extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust.html google_active_directory_domain_trust} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ActiveDirectoryDomainTrustConfig);
    private _domain;
    /**
     * @stability stable
     */
    get domain(): string;
    /**
     * @stability stable
     */
    set domain(value: string);
    /**
     * @stability stable
     */
    get domainInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _selectiveAuthentication?;
    /**
     * @stability stable
     */
    get selectiveAuthentication(): boolean;
    /**
     * @stability stable
     */
    set selectiveAuthentication(value: boolean);
    /**
     * @stability stable
     */
    resetSelectiveAuthentication(): void;
    /**
     * @stability stable
     */
    get selectiveAuthenticationInput(): boolean | undefined;
    private _targetDnsIpAddresses;
    /**
     * @stability stable
     */
    get targetDnsIpAddresses(): string[];
    /**
     * @stability stable
     */
    set targetDnsIpAddresses(value: string[]);
    /**
     * @stability stable
     */
    get targetDnsIpAddressesInput(): string[];
    private _targetDomainName;
    /**
     * @stability stable
     */
    get targetDomainName(): string;
    /**
     * @stability stable
     */
    set targetDomainName(value: string);
    /**
     * @stability stable
     */
    get targetDomainNameInput(): string;
    private _trustDirection;
    /**
     * @stability stable
     */
    get trustDirection(): string;
    /**
     * @stability stable
     */
    set trustDirection(value: string);
    /**
     * @stability stable
     */
    get trustDirectionInput(): string;
    private _trustHandshakeSecret;
    /**
     * @stability stable
     */
    get trustHandshakeSecret(): string;
    /**
     * @stability stable
     */
    set trustHandshakeSecret(value: string);
    /**
     * @stability stable
     */
    get trustHandshakeSecretInput(): string;
    private _trustType;
    /**
     * @stability stable
     */
    get trustType(): string;
    /**
     * @stability stable
     */
    set trustType(value: string);
    /**
     * @stability stable
     */
    get trustTypeInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ActiveDirectoryDomainTrustTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ActiveDirectoryDomainTrustTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ActiveDirectoryDomainTrustTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
